/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.HubApiServerHostAlias;
import io.fabric8.openclustermanagement.api.model.operator.v1.HubApiServerHostAliasBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.HubApiServerHostAliasFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletDeployOption;
import io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletDeployOptionBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletDeployOptionFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletSpec;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationConfiguration;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationConfigurationBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationConfigurationFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.ResourceRequirement;
import io.fabric8.openclustermanagement.api.model.operator.v1.ResourceRequirementBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ResourceRequirementFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURLBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURLFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.WorkAgentConfiguration;
import io.fabric8.openclustermanagement.api.model.operator.v1.WorkAgentConfigurationBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.WorkAgentConfigurationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KlusterletSpecFluent<A extends KlusterletSpecFluent<A>>
extends BaseFluent<A> {
    private String clusterName;
    private KlusterletDeployOptionBuilder deployOption;
    private ArrayList<ServerURLBuilder> externalServerURLs = new ArrayList();
    private HubApiServerHostAliasBuilder hubApiServerHostAlias;
    private String imagePullSpec;
    private String namespace;
    private NodePlacementBuilder nodePlacement;
    private String priorityClassName;
    private RegistrationConfigurationBuilder registrationConfiguration;
    private String registrationImagePullSpec;
    private ResourceRequirementBuilder resourceRequirement;
    private WorkAgentConfigurationBuilder workConfiguration;
    private String workImagePullSpec;
    private Map<String, Object> additionalProperties;

    public KlusterletSpecFluent() {
    }

    public KlusterletSpecFluent(KlusterletSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KlusterletSpec instance) {
        KlusterletSpec klusterletSpec = instance = instance != null ? instance : new KlusterletSpec();
        if (instance != null) {
            this.withClusterName(instance.getClusterName());
            this.withDeployOption(instance.getDeployOption());
            this.withExternalServerURLs(instance.getExternalServerURLs());
            this.withHubApiServerHostAlias(instance.getHubApiServerHostAlias());
            this.withImagePullSpec(instance.getImagePullSpec());
            this.withNamespace(instance.getNamespace());
            this.withNodePlacement(instance.getNodePlacement());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withRegistrationConfiguration(instance.getRegistrationConfiguration());
            this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
            this.withResourceRequirement(instance.getResourceRequirement());
            this.withWorkConfiguration(instance.getWorkConfiguration());
            this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)((Object)this);
    }

    public boolean hasClusterName() {
        return this.clusterName != null;
    }

    public KlusterletDeployOption buildDeployOption() {
        return this.deployOption != null ? this.deployOption.build() : null;
    }

    public A withDeployOption(KlusterletDeployOption deployOption) {
        this._visitables.remove((Object)"deployOption");
        if (deployOption != null) {
            this.deployOption = new KlusterletDeployOptionBuilder(deployOption);
            this._visitables.get((Object)"deployOption").add(this.deployOption);
        } else {
            this.deployOption = null;
            this._visitables.get((Object)"deployOption").remove((Object)this.deployOption);
        }
        return (A)((Object)this);
    }

    public boolean hasDeployOption() {
        return this.deployOption != null;
    }

    public A withNewDeployOption(String mode) {
        return this.withDeployOption(new KlusterletDeployOption(mode));
    }

    public DeployOptionNested<A> withNewDeployOption() {
        return new DeployOptionNested(null);
    }

    public DeployOptionNested<A> withNewDeployOptionLike(KlusterletDeployOption item) {
        return new DeployOptionNested(item);
    }

    public DeployOptionNested<A> editDeployOption() {
        return this.withNewDeployOptionLike(Optional.ofNullable(this.buildDeployOption()).orElse(null));
    }

    public DeployOptionNested<A> editOrNewDeployOption() {
        return this.withNewDeployOptionLike(Optional.ofNullable(this.buildDeployOption()).orElse(new KlusterletDeployOptionBuilder().build()));
    }

    public DeployOptionNested<A> editOrNewDeployOptionLike(KlusterletDeployOption item) {
        return this.withNewDeployOptionLike(Optional.ofNullable(this.buildDeployOption()).orElse(item));
    }

    public A addToExternalServerURLs(int index, ServerURL item) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        ServerURLBuilder builder = new ServerURLBuilder(item);
        if (index < 0 || index >= this.externalServerURLs.size()) {
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        } else {
            this._visitables.get((Object)"externalServerURLs").add(index, builder);
            this.externalServerURLs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExternalServerURLs(int index, ServerURL item) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        ServerURLBuilder builder = new ServerURLBuilder(item);
        if (index < 0 || index >= this.externalServerURLs.size()) {
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        } else {
            this._visitables.get((Object)"externalServerURLs").set(index, builder);
            this.externalServerURLs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExternalServerURLs(ServerURL ... items) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExternalServerURLs(Collection<ServerURL> items) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExternalServerURLs(ServerURL ... items) {
        if (this.externalServerURLs == null) {
            return (A)((Object)this);
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").remove((Object)builder);
            this.externalServerURLs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExternalServerURLs(Collection<ServerURL> items) {
        if (this.externalServerURLs == null) {
            return (A)((Object)this);
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").remove((Object)builder);
            this.externalServerURLs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExternalServerURLs(Predicate<ServerURLBuilder> predicate) {
        if (this.externalServerURLs == null) {
            return (A)((Object)this);
        }
        Iterator<ServerURLBuilder> each = this.externalServerURLs.iterator();
        List visitables = this._visitables.get((Object)"externalServerURLs");
        while (each.hasNext()) {
            ServerURLBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServerURL> buildExternalServerURLs() {
        return this.externalServerURLs != null ? KlusterletSpecFluent.build(this.externalServerURLs) : null;
    }

    public ServerURL buildExternalServerURL(int index) {
        return this.externalServerURLs.get(index).build();
    }

    public ServerURL buildFirstExternalServerURL() {
        return this.externalServerURLs.get(0).build();
    }

    public ServerURL buildLastExternalServerURL() {
        return this.externalServerURLs.get(this.externalServerURLs.size() - 1).build();
    }

    public ServerURL buildMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        for (ServerURLBuilder item : this.externalServerURLs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        for (ServerURLBuilder item : this.externalServerURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExternalServerURLs(List<ServerURL> externalServerURLs) {
        if (this.externalServerURLs != null) {
            this._visitables.get((Object)"externalServerURLs").clear();
        }
        if (externalServerURLs != null) {
            this.externalServerURLs = new ArrayList();
            for (ServerURL item : externalServerURLs) {
                this.addToExternalServerURLs(item);
            }
        } else {
            this.externalServerURLs = null;
        }
        return (A)((Object)this);
    }

    public A withExternalServerURLs(ServerURL ... externalServerURLs) {
        if (this.externalServerURLs != null) {
            this.externalServerURLs.clear();
            this._visitables.remove((Object)"externalServerURLs");
        }
        if (externalServerURLs != null) {
            for (ServerURL item : externalServerURLs) {
                this.addToExternalServerURLs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExternalServerURLs() {
        return this.externalServerURLs != null && !this.externalServerURLs.isEmpty();
    }

    public A addNewExternalServerURL(String caBundle, String url) {
        return this.addToExternalServerURLs(new ServerURL(caBundle, url));
    }

    public ExternalServerURLsNested<A> addNewExternalServerURL() {
        return new ExternalServerURLsNested(-1, null);
    }

    public ExternalServerURLsNested<A> addNewExternalServerURLLike(ServerURL item) {
        return new ExternalServerURLsNested(-1, item);
    }

    public ExternalServerURLsNested<A> setNewExternalServerURLLike(int index, ServerURL item) {
        return new ExternalServerURLsNested(index, item);
    }

    public ExternalServerURLsNested<A> editExternalServerURL(int index) {
        if (this.externalServerURLs.size() <= index) {
            throw new RuntimeException("Can't edit externalServerURLs. Index exceeds size.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    public ExternalServerURLsNested<A> editFirstExternalServerURL() {
        if (this.externalServerURLs.size() == 0) {
            throw new RuntimeException("Can't edit first externalServerURLs. The list is empty.");
        }
        return this.setNewExternalServerURLLike(0, this.buildExternalServerURL(0));
    }

    public ExternalServerURLsNested<A> editLastExternalServerURL() {
        int index = this.externalServerURLs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last externalServerURLs. The list is empty.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    public ExternalServerURLsNested<A> editMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.externalServerURLs.size(); ++i) {
            if (!predicate.test(this.externalServerURLs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching externalServerURLs. No match found.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    public HubApiServerHostAlias buildHubApiServerHostAlias() {
        return this.hubApiServerHostAlias != null ? this.hubApiServerHostAlias.build() : null;
    }

    public A withHubApiServerHostAlias(HubApiServerHostAlias hubApiServerHostAlias) {
        this._visitables.remove((Object)"hubApiServerHostAlias");
        if (hubApiServerHostAlias != null) {
            this.hubApiServerHostAlias = new HubApiServerHostAliasBuilder(hubApiServerHostAlias);
            this._visitables.get((Object)"hubApiServerHostAlias").add(this.hubApiServerHostAlias);
        } else {
            this.hubApiServerHostAlias = null;
            this._visitables.get((Object)"hubApiServerHostAlias").remove((Object)this.hubApiServerHostAlias);
        }
        return (A)((Object)this);
    }

    public boolean hasHubApiServerHostAlias() {
        return this.hubApiServerHostAlias != null;
    }

    public A withNewHubApiServerHostAlias(String hostname, String ip) {
        return this.withHubApiServerHostAlias(new HubApiServerHostAlias(hostname, ip));
    }

    public HubApiServerHostAliasNested<A> withNewHubApiServerHostAlias() {
        return new HubApiServerHostAliasNested(null);
    }

    public HubApiServerHostAliasNested<A> withNewHubApiServerHostAliasLike(HubApiServerHostAlias item) {
        return new HubApiServerHostAliasNested(item);
    }

    public HubApiServerHostAliasNested<A> editHubApiServerHostAlias() {
        return this.withNewHubApiServerHostAliasLike(Optional.ofNullable(this.buildHubApiServerHostAlias()).orElse(null));
    }

    public HubApiServerHostAliasNested<A> editOrNewHubApiServerHostAlias() {
        return this.withNewHubApiServerHostAliasLike(Optional.ofNullable(this.buildHubApiServerHostAlias()).orElse(new HubApiServerHostAliasBuilder().build()));
    }

    public HubApiServerHostAliasNested<A> editOrNewHubApiServerHostAliasLike(HubApiServerHostAlias item) {
        return this.withNewHubApiServerHostAliasLike(Optional.ofNullable(this.buildHubApiServerHostAlias()).orElse(item));
    }

    public String getImagePullSpec() {
        return this.imagePullSpec;
    }

    public A withImagePullSpec(String imagePullSpec) {
        this.imagePullSpec = imagePullSpec;
        return (A)((Object)this);
    }

    public boolean hasImagePullSpec() {
        return this.imagePullSpec != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public NodePlacement buildNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    public A withNodePlacement(NodePlacement nodePlacement) {
        this._visitables.remove((Object)"nodePlacement");
        if (nodePlacement != null) {
            this.nodePlacement = new NodePlacementBuilder(nodePlacement);
            this._visitables.get((Object)"nodePlacement").add(this.nodePlacement);
        } else {
            this.nodePlacement = null;
            this._visitables.get((Object)"nodePlacement").remove((Object)this.nodePlacement);
        }
        return (A)((Object)this);
    }

    public boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    public NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNested(null);
    }

    public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
        return new NodePlacementNested(item);
    }

    public NodePlacementNested<A> editNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(null));
    }

    public NodePlacementNested<A> editOrNewNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
    }

    public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(item));
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)((Object)this);
    }

    public boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public RegistrationConfiguration buildRegistrationConfiguration() {
        return this.registrationConfiguration != null ? this.registrationConfiguration.build() : null;
    }

    public A withRegistrationConfiguration(RegistrationConfiguration registrationConfiguration) {
        this._visitables.remove((Object)"registrationConfiguration");
        if (registrationConfiguration != null) {
            this.registrationConfiguration = new RegistrationConfigurationBuilder(registrationConfiguration);
            this._visitables.get((Object)"registrationConfiguration").add(this.registrationConfiguration);
        } else {
            this.registrationConfiguration = null;
            this._visitables.get((Object)"registrationConfiguration").remove((Object)this.registrationConfiguration);
        }
        return (A)((Object)this);
    }

    public boolean hasRegistrationConfiguration() {
        return this.registrationConfiguration != null;
    }

    public RegistrationConfigurationNested<A> withNewRegistrationConfiguration() {
        return new RegistrationConfigurationNested(null);
    }

    public RegistrationConfigurationNested<A> withNewRegistrationConfigurationLike(RegistrationConfiguration item) {
        return new RegistrationConfigurationNested(item);
    }

    public RegistrationConfigurationNested<A> editRegistrationConfiguration() {
        return this.withNewRegistrationConfigurationLike(Optional.ofNullable(this.buildRegistrationConfiguration()).orElse(null));
    }

    public RegistrationConfigurationNested<A> editOrNewRegistrationConfiguration() {
        return this.withNewRegistrationConfigurationLike(Optional.ofNullable(this.buildRegistrationConfiguration()).orElse(new RegistrationConfigurationBuilder().build()));
    }

    public RegistrationConfigurationNested<A> editOrNewRegistrationConfigurationLike(RegistrationConfiguration item) {
        return this.withNewRegistrationConfigurationLike(Optional.ofNullable(this.buildRegistrationConfiguration()).orElse(item));
    }

    public String getRegistrationImagePullSpec() {
        return this.registrationImagePullSpec;
    }

    public A withRegistrationImagePullSpec(String registrationImagePullSpec) {
        this.registrationImagePullSpec = registrationImagePullSpec;
        return (A)((Object)this);
    }

    public boolean hasRegistrationImagePullSpec() {
        return this.registrationImagePullSpec != null;
    }

    public ResourceRequirement buildResourceRequirement() {
        return this.resourceRequirement != null ? this.resourceRequirement.build() : null;
    }

    public A withResourceRequirement(ResourceRequirement resourceRequirement) {
        this._visitables.remove((Object)"resourceRequirement");
        if (resourceRequirement != null) {
            this.resourceRequirement = new ResourceRequirementBuilder(resourceRequirement);
            this._visitables.get((Object)"resourceRequirement").add(this.resourceRequirement);
        } else {
            this.resourceRequirement = null;
            this._visitables.get((Object)"resourceRequirement").remove((Object)this.resourceRequirement);
        }
        return (A)((Object)this);
    }

    public boolean hasResourceRequirement() {
        return this.resourceRequirement != null;
    }

    public ResourceRequirementNested<A> withNewResourceRequirement() {
        return new ResourceRequirementNested(null);
    }

    public ResourceRequirementNested<A> withNewResourceRequirementLike(ResourceRequirement item) {
        return new ResourceRequirementNested(item);
    }

    public ResourceRequirementNested<A> editResourceRequirement() {
        return this.withNewResourceRequirementLike(Optional.ofNullable(this.buildResourceRequirement()).orElse(null));
    }

    public ResourceRequirementNested<A> editOrNewResourceRequirement() {
        return this.withNewResourceRequirementLike(Optional.ofNullable(this.buildResourceRequirement()).orElse(new ResourceRequirementBuilder().build()));
    }

    public ResourceRequirementNested<A> editOrNewResourceRequirementLike(ResourceRequirement item) {
        return this.withNewResourceRequirementLike(Optional.ofNullable(this.buildResourceRequirement()).orElse(item));
    }

    public WorkAgentConfiguration buildWorkConfiguration() {
        return this.workConfiguration != null ? this.workConfiguration.build() : null;
    }

    public A withWorkConfiguration(WorkAgentConfiguration workConfiguration) {
        this._visitables.remove((Object)"workConfiguration");
        if (workConfiguration != null) {
            this.workConfiguration = new WorkAgentConfigurationBuilder(workConfiguration);
            this._visitables.get((Object)"workConfiguration").add(this.workConfiguration);
        } else {
            this.workConfiguration = null;
            this._visitables.get((Object)"workConfiguration").remove((Object)this.workConfiguration);
        }
        return (A)((Object)this);
    }

    public boolean hasWorkConfiguration() {
        return this.workConfiguration != null;
    }

    public WorkConfigurationNested<A> withNewWorkConfiguration() {
        return new WorkConfigurationNested(null);
    }

    public WorkConfigurationNested<A> withNewWorkConfigurationLike(WorkAgentConfiguration item) {
        return new WorkConfigurationNested(item);
    }

    public WorkConfigurationNested<A> editWorkConfiguration() {
        return this.withNewWorkConfigurationLike(Optional.ofNullable(this.buildWorkConfiguration()).orElse(null));
    }

    public WorkConfigurationNested<A> editOrNewWorkConfiguration() {
        return this.withNewWorkConfigurationLike(Optional.ofNullable(this.buildWorkConfiguration()).orElse(new WorkAgentConfigurationBuilder().build()));
    }

    public WorkConfigurationNested<A> editOrNewWorkConfigurationLike(WorkAgentConfiguration item) {
        return this.withNewWorkConfigurationLike(Optional.ofNullable(this.buildWorkConfiguration()).orElse(item));
    }

    public String getWorkImagePullSpec() {
        return this.workImagePullSpec;
    }

    public A withWorkImagePullSpec(String workImagePullSpec) {
        this.workImagePullSpec = workImagePullSpec;
        return (A)((Object)this);
    }

    public boolean hasWorkImagePullSpec() {
        return this.workImagePullSpec != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KlusterletSpecFluent that = (KlusterletSpecFluent)((Object)o);
        if (!Objects.equals(this.clusterName, that.clusterName)) {
            return false;
        }
        if (!Objects.equals((Object)this.deployOption, (Object)that.deployOption)) {
            return false;
        }
        if (!Objects.equals(this.externalServerURLs, that.externalServerURLs)) {
            return false;
        }
        if (!Objects.equals((Object)this.hubApiServerHostAlias, (Object)that.hubApiServerHostAlias)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSpec, that.imagePullSpec)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodePlacement, (Object)that.nodePlacement)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals((Object)this.registrationConfiguration, (Object)that.registrationConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.registrationImagePullSpec, that.registrationImagePullSpec)) {
            return false;
        }
        if (!Objects.equals((Object)this.resourceRequirement, (Object)that.resourceRequirement)) {
            return false;
        }
        if (!Objects.equals((Object)this.workConfiguration, (Object)that.workConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.workImagePullSpec, that.workImagePullSpec)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterName, this.deployOption, this.externalServerURLs, this.hubApiServerHostAlias, this.imagePullSpec, this.namespace, this.nodePlacement, this.priorityClassName, this.registrationConfiguration, this.registrationImagePullSpec, this.resourceRequirement, this.workConfiguration, this.workImagePullSpec, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName + ",");
        }
        if (this.deployOption != null) {
            sb.append("deployOption:");
            sb.append(this.deployOption + ",");
        }
        if (this.externalServerURLs != null && !this.externalServerURLs.isEmpty()) {
            sb.append("externalServerURLs:");
            sb.append(this.externalServerURLs + ",");
        }
        if (this.hubApiServerHostAlias != null) {
            sb.append("hubApiServerHostAlias:");
            sb.append(this.hubApiServerHostAlias + ",");
        }
        if (this.imagePullSpec != null) {
            sb.append("imagePullSpec:");
            sb.append(this.imagePullSpec + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.nodePlacement != null) {
            sb.append("nodePlacement:");
            sb.append(this.nodePlacement + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.registrationConfiguration != null) {
            sb.append("registrationConfiguration:");
            sb.append(this.registrationConfiguration + ",");
        }
        if (this.registrationImagePullSpec != null) {
            sb.append("registrationImagePullSpec:");
            sb.append(this.registrationImagePullSpec + ",");
        }
        if (this.resourceRequirement != null) {
            sb.append("resourceRequirement:");
            sb.append(this.resourceRequirement + ",");
        }
        if (this.workConfiguration != null) {
            sb.append("workConfiguration:");
            sb.append(this.workConfiguration + ",");
        }
        if (this.workImagePullSpec != null) {
            sb.append("workImagePullSpec:");
            sb.append(this.workImagePullSpec + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WorkConfigurationNested<N>
    extends WorkAgentConfigurationFluent<WorkConfigurationNested<N>>
    implements Nested<N> {
        WorkAgentConfigurationBuilder builder;

        WorkConfigurationNested(WorkAgentConfiguration item) {
            this.builder = new WorkAgentConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.withWorkConfiguration(this.builder.build());
        }

        public N endWorkConfiguration() {
            return this.and();
        }
    }

    public class ResourceRequirementNested<N>
    extends ResourceRequirementFluent<ResourceRequirementNested<N>>
    implements Nested<N> {
        ResourceRequirementBuilder builder;

        ResourceRequirementNested(ResourceRequirement item) {
            this.builder = new ResourceRequirementBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.withResourceRequirement(this.builder.build());
        }

        public N endResourceRequirement() {
            return this.and();
        }
    }

    public class RegistrationConfigurationNested<N>
    extends RegistrationConfigurationFluent<RegistrationConfigurationNested<N>>
    implements Nested<N> {
        RegistrationConfigurationBuilder builder;

        RegistrationConfigurationNested(RegistrationConfiguration item) {
            this.builder = new RegistrationConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.withRegistrationConfiguration(this.builder.build());
        }

        public N endRegistrationConfiguration() {
            return this.and();
        }
    }

    public class NodePlacementNested<N>
    extends NodePlacementFluent<NodePlacementNested<N>>
    implements Nested<N> {
        NodePlacementBuilder builder;

        NodePlacementNested(NodePlacement item) {
            this.builder = new NodePlacementBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.withNodePlacement(this.builder.build());
        }

        public N endNodePlacement() {
            return this.and();
        }
    }

    public class HubApiServerHostAliasNested<N>
    extends HubApiServerHostAliasFluent<HubApiServerHostAliasNested<N>>
    implements Nested<N> {
        HubApiServerHostAliasBuilder builder;

        HubApiServerHostAliasNested(HubApiServerHostAlias item) {
            this.builder = new HubApiServerHostAliasBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.withHubApiServerHostAlias(this.builder.build());
        }

        public N endHubApiServerHostAlias() {
            return this.and();
        }
    }

    public class ExternalServerURLsNested<N>
    extends ServerURLFluent<ExternalServerURLsNested<N>>
    implements Nested<N> {
        ServerURLBuilder builder;
        int index;

        ExternalServerURLsNested(int index, ServerURL item) {
            this.index = index;
            this.builder = new ServerURLBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.setToExternalServerURLs(this.index, this.builder.build());
        }

        public N endExternalServerURL() {
            return this.and();
        }
    }

    public class DeployOptionNested<N>
    extends KlusterletDeployOptionFluent<DeployOptionNested<N>>
    implements Nested<N> {
        KlusterletDeployOptionBuilder builder;

        DeployOptionNested(KlusterletDeployOption item) {
            this.builder = new KlusterletDeployOptionBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.withDeployOption(this.builder.build());
        }

        public N endDeployOption() {
            return this.and();
        }
    }
}

