/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.ComponentConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.ComponentConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ComponentConfigFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.Overrides;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OverridesFluent<A extends OverridesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ComponentConfigBuilder> components = new ArrayList();
    private String imagePullPolicy;
    private Map<String, Object> additionalProperties;

    public OverridesFluent() {
    }

    public OverridesFluent(Overrides instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Overrides instance) {
        Overrides overrides = instance = instance != null ? instance : new Overrides();
        if (instance != null) {
            this.withComponents(instance.getComponents());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToComponents(int index, ComponentConfig item) {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
        if (index < 0 || index >= this.components.size()) {
            this._visitables.get((Object)"components").add(builder);
            this.components.add(builder);
        } else {
            this._visitables.get((Object)"components").add(index, builder);
            this.components.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToComponents(int index, ComponentConfig item) {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
        if (index < 0 || index >= this.components.size()) {
            this._visitables.get((Object)"components").add(builder);
            this.components.add(builder);
        } else {
            this._visitables.get((Object)"components").set(index, builder);
            this.components.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToComponents(ComponentConfig ... items) {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        for (ComponentConfig item : items) {
            ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
            this._visitables.get((Object)"components").add(builder);
            this.components.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToComponents(Collection<ComponentConfig> items) {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        for (ComponentConfig item : items) {
            ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
            this._visitables.get((Object)"components").add(builder);
            this.components.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromComponents(ComponentConfig ... items) {
        if (this.components == null) {
            return (A)((Object)this);
        }
        for (ComponentConfig item : items) {
            ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
            this._visitables.get((Object)"components").remove((Object)builder);
            this.components.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComponents(Collection<ComponentConfig> items) {
        if (this.components == null) {
            return (A)((Object)this);
        }
        for (ComponentConfig item : items) {
            ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
            this._visitables.get((Object)"components").remove((Object)builder);
            this.components.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromComponents(Predicate<ComponentConfigBuilder> predicate) {
        if (this.components == null) {
            return (A)((Object)this);
        }
        Iterator<ComponentConfigBuilder> each = this.components.iterator();
        List visitables = this._visitables.get((Object)"components");
        while (each.hasNext()) {
            ComponentConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ComponentConfig> buildComponents() {
        return this.components != null ? OverridesFluent.build(this.components) : null;
    }

    public ComponentConfig buildComponent(int index) {
        return this.components.get(index).build();
    }

    public ComponentConfig buildFirstComponent() {
        return this.components.get(0).build();
    }

    public ComponentConfig buildLastComponent() {
        return this.components.get(this.components.size() - 1).build();
    }

    public ComponentConfig buildMatchingComponent(Predicate<ComponentConfigBuilder> predicate) {
        for (ComponentConfigBuilder item : this.components) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingComponent(Predicate<ComponentConfigBuilder> predicate) {
        for (ComponentConfigBuilder item : this.components) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComponents(List<ComponentConfig> components) {
        if (this.components != null) {
            this._visitables.get((Object)"components").clear();
        }
        if (components != null) {
            this.components = new ArrayList();
            for (ComponentConfig item : components) {
                this.addToComponents(item);
            }
        } else {
            this.components = null;
        }
        return (A)((Object)this);
    }

    public A withComponents(ComponentConfig ... components) {
        if (this.components != null) {
            this.components.clear();
            this._visitables.remove((Object)"components");
        }
        if (components != null) {
            for (ComponentConfig item : components) {
                this.addToComponents(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasComponents() {
        return this.components != null && !this.components.isEmpty();
    }

    public A addNewComponent(Boolean enabled, String name) {
        return this.addToComponents(new ComponentConfig(enabled, name));
    }

    public ComponentsNested<A> addNewComponent() {
        return new ComponentsNested(-1, null);
    }

    public ComponentsNested<A> addNewComponentLike(ComponentConfig item) {
        return new ComponentsNested(-1, item);
    }

    public ComponentsNested<A> setNewComponentLike(int index, ComponentConfig item) {
        return new ComponentsNested(index, item);
    }

    public ComponentsNested<A> editComponent(int index) {
        if (this.components.size() <= index) {
            throw new RuntimeException("Can't edit components. Index exceeds size.");
        }
        return this.setNewComponentLike(index, this.buildComponent(index));
    }

    public ComponentsNested<A> editFirstComponent() {
        if (this.components.size() == 0) {
            throw new RuntimeException("Can't edit first components. The list is empty.");
        }
        return this.setNewComponentLike(0, this.buildComponent(0));
    }

    public ComponentsNested<A> editLastComponent() {
        int index = this.components.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last components. The list is empty.");
        }
        return this.setNewComponentLike(index, this.buildComponent(index));
    }

    public ComponentsNested<A> editMatchingComponent(Predicate<ComponentConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.components.size(); ++i) {
            if (!predicate.test(this.components.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching components. No match found.");
        }
        return this.setNewComponentLike(index, this.buildComponent(index));
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OverridesFluent that = (OverridesFluent)((Object)o);
        if (!Objects.equals(this.components, that.components)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.imagePullPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.components != null && !this.components.isEmpty()) {
            sb.append("components:");
            sb.append(this.components + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ComponentsNested<N>
    extends ComponentConfigFluent<ComponentsNested<N>>
    implements Nested<N> {
        ComponentConfigBuilder builder;
        int index;

        ComponentsNested(int index, ComponentConfig item) {
            this.index = index;
            this.builder = new ComponentConfigBuilder(this, item);
        }

        public N and() {
            return (N)OverridesFluent.this.setToComponents(this.index, this.builder.build());
        }

        public N endComponent() {
            return this.and();
        }
    }
}

