/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.AwsIrsa;
import io.fabric8.openclustermanagement.api.model.operator.v1.AwsIrsaBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.AwsIrsaFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriver;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RegistrationDriverFluent<A extends RegistrationDriverFluent<A>>
extends BaseFluent<A> {
    private String authType;
    private AwsIrsaBuilder awsIrsa;
    private Map<String, Object> additionalProperties;

    public RegistrationDriverFluent() {
    }

    public RegistrationDriverFluent(RegistrationDriver instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RegistrationDriver instance) {
        RegistrationDriver registrationDriver = instance = instance != null ? instance : new RegistrationDriver();
        if (instance != null) {
            this.withAuthType(instance.getAuthType());
            this.withAwsIrsa(instance.getAwsIrsa());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public A withAuthType(String authType) {
        this.authType = authType;
        return (A)((Object)this);
    }

    public boolean hasAuthType() {
        return this.authType != null;
    }

    public AwsIrsa buildAwsIrsa() {
        return this.awsIrsa != null ? this.awsIrsa.build() : null;
    }

    public A withAwsIrsa(AwsIrsa awsIrsa) {
        this._visitables.remove((Object)"awsIrsa");
        if (awsIrsa != null) {
            this.awsIrsa = new AwsIrsaBuilder(awsIrsa);
            this._visitables.get((Object)"awsIrsa").add(this.awsIrsa);
        } else {
            this.awsIrsa = null;
            this._visitables.get((Object)"awsIrsa").remove((Object)this.awsIrsa);
        }
        return (A)((Object)this);
    }

    public boolean hasAwsIrsa() {
        return this.awsIrsa != null;
    }

    public A withNewAwsIrsa(String hubClusterArn, String managedClusterArn) {
        return this.withAwsIrsa(new AwsIrsa(hubClusterArn, managedClusterArn));
    }

    public AwsIrsaNested<A> withNewAwsIrsa() {
        return new AwsIrsaNested(null);
    }

    public AwsIrsaNested<A> withNewAwsIrsaLike(AwsIrsa item) {
        return new AwsIrsaNested(item);
    }

    public AwsIrsaNested<A> editAwsIrsa() {
        return this.withNewAwsIrsaLike(Optional.ofNullable(this.buildAwsIrsa()).orElse(null));
    }

    public AwsIrsaNested<A> editOrNewAwsIrsa() {
        return this.withNewAwsIrsaLike(Optional.ofNullable(this.buildAwsIrsa()).orElse(new AwsIrsaBuilder().build()));
    }

    public AwsIrsaNested<A> editOrNewAwsIrsaLike(AwsIrsa item) {
        return this.withNewAwsIrsaLike(Optional.ofNullable(this.buildAwsIrsa()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationDriverFluent that = (RegistrationDriverFluent)((Object)o);
        if (!Objects.equals(this.authType, that.authType)) {
            return false;
        }
        if (!Objects.equals((Object)this.awsIrsa, (Object)that.awsIrsa)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authType, this.awsIrsa, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authType != null) {
            sb.append("authType:");
            sb.append(this.authType + ",");
        }
        if (this.awsIrsa != null) {
            sb.append("awsIrsa:");
            sb.append(this.awsIrsa + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AwsIrsaNested<N>
    extends AwsIrsaFluent<AwsIrsaNested<N>>
    implements Nested<N> {
        AwsIrsaBuilder builder;

        AwsIrsaNested(AwsIrsa item) {
            this.builder = new AwsIrsaBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationDriverFluent.this.withAwsIrsa(this.builder.build());
        }

        public N endAwsIrsa() {
            return this.and();
        }
    }
}

