/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependency;
import io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependencyBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependencyFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1.PolicyTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicyTemplateFluent<A extends PolicyTemplateFluent<A>>
extends BaseFluent<A> {
    private ArrayList<PolicyDependencyBuilder> extraDependencies = new ArrayList();
    private Boolean ignorePending;
    private Object objectDefinition;
    private Map<String, Object> additionalProperties;

    public PolicyTemplateFluent() {
    }

    public PolicyTemplateFluent(PolicyTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PolicyTemplate instance) {
        PolicyTemplate policyTemplate = instance = instance != null ? instance : new PolicyTemplate();
        if (instance != null) {
            this.withExtraDependencies(instance.getExtraDependencies());
            this.withIgnorePending(instance.getIgnorePending());
            this.withObjectDefinition(instance.getObjectDefinition());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToExtraDependencies(int index, PolicyDependency item) {
        if (this.extraDependencies == null) {
            this.extraDependencies = new ArrayList();
        }
        PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
        if (index < 0 || index >= this.extraDependencies.size()) {
            this._visitables.get((Object)"extraDependencies").add(builder);
            this.extraDependencies.add(builder);
        } else {
            this._visitables.get((Object)"extraDependencies").add(index, builder);
            this.extraDependencies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExtraDependencies(int index, PolicyDependency item) {
        if (this.extraDependencies == null) {
            this.extraDependencies = new ArrayList();
        }
        PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
        if (index < 0 || index >= this.extraDependencies.size()) {
            this._visitables.get((Object)"extraDependencies").add(builder);
            this.extraDependencies.add(builder);
        } else {
            this._visitables.get((Object)"extraDependencies").set(index, builder);
            this.extraDependencies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExtraDependencies(PolicyDependency ... items) {
        if (this.extraDependencies == null) {
            this.extraDependencies = new ArrayList();
        }
        for (PolicyDependency item : items) {
            PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
            this._visitables.get((Object)"extraDependencies").add(builder);
            this.extraDependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExtraDependencies(Collection<PolicyDependency> items) {
        if (this.extraDependencies == null) {
            this.extraDependencies = new ArrayList();
        }
        for (PolicyDependency item : items) {
            PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
            this._visitables.get((Object)"extraDependencies").add(builder);
            this.extraDependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExtraDependencies(PolicyDependency ... items) {
        if (this.extraDependencies == null) {
            return (A)((Object)this);
        }
        for (PolicyDependency item : items) {
            PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
            this._visitables.get((Object)"extraDependencies").remove((Object)builder);
            this.extraDependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtraDependencies(Collection<PolicyDependency> items) {
        if (this.extraDependencies == null) {
            return (A)((Object)this);
        }
        for (PolicyDependency item : items) {
            PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
            this._visitables.get((Object)"extraDependencies").remove((Object)builder);
            this.extraDependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtraDependencies(Predicate<PolicyDependencyBuilder> predicate) {
        if (this.extraDependencies == null) {
            return (A)((Object)this);
        }
        Iterator<PolicyDependencyBuilder> each = this.extraDependencies.iterator();
        List visitables = this._visitables.get((Object)"extraDependencies");
        while (each.hasNext()) {
            PolicyDependencyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PolicyDependency> buildExtraDependencies() {
        return this.extraDependencies != null ? PolicyTemplateFluent.build(this.extraDependencies) : null;
    }

    public PolicyDependency buildExtraDependency(int index) {
        return this.extraDependencies.get(index).build();
    }

    public PolicyDependency buildFirstExtraDependency() {
        return this.extraDependencies.get(0).build();
    }

    public PolicyDependency buildLastExtraDependency() {
        return this.extraDependencies.get(this.extraDependencies.size() - 1).build();
    }

    public PolicyDependency buildMatchingExtraDependency(Predicate<PolicyDependencyBuilder> predicate) {
        for (PolicyDependencyBuilder item : this.extraDependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtraDependency(Predicate<PolicyDependencyBuilder> predicate) {
        for (PolicyDependencyBuilder item : this.extraDependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtraDependencies(List<PolicyDependency> extraDependencies) {
        if (this.extraDependencies != null) {
            this._visitables.get((Object)"extraDependencies").clear();
        }
        if (extraDependencies != null) {
            this.extraDependencies = new ArrayList();
            for (PolicyDependency item : extraDependencies) {
                this.addToExtraDependencies(item);
            }
        } else {
            this.extraDependencies = null;
        }
        return (A)((Object)this);
    }

    public A withExtraDependencies(PolicyDependency ... extraDependencies) {
        if (this.extraDependencies != null) {
            this.extraDependencies.clear();
            this._visitables.remove((Object)"extraDependencies");
        }
        if (extraDependencies != null) {
            for (PolicyDependency item : extraDependencies) {
                this.addToExtraDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtraDependencies() {
        return this.extraDependencies != null && !this.extraDependencies.isEmpty();
    }

    public A addNewExtraDependency(String apiVersion, String compliance, String kind, String name, String namespace) {
        return this.addToExtraDependencies(new PolicyDependency(apiVersion, compliance, kind, name, namespace));
    }

    public ExtraDependenciesNested<A> addNewExtraDependency() {
        return new ExtraDependenciesNested(-1, null);
    }

    public ExtraDependenciesNested<A> addNewExtraDependencyLike(PolicyDependency item) {
        return new ExtraDependenciesNested(-1, item);
    }

    public ExtraDependenciesNested<A> setNewExtraDependencyLike(int index, PolicyDependency item) {
        return new ExtraDependenciesNested(index, item);
    }

    public ExtraDependenciesNested<A> editExtraDependency(int index) {
        if (this.extraDependencies.size() <= index) {
            throw new RuntimeException("Can't edit extraDependencies. Index exceeds size.");
        }
        return this.setNewExtraDependencyLike(index, this.buildExtraDependency(index));
    }

    public ExtraDependenciesNested<A> editFirstExtraDependency() {
        if (this.extraDependencies.size() == 0) {
            throw new RuntimeException("Can't edit first extraDependencies. The list is empty.");
        }
        return this.setNewExtraDependencyLike(0, this.buildExtraDependency(0));
    }

    public ExtraDependenciesNested<A> editLastExtraDependency() {
        int index = this.extraDependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extraDependencies. The list is empty.");
        }
        return this.setNewExtraDependencyLike(index, this.buildExtraDependency(index));
    }

    public ExtraDependenciesNested<A> editMatchingExtraDependency(Predicate<PolicyDependencyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extraDependencies.size(); ++i) {
            if (!predicate.test(this.extraDependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extraDependencies. No match found.");
        }
        return this.setNewExtraDependencyLike(index, this.buildExtraDependency(index));
    }

    public Boolean getIgnorePending() {
        return this.ignorePending;
    }

    public A withIgnorePending(Boolean ignorePending) {
        this.ignorePending = ignorePending;
        return (A)((Object)this);
    }

    public boolean hasIgnorePending() {
        return this.ignorePending != null;
    }

    public Object getObjectDefinition() {
        return this.objectDefinition;
    }

    public A withObjectDefinition(Object objectDefinition) {
        this.objectDefinition = objectDefinition;
        return (A)((Object)this);
    }

    public boolean hasObjectDefinition() {
        return this.objectDefinition != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyTemplateFluent that = (PolicyTemplateFluent)((Object)o);
        if (!Objects.equals(this.extraDependencies, that.extraDependencies)) {
            return false;
        }
        if (!Objects.equals(this.ignorePending, that.ignorePending)) {
            return false;
        }
        if (!Objects.equals(this.objectDefinition, that.objectDefinition)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.extraDependencies, this.ignorePending, this.objectDefinition, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.extraDependencies != null && !this.extraDependencies.isEmpty()) {
            sb.append("extraDependencies:");
            sb.append(this.extraDependencies + ",");
        }
        if (this.ignorePending != null) {
            sb.append("ignorePending:");
            sb.append(this.ignorePending + ",");
        }
        if (this.objectDefinition != null) {
            sb.append("objectDefinition:");
            sb.append(this.objectDefinition + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIgnorePending() {
        return this.withIgnorePending(true);
    }

    public class ExtraDependenciesNested<N>
    extends PolicyDependencyFluent<ExtraDependenciesNested<N>>
    implements Nested<N> {
        PolicyDependencyBuilder builder;
        int index;

        ExtraDependenciesNested(int index, PolicyDependency item) {
            this.index = index;
            this.builder = new PolicyDependencyBuilder(this, item);
        }

        public N and() {
            return (N)PolicyTemplateFluent.this.setToExtraDependencies(this.index, this.builder.build());
        }

        public N endExtraDependency() {
            return this.and();
        }
    }
}

