/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedDetailsPerTemplate;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedDetailsPerTemplateBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedDetailsPerTemplateFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedPolicyStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ReplicatedPolicyStatusFluent<A extends ReplicatedPolicyStatusFluent<A>>
extends BaseFluent<A> {
    private String compliant;
    private ArrayList<ReplicatedDetailsPerTemplateBuilder> details = new ArrayList();
    private String violationMessage;
    private Map<String, Object> additionalProperties;

    public ReplicatedPolicyStatusFluent() {
    }

    public ReplicatedPolicyStatusFluent(ReplicatedPolicyStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ReplicatedPolicyStatus instance) {
        ReplicatedPolicyStatus replicatedPolicyStatus = instance = instance != null ? instance : new ReplicatedPolicyStatus();
        if (instance != null) {
            this.withCompliant(instance.getCompliant());
            this.withDetails(instance.getDetails());
            this.withViolationMessage(instance.getViolationMessage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCompliant() {
        return this.compliant;
    }

    public A withCompliant(String compliant) {
        this.compliant = compliant;
        return (A)((Object)this);
    }

    public boolean hasCompliant() {
        return this.compliant != null;
    }

    public A addToDetails(int index, ReplicatedDetailsPerTemplate item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        ReplicatedDetailsPerTemplateBuilder builder = new ReplicatedDetailsPerTemplateBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").add(index, builder);
            this.details.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDetails(int index, ReplicatedDetailsPerTemplate item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        ReplicatedDetailsPerTemplateBuilder builder = new ReplicatedDetailsPerTemplateBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").set(index, builder);
            this.details.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDetails(ReplicatedDetailsPerTemplate ... items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (ReplicatedDetailsPerTemplate item : items) {
            ReplicatedDetailsPerTemplateBuilder builder = new ReplicatedDetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDetails(Collection<ReplicatedDetailsPerTemplate> items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (ReplicatedDetailsPerTemplate item : items) {
            ReplicatedDetailsPerTemplateBuilder builder = new ReplicatedDetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDetails(ReplicatedDetailsPerTemplate ... items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (ReplicatedDetailsPerTemplate item : items) {
            ReplicatedDetailsPerTemplateBuilder builder = new ReplicatedDetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDetails(Collection<ReplicatedDetailsPerTemplate> items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (ReplicatedDetailsPerTemplate item : items) {
            ReplicatedDetailsPerTemplateBuilder builder = new ReplicatedDetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDetails(Predicate<ReplicatedDetailsPerTemplateBuilder> predicate) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        Iterator<ReplicatedDetailsPerTemplateBuilder> each = this.details.iterator();
        List visitables = this._visitables.get((Object)"details");
        while (each.hasNext()) {
            ReplicatedDetailsPerTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ReplicatedDetailsPerTemplate> buildDetails() {
        return this.details != null ? ReplicatedPolicyStatusFluent.build(this.details) : null;
    }

    public ReplicatedDetailsPerTemplate buildDetail(int index) {
        return this.details.get(index).build();
    }

    public ReplicatedDetailsPerTemplate buildFirstDetail() {
        return this.details.get(0).build();
    }

    public ReplicatedDetailsPerTemplate buildLastDetail() {
        return this.details.get(this.details.size() - 1).build();
    }

    public ReplicatedDetailsPerTemplate buildMatchingDetail(Predicate<ReplicatedDetailsPerTemplateBuilder> predicate) {
        for (ReplicatedDetailsPerTemplateBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDetail(Predicate<ReplicatedDetailsPerTemplateBuilder> predicate) {
        for (ReplicatedDetailsPerTemplateBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDetails(List<ReplicatedDetailsPerTemplate> details) {
        if (this.details != null) {
            this._visitables.get((Object)"details").clear();
        }
        if (details != null) {
            this.details = new ArrayList();
            for (ReplicatedDetailsPerTemplate item : details) {
                this.addToDetails(item);
            }
        } else {
            this.details = null;
        }
        return (A)((Object)this);
    }

    public A withDetails(ReplicatedDetailsPerTemplate ... details) {
        if (this.details != null) {
            this.details.clear();
            this._visitables.remove((Object)"details");
        }
        if (details != null) {
            for (ReplicatedDetailsPerTemplate item : details) {
                this.addToDetails(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    public DetailsNested<A> addNewDetail() {
        return new DetailsNested(-1, null);
    }

    public DetailsNested<A> addNewDetailLike(ReplicatedDetailsPerTemplate item) {
        return new DetailsNested(-1, item);
    }

    public DetailsNested<A> setNewDetailLike(int index, ReplicatedDetailsPerTemplate item) {
        return new DetailsNested(index, item);
    }

    public DetailsNested<A> editDetail(int index) {
        if (this.details.size() <= index) {
            throw new RuntimeException("Can't edit details. Index exceeds size.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editFirstDetail() {
        if (this.details.size() == 0) {
            throw new RuntimeException("Can't edit first details. The list is empty.");
        }
        return this.setNewDetailLike(0, this.buildDetail(0));
    }

    public DetailsNested<A> editLastDetail() {
        int index = this.details.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last details. The list is empty.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editMatchingDetail(Predicate<ReplicatedDetailsPerTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.details.size(); ++i) {
            if (!predicate.test(this.details.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching details. No match found.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public String getViolationMessage() {
        return this.violationMessage;
    }

    public A withViolationMessage(String violationMessage) {
        this.violationMessage = violationMessage;
        return (A)((Object)this);
    }

    public boolean hasViolationMessage() {
        return this.violationMessage != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicatedPolicyStatusFluent that = (ReplicatedPolicyStatusFluent)((Object)o);
        if (!Objects.equals(this.compliant, that.compliant)) {
            return false;
        }
        if (!Objects.equals(this.details, that.details)) {
            return false;
        }
        if (!Objects.equals(this.violationMessage, that.violationMessage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compliant, this.details, this.violationMessage, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliant != null) {
            sb.append("compliant:");
            sb.append(this.compliant + ",");
        }
        if (this.details != null && !this.details.isEmpty()) {
            sb.append("details:");
            sb.append(this.details + ",");
        }
        if (this.violationMessage != null) {
            sb.append("violationMessage:");
            sb.append(this.violationMessage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DetailsNested<N>
    extends ReplicatedDetailsPerTemplateFluent<DetailsNested<N>>
    implements Nested<N> {
        ReplicatedDetailsPerTemplateBuilder builder;
        int index;

        DetailsNested(int index, ReplicatedDetailsPerTemplate item) {
            this.index = index;
            this.builder = new ReplicatedDetailsPerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ReplicatedPolicyStatusFluent.this.setToDetails(this.index, this.builder.build());
        }

        public N endDetail() {
            return this.and();
        }
    }
}

