/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedPolicyStatus;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ViolationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ViolationContextFluent<A extends ViolationContextFluent<A>>
extends BaseFluent<A> {
    private String hubCluster;
    private String policyName;
    private String policyNamespace;
    private List<String> policySets = new ArrayList<String>();
    private Map<String, ReplicatedPolicyStatus> policyViolations;
    private List<String> targetClusters = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ViolationContextFluent() {
    }

    public ViolationContextFluent(ViolationContext instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ViolationContext instance) {
        ViolationContext violationContext = instance = instance != null ? instance : new ViolationContext();
        if (instance != null) {
            this.withHubCluster(instance.getHubCluster());
            this.withPolicyName(instance.getPolicyName());
            this.withPolicyNamespace(instance.getPolicyNamespace());
            this.withPolicySets(instance.getPolicySets());
            this.withPolicyViolations(instance.getPolicyViolations());
            this.withTargetClusters(instance.getTargetClusters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHubCluster() {
        return this.hubCluster;
    }

    public A withHubCluster(String hubCluster) {
        this.hubCluster = hubCluster;
        return (A)((Object)this);
    }

    public boolean hasHubCluster() {
        return this.hubCluster != null;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public A withPolicyName(String policyName) {
        this.policyName = policyName;
        return (A)((Object)this);
    }

    public boolean hasPolicyName() {
        return this.policyName != null;
    }

    public String getPolicyNamespace() {
        return this.policyNamespace;
    }

    public A withPolicyNamespace(String policyNamespace) {
        this.policyNamespace = policyNamespace;
        return (A)((Object)this);
    }

    public boolean hasPolicyNamespace() {
        return this.policyNamespace != null;
    }

    public A addToPolicySets(int index, String item) {
        if (this.policySets == null) {
            this.policySets = new ArrayList<String>();
        }
        this.policySets.add(index, item);
        return (A)((Object)this);
    }

    public A setToPolicySets(int index, String item) {
        if (this.policySets == null) {
            this.policySets = new ArrayList<String>();
        }
        this.policySets.set(index, item);
        return (A)((Object)this);
    }

    public A addToPolicySets(String ... items) {
        if (this.policySets == null) {
            this.policySets = new ArrayList<String>();
        }
        for (String item : items) {
            this.policySets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicySets(Collection<String> items) {
        if (this.policySets == null) {
            this.policySets = new ArrayList<String>();
        }
        for (String item : items) {
            this.policySets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicySets(String ... items) {
        if (this.policySets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.policySets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicySets(Collection<String> items) {
        if (this.policySets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.policySets.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPolicySets() {
        return this.policySets;
    }

    public String getPolicySet(int index) {
        return this.policySets.get(index);
    }

    public String getFirstPolicySet() {
        return this.policySets.get(0);
    }

    public String getLastPolicySet() {
        return this.policySets.get(this.policySets.size() - 1);
    }

    public String getMatchingPolicySet(Predicate<String> predicate) {
        for (String item : this.policySets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPolicySet(Predicate<String> predicate) {
        for (String item : this.policySets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicySets(List<String> policySets) {
        if (policySets != null) {
            this.policySets = new ArrayList<String>();
            for (String item : policySets) {
                this.addToPolicySets(item);
            }
        } else {
            this.policySets = null;
        }
        return (A)((Object)this);
    }

    public A withPolicySets(String ... policySets) {
        if (this.policySets != null) {
            this.policySets.clear();
            this._visitables.remove((Object)"policySets");
        }
        if (policySets != null) {
            for (String item : policySets) {
                this.addToPolicySets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPolicySets() {
        return this.policySets != null && !this.policySets.isEmpty();
    }

    public A addToPolicyViolations(String key, ReplicatedPolicyStatus value) {
        if (this.policyViolations == null && key != null && value != null) {
            this.policyViolations = new LinkedHashMap<String, ReplicatedPolicyStatus>();
        }
        if (key != null && value != null) {
            this.policyViolations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPolicyViolations(Map<String, ReplicatedPolicyStatus> map) {
        if (this.policyViolations == null && map != null) {
            this.policyViolations = new LinkedHashMap<String, ReplicatedPolicyStatus>();
        }
        if (map != null) {
            this.policyViolations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicyViolations(String key) {
        if (this.policyViolations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.policyViolations != null) {
            this.policyViolations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicyViolations(Map<String, ReplicatedPolicyStatus> map) {
        if (this.policyViolations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.policyViolations == null) continue;
                this.policyViolations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, ReplicatedPolicyStatus> getPolicyViolations() {
        return this.policyViolations;
    }

    public <K, V> A withPolicyViolations(Map<String, ReplicatedPolicyStatus> policyViolations) {
        this.policyViolations = policyViolations == null ? null : new LinkedHashMap<String, ReplicatedPolicyStatus>(policyViolations);
        return (A)((Object)this);
    }

    public boolean hasPolicyViolations() {
        return this.policyViolations != null;
    }

    public A addToTargetClusters(int index, String item) {
        if (this.targetClusters == null) {
            this.targetClusters = new ArrayList<String>();
        }
        this.targetClusters.add(index, item);
        return (A)((Object)this);
    }

    public A setToTargetClusters(int index, String item) {
        if (this.targetClusters == null) {
            this.targetClusters = new ArrayList<String>();
        }
        this.targetClusters.set(index, item);
        return (A)((Object)this);
    }

    public A addToTargetClusters(String ... items) {
        if (this.targetClusters == null) {
            this.targetClusters = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetClusters.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetClusters(Collection<String> items) {
        if (this.targetClusters == null) {
            this.targetClusters = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetClusters.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetClusters(String ... items) {
        if (this.targetClusters == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetClusters.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetClusters(Collection<String> items) {
        if (this.targetClusters == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetClusters.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTargetClusters() {
        return this.targetClusters;
    }

    public String getTargetCluster(int index) {
        return this.targetClusters.get(index);
    }

    public String getFirstTargetCluster() {
        return this.targetClusters.get(0);
    }

    public String getLastTargetCluster() {
        return this.targetClusters.get(this.targetClusters.size() - 1);
    }

    public String getMatchingTargetCluster(Predicate<String> predicate) {
        for (String item : this.targetClusters) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTargetCluster(Predicate<String> predicate) {
        for (String item : this.targetClusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetClusters(List<String> targetClusters) {
        if (targetClusters != null) {
            this.targetClusters = new ArrayList<String>();
            for (String item : targetClusters) {
                this.addToTargetClusters(item);
            }
        } else {
            this.targetClusters = null;
        }
        return (A)((Object)this);
    }

    public A withTargetClusters(String ... targetClusters) {
        if (this.targetClusters != null) {
            this.targetClusters.clear();
            this._visitables.remove((Object)"targetClusters");
        }
        if (targetClusters != null) {
            for (String item : targetClusters) {
                this.addToTargetClusters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetClusters() {
        return this.targetClusters != null && !this.targetClusters.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ViolationContextFluent that = (ViolationContextFluent)((Object)o);
        if (!Objects.equals(this.hubCluster, that.hubCluster)) {
            return false;
        }
        if (!Objects.equals(this.policyName, that.policyName)) {
            return false;
        }
        if (!Objects.equals(this.policyNamespace, that.policyNamespace)) {
            return false;
        }
        if (!Objects.equals(this.policySets, that.policySets)) {
            return false;
        }
        if (!Objects.equals(this.policyViolations, that.policyViolations)) {
            return false;
        }
        if (!Objects.equals(this.targetClusters, that.targetClusters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hubCluster, this.policyName, this.policyNamespace, this.policySets, this.policyViolations, this.targetClusters, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hubCluster != null) {
            sb.append("hubCluster:");
            sb.append(this.hubCluster + ",");
        }
        if (this.policyName != null) {
            sb.append("policyName:");
            sb.append(this.policyName + ",");
        }
        if (this.policyNamespace != null) {
            sb.append("policyNamespace:");
            sb.append(this.policyNamespace + ",");
        }
        if (this.policySets != null && !this.policySets.isEmpty()) {
            sb.append("policySets:");
            sb.append(this.policySets + ",");
        }
        if (this.policyViolations != null && !this.policyViolations.isEmpty()) {
            sb.append("policyViolations:");
            sb.append(this.policyViolations + ",");
        }
        if (this.targetClusters != null && !this.targetClusters.isEmpty()) {
            sb.append("targetClusters:");
            sb.append(this.targetClusters + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

