/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.search.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.SearchDeployments;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.SearchDeploymentsBuilder;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.SearchDeploymentsFluent;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.SearchSpec;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.StorageSpec;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.StorageSpecBuilder;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.StorageSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SearchSpecFluent<A extends SearchSpecFluent<A>>
extends BaseFluent<A> {
    private String availabilityConfig;
    private String dbConfig;
    private StorageSpecBuilder dbStorage;
    private SearchDeploymentsBuilder deployments;
    private String externalDBInstance;
    private String imagePullPolicy;
    private String imagePullSecret;
    private Map<String, String> nodeSelector;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public SearchSpecFluent() {
    }

    public SearchSpecFluent(SearchSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SearchSpec instance) {
        SearchSpec searchSpec = instance = instance != null ? instance : new SearchSpec();
        if (instance != null) {
            this.withAvailabilityConfig(instance.getAvailabilityConfig());
            this.withDbConfig(instance.getDbConfig());
            this.withDbStorage(instance.getDbStorage());
            this.withDeployments(instance.getDeployments());
            this.withExternalDBInstance(instance.getExternalDBInstance());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecret(instance.getImagePullSecret());
            this.withNodeSelector(instance.getNodeSelector());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAvailabilityConfig() {
        return this.availabilityConfig;
    }

    public A withAvailabilityConfig(String availabilityConfig) {
        this.availabilityConfig = availabilityConfig;
        return (A)((Object)this);
    }

    public boolean hasAvailabilityConfig() {
        return this.availabilityConfig != null;
    }

    public String getDbConfig() {
        return this.dbConfig;
    }

    public A withDbConfig(String dbConfig) {
        this.dbConfig = dbConfig;
        return (A)((Object)this);
    }

    public boolean hasDbConfig() {
        return this.dbConfig != null;
    }

    public StorageSpec buildDbStorage() {
        return this.dbStorage != null ? this.dbStorage.build() : null;
    }

    public A withDbStorage(StorageSpec dbStorage) {
        this._visitables.remove((Object)"dbStorage");
        if (dbStorage != null) {
            this.dbStorage = new StorageSpecBuilder(dbStorage);
            this._visitables.get((Object)"dbStorage").add(this.dbStorage);
        } else {
            this.dbStorage = null;
            this._visitables.get((Object)"dbStorage").remove((Object)this.dbStorage);
        }
        return (A)((Object)this);
    }

    public boolean hasDbStorage() {
        return this.dbStorage != null;
    }

    public DbStorageNested<A> withNewDbStorage() {
        return new DbStorageNested(null);
    }

    public DbStorageNested<A> withNewDbStorageLike(StorageSpec item) {
        return new DbStorageNested(item);
    }

    public DbStorageNested<A> editDbStorage() {
        return this.withNewDbStorageLike(Optional.ofNullable(this.buildDbStorage()).orElse(null));
    }

    public DbStorageNested<A> editOrNewDbStorage() {
        return this.withNewDbStorageLike(Optional.ofNullable(this.buildDbStorage()).orElse(new StorageSpecBuilder().build()));
    }

    public DbStorageNested<A> editOrNewDbStorageLike(StorageSpec item) {
        return this.withNewDbStorageLike(Optional.ofNullable(this.buildDbStorage()).orElse(item));
    }

    public SearchDeployments buildDeployments() {
        return this.deployments != null ? this.deployments.build() : null;
    }

    public A withDeployments(SearchDeployments deployments) {
        this._visitables.remove((Object)"deployments");
        if (deployments != null) {
            this.deployments = new SearchDeploymentsBuilder(deployments);
            this._visitables.get((Object)"deployments").add(this.deployments);
        } else {
            this.deployments = null;
            this._visitables.get((Object)"deployments").remove((Object)this.deployments);
        }
        return (A)((Object)this);
    }

    public boolean hasDeployments() {
        return this.deployments != null;
    }

    public DeploymentsNested<A> withNewDeployments() {
        return new DeploymentsNested(null);
    }

    public DeploymentsNested<A> withNewDeploymentsLike(SearchDeployments item) {
        return new DeploymentsNested(item);
    }

    public DeploymentsNested<A> editDeployments() {
        return this.withNewDeploymentsLike(Optional.ofNullable(this.buildDeployments()).orElse(null));
    }

    public DeploymentsNested<A> editOrNewDeployments() {
        return this.withNewDeploymentsLike(Optional.ofNullable(this.buildDeployments()).orElse(new SearchDeploymentsBuilder().build()));
    }

    public DeploymentsNested<A> editOrNewDeploymentsLike(SearchDeployments item) {
        return this.withNewDeploymentsLike(Optional.ofNullable(this.buildDeployments()).orElse(item));
    }

    public String getExternalDBInstance() {
        return this.externalDBInstance;
    }

    public A withExternalDBInstance(String externalDBInstance) {
        this.externalDBInstance = externalDBInstance;
        return (A)((Object)this);
    }

    public boolean hasExternalDBInstance() {
        return this.externalDBInstance != null;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public A withImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
        return (A)((Object)this);
    }

    public boolean hasImagePullSecret() {
        return this.imagePullSecret != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchSpecFluent that = (SearchSpecFluent)((Object)o);
        if (!Objects.equals(this.availabilityConfig, that.availabilityConfig)) {
            return false;
        }
        if (!Objects.equals(this.dbConfig, that.dbConfig)) {
            return false;
        }
        if (!Objects.equals((Object)this.dbStorage, (Object)that.dbStorage)) {
            return false;
        }
        if (!Objects.equals((Object)this.deployments, (Object)that.deployments)) {
            return false;
        }
        if (!Objects.equals(this.externalDBInstance, that.externalDBInstance)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecret, that.imagePullSecret)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.availabilityConfig, this.dbConfig, this.dbStorage, this.deployments, this.externalDBInstance, this.imagePullPolicy, this.imagePullSecret, this.nodeSelector, this.tolerations, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityConfig != null) {
            sb.append("availabilityConfig:");
            sb.append(this.availabilityConfig + ",");
        }
        if (this.dbConfig != null) {
            sb.append("dbConfig:");
            sb.append(this.dbConfig + ",");
        }
        if (this.dbStorage != null) {
            sb.append("dbStorage:");
            sb.append(this.dbStorage + ",");
        }
        if (this.deployments != null) {
            sb.append("deployments:");
            sb.append(this.deployments + ",");
        }
        if (this.externalDBInstance != null) {
            sb.append("externalDBInstance:");
            sb.append(this.externalDBInstance + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.imagePullSecret != null) {
            sb.append("imagePullSecret:");
            sb.append(this.imagePullSecret + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeploymentsNested<N>
    extends SearchDeploymentsFluent<DeploymentsNested<N>>
    implements Nested<N> {
        SearchDeploymentsBuilder builder;

        DeploymentsNested(SearchDeployments item) {
            this.builder = new SearchDeploymentsBuilder(this, item);
        }

        public N and() {
            return (N)SearchSpecFluent.this.withDeployments(this.builder.build());
        }

        public N endDeployments() {
            return this.and();
        }
    }

    public class DbStorageNested<N>
    extends StorageSpecFluent<DbStorageNested<N>>
    implements Nested<N> {
        StorageSpecBuilder builder;

        DbStorageNested(StorageSpec item) {
            this.builder = new StorageSpecBuilder(this, item);
        }

        public N and() {
            return (N)SearchSpecFluent.this.withDbStorage(this.builder.build());
        }

        public N endDbStorage() {
            return this.and();
        }
    }
}

