/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.agent.v1.GlobalValues;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class GlobalValuesFluent<A extends GlobalValuesFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> imageOverrides;
    private String imagePullPolicy;
    private String imagePullSecret;
    private Map<String, String> nodeSelector;
    private Map<String, String> proxyConfig;
    private Map<String, Object> additionalProperties;

    public GlobalValuesFluent() {
    }

    public GlobalValuesFluent(GlobalValues instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GlobalValues instance) {
        GlobalValues globalValues = instance = instance != null ? instance : new GlobalValues();
        if (instance != null) {
            this.withImageOverrides(instance.getImageOverrides());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecret(instance.getImagePullSecret());
            this.withNodeSelector(instance.getNodeSelector());
            this.withProxyConfig(instance.getProxyConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToImageOverrides(String key, String value) {
        if (this.imageOverrides == null && key != null && value != null) {
            this.imageOverrides = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.imageOverrides.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToImageOverrides(Map<String, String> map) {
        if (this.imageOverrides == null && map != null) {
            this.imageOverrides = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.imageOverrides.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromImageOverrides(String key) {
        if (this.imageOverrides == null) {
            return (A)((Object)this);
        }
        if (key != null && this.imageOverrides != null) {
            this.imageOverrides.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromImageOverrides(Map<String, String> map) {
        if (this.imageOverrides == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.imageOverrides == null) continue;
                this.imageOverrides.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getImageOverrides() {
        return this.imageOverrides;
    }

    public <K, V> A withImageOverrides(Map<String, String> imageOverrides) {
        this.imageOverrides = imageOverrides == null ? null : new LinkedHashMap<String, String>(imageOverrides);
        return (A)((Object)this);
    }

    public boolean hasImageOverrides() {
        return this.imageOverrides != null;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public A withImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
        return (A)((Object)this);
    }

    public boolean hasImagePullSecret() {
        return this.imagePullSecret != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToProxyConfig(String key, String value) {
        if (this.proxyConfig == null && key != null && value != null) {
            this.proxyConfig = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.proxyConfig.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProxyConfig(Map<String, String> map) {
        if (this.proxyConfig == null && map != null) {
            this.proxyConfig = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.proxyConfig.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConfig(String key) {
        if (this.proxyConfig == null) {
            return (A)((Object)this);
        }
        if (key != null && this.proxyConfig != null) {
            this.proxyConfig.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConfig(Map<String, String> map) {
        if (this.proxyConfig == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConfig == null) continue;
                this.proxyConfig.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getProxyConfig() {
        return this.proxyConfig;
    }

    public <K, V> A withProxyConfig(Map<String, String> proxyConfig) {
        this.proxyConfig = proxyConfig == null ? null : new LinkedHashMap<String, String>(proxyConfig);
        return (A)((Object)this);
    }

    public boolean hasProxyConfig() {
        return this.proxyConfig != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GlobalValuesFluent that = (GlobalValuesFluent)((Object)o);
        if (!Objects.equals(this.imageOverrides, that.imageOverrides)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecret, that.imagePullSecret)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.proxyConfig, that.proxyConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.imageOverrides, this.imagePullPolicy, this.imagePullSecret, this.nodeSelector, this.proxyConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageOverrides != null && !this.imageOverrides.isEmpty()) {
            sb.append("imageOverrides:");
            sb.append(String.valueOf(this.imageOverrides) + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.imagePullSecret != null) {
            sb.append("imagePullSecret:");
            sb.append(this.imagePullSecret + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(String.valueOf(this.nodeSelector) + ",");
        }
        if (this.proxyConfig != null && !this.proxyConfig.isEmpty()) {
            sb.append("proxyConfig:");
            sb.append(String.valueOf(this.proxyConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

