/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.apps.v1.AllowDenyItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AllowDenyItemFluent<A extends AllowDenyItemFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> kinds = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public AllowDenyItemFluent() {
    }

    public AllowDenyItemFluent(AllowDenyItem instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AllowDenyItem instance) {
        AllowDenyItem allowDenyItem = instance = instance != null ? instance : new AllowDenyItem();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKinds(instance.getKinds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToKinds(int index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.add(index, item);
        return (A)((Object)this);
    }

    public A setToKinds(int index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.set(index, item);
        return (A)((Object)this);
    }

    public A addToKinds(String ... items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToKinds(Collection<String> items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromKinds(String ... items) {
        if (this.kinds == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kinds.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKinds(Collection<String> items) {
        if (this.kinds == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kinds.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getKinds() {
        return this.kinds;
    }

    public String getKind(int index) {
        return this.kinds.get(index);
    }

    public String getFirstKind() {
        return this.kinds.get(0);
    }

    public String getLastKind() {
        return this.kinds.get(this.kinds.size() - 1);
    }

    public String getMatchingKind(Predicate<String> predicate) {
        for (String item : this.kinds) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingKind(Predicate<String> predicate) {
        for (String item : this.kinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKinds(List<String> kinds) {
        if (kinds != null) {
            this.kinds = new ArrayList<String>();
            for (String item : kinds) {
                this.addToKinds(item);
            }
        } else {
            this.kinds = null;
        }
        return (A)((Object)this);
    }

    public A withKinds(String ... kinds) {
        if (this.kinds != null) {
            this.kinds.clear();
            this._visitables.remove((Object)"kinds");
        }
        if (kinds != null) {
            for (String item : kinds) {
                this.addToKinds(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasKinds() {
        return this.kinds != null && !this.kinds.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllowDenyItemFluent that = (AllowDenyItemFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kinds, that.kinds)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kinds, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kinds != null && !this.kinds.isEmpty()) {
            sb.append("kinds:");
            sb.append(String.valueOf(this.kinds) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

