/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.apps.v1.ClusterOverride;
import io.fabric8.openclustermanagement.api.model.apps.v1.ClusterOverrideBuilder;
import io.fabric8.openclustermanagement.api.model.apps.v1.ClusterOverrideFluent;
import io.fabric8.openclustermanagement.api.model.apps.v1.ClusterOverrides;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterOverridesFluent<A extends ClusterOverridesFluent<A>>
extends BaseFluent<A> {
    private String clusterName;
    private ArrayList<ClusterOverrideBuilder> clusterOverrides = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ClusterOverridesFluent() {
    }

    public ClusterOverridesFluent(ClusterOverrides instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterOverrides instance) {
        ClusterOverrides clusterOverrides = instance = instance != null ? instance : new ClusterOverrides();
        if (instance != null) {
            this.withClusterName(instance.getClusterName());
            this.withClusterOverrides(instance.getClusterOverrides());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)((Object)this);
    }

    public boolean hasClusterName() {
        return this.clusterName != null;
    }

    public A addToClusterOverrides(int index, ClusterOverride item) {
        if (this.clusterOverrides == null) {
            this.clusterOverrides = new ArrayList();
        }
        ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
        if (index < 0 || index >= this.clusterOverrides.size()) {
            this._visitables.get((Object)"clusterOverrides").add(builder);
            this.clusterOverrides.add(builder);
        } else {
            this._visitables.get((Object)"clusterOverrides").add(builder);
            this.clusterOverrides.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusterOverrides(int index, ClusterOverride item) {
        if (this.clusterOverrides == null) {
            this.clusterOverrides = new ArrayList();
        }
        ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
        if (index < 0 || index >= this.clusterOverrides.size()) {
            this._visitables.get((Object)"clusterOverrides").add(builder);
            this.clusterOverrides.add(builder);
        } else {
            this._visitables.get((Object)"clusterOverrides").add(builder);
            this.clusterOverrides.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusterOverrides(ClusterOverride ... items) {
        if (this.clusterOverrides == null) {
            this.clusterOverrides = new ArrayList();
        }
        for (ClusterOverride item : items) {
            ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
            this._visitables.get((Object)"clusterOverrides").add(builder);
            this.clusterOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterOverrides(Collection<ClusterOverride> items) {
        if (this.clusterOverrides == null) {
            this.clusterOverrides = new ArrayList();
        }
        for (ClusterOverride item : items) {
            ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
            this._visitables.get((Object)"clusterOverrides").add(builder);
            this.clusterOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterOverrides(ClusterOverride ... items) {
        if (this.clusterOverrides == null) {
            return (A)((Object)this);
        }
        for (ClusterOverride item : items) {
            ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
            this._visitables.get((Object)"clusterOverrides").remove((Object)builder);
            this.clusterOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterOverrides(Collection<ClusterOverride> items) {
        if (this.clusterOverrides == null) {
            return (A)((Object)this);
        }
        for (ClusterOverride item : items) {
            ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
            this._visitables.get((Object)"clusterOverrides").remove((Object)builder);
            this.clusterOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusterOverrides(Predicate<ClusterOverrideBuilder> predicate) {
        if (this.clusterOverrides == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterOverrideBuilder> each = this.clusterOverrides.iterator();
        List visitables = this._visitables.get((Object)"clusterOverrides");
        while (each.hasNext()) {
            ClusterOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterOverride> buildClusterOverrides() {
        return this.clusterOverrides != null ? ClusterOverridesFluent.build(this.clusterOverrides) : null;
    }

    public ClusterOverride buildClusterOverride(int index) {
        return this.clusterOverrides.get(index).build();
    }

    public ClusterOverride buildFirstClusterOverride() {
        return this.clusterOverrides.get(0).build();
    }

    public ClusterOverride buildLastClusterOverride() {
        return this.clusterOverrides.get(this.clusterOverrides.size() - 1).build();
    }

    public ClusterOverride buildMatchingClusterOverride(Predicate<ClusterOverrideBuilder> predicate) {
        for (ClusterOverrideBuilder item : this.clusterOverrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterOverride(Predicate<ClusterOverrideBuilder> predicate) {
        for (ClusterOverrideBuilder item : this.clusterOverrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterOverrides(List<ClusterOverride> clusterOverrides) {
        if (this.clusterOverrides != null) {
            this._visitables.get((Object)"clusterOverrides").clear();
        }
        if (clusterOverrides != null) {
            this.clusterOverrides = new ArrayList();
            for (ClusterOverride item : clusterOverrides) {
                this.addToClusterOverrides(item);
            }
        } else {
            this.clusterOverrides = null;
        }
        return (A)((Object)this);
    }

    public A withClusterOverrides(ClusterOverride ... clusterOverrides) {
        if (this.clusterOverrides != null) {
            this.clusterOverrides.clear();
            this._visitables.remove((Object)"clusterOverrides");
        }
        if (clusterOverrides != null) {
            for (ClusterOverride item : clusterOverrides) {
                this.addToClusterOverrides(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterOverrides() {
        return this.clusterOverrides != null && !this.clusterOverrides.isEmpty();
    }

    public ClusterOverridesNested<A> addNewClusterOverride() {
        return new ClusterOverridesNested(-1, null);
    }

    public ClusterOverridesNested<A> addNewClusterOverrideLike(ClusterOverride item) {
        return new ClusterOverridesNested(-1, item);
    }

    public ClusterOverridesNested<A> setNewClusterOverrideLike(int index, ClusterOverride item) {
        return new ClusterOverridesNested(index, item);
    }

    public ClusterOverridesNested<A> editClusterOverride(int index) {
        if (this.clusterOverrides.size() <= index) {
            throw new RuntimeException("Can't edit clusterOverrides. Index exceeds size.");
        }
        return this.setNewClusterOverrideLike(index, this.buildClusterOverride(index));
    }

    public ClusterOverridesNested<A> editFirstClusterOverride() {
        if (this.clusterOverrides.size() == 0) {
            throw new RuntimeException("Can't edit first clusterOverrides. The list is empty.");
        }
        return this.setNewClusterOverrideLike(0, this.buildClusterOverride(0));
    }

    public ClusterOverridesNested<A> editLastClusterOverride() {
        int index = this.clusterOverrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterOverrides. The list is empty.");
        }
        return this.setNewClusterOverrideLike(index, this.buildClusterOverride(index));
    }

    public ClusterOverridesNested<A> editMatchingClusterOverride(Predicate<ClusterOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterOverrides.size(); ++i) {
            if (!predicate.test(this.clusterOverrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterOverrides. No match found.");
        }
        return this.setNewClusterOverrideLike(index, this.buildClusterOverride(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterOverridesFluent that = (ClusterOverridesFluent)((Object)o);
        if (!Objects.equals(this.clusterName, that.clusterName)) {
            return false;
        }
        if (!Objects.equals(this.clusterOverrides, that.clusterOverrides)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.clusterOverrides, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName + ",");
        }
        if (this.clusterOverrides != null && !this.clusterOverrides.isEmpty()) {
            sb.append("clusterOverrides:");
            sb.append(String.valueOf(this.clusterOverrides) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterOverridesNested<N>
    extends ClusterOverrideFluent<ClusterOverridesNested<N>>
    implements Nested<N> {
        ClusterOverrideBuilder builder;
        int index;

        ClusterOverridesNested(int index, ClusterOverride item) {
            this.index = index;
            this.builder = new ClusterOverrideBuilder(this, item);
        }

        public N and() {
            return (N)ClusterOverridesFluent.this.setToClusterOverrides(this.index, this.builder.build());
        }

        public N endClusterOverride() {
            return this.and();
        }
    }
}

