/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openclustermanagement.api.model.apps.v1.GenericClusterReference;
import io.fabric8.openclustermanagement.api.model.apps.v1.GenericClusterReferenceBuilder;
import io.fabric8.openclustermanagement.api.model.apps.v1.GenericClusterReferenceFluent;
import io.fabric8.openclustermanagement.api.model.apps.v1.GenericPlacementFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GenericPlacementFieldsFluent<A extends GenericPlacementFieldsFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder clusterSelector;
    private ArrayList<GenericClusterReferenceBuilder> clusters = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GenericPlacementFieldsFluent() {
    }

    public GenericPlacementFieldsFluent(GenericPlacementFields instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GenericPlacementFields instance) {
        GenericPlacementFields genericPlacementFields = instance = instance != null ? instance : new GenericPlacementFields();
        if (instance != null) {
            this.withClusterSelector(instance.getClusterSelector());
            this.withClusters(instance.getClusters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LabelSelector buildClusterSelector() {
        return this.clusterSelector != null ? this.clusterSelector.build() : null;
    }

    public A withClusterSelector(LabelSelector clusterSelector) {
        this._visitables.remove((Object)"clusterSelector");
        if (clusterSelector != null) {
            this.clusterSelector = new LabelSelectorBuilder(clusterSelector);
            this._visitables.get((Object)"clusterSelector").add(this.clusterSelector);
        } else {
            this.clusterSelector = null;
            this._visitables.get((Object)"clusterSelector").remove(this.clusterSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterSelector() {
        return this.clusterSelector != null;
    }

    public ClusterSelectorNested<A> withNewClusterSelector() {
        return new ClusterSelectorNested(null);
    }

    public ClusterSelectorNested<A> withNewClusterSelectorLike(LabelSelector item) {
        return new ClusterSelectorNested(item);
    }

    public ClusterSelectorNested<A> editClusterSelector() {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(null));
    }

    public ClusterSelectorNested<A> editOrNewClusterSelector() {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public ClusterSelectorNested<A> editOrNewClusterSelectorLike(LabelSelector item) {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(item));
    }

    public A addToClusters(int index, GenericClusterReference item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusters(int index, GenericClusterReference item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusters(GenericClusterReference ... items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusters(Collection<GenericClusterReference> items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusters(GenericClusterReference ... items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusters(Collection<GenericClusterReference> items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusters(Predicate<GenericClusterReferenceBuilder> predicate) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        Iterator<GenericClusterReferenceBuilder> each = this.clusters.iterator();
        List visitables = this._visitables.get((Object)"clusters");
        while (each.hasNext()) {
            GenericClusterReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GenericClusterReference> buildClusters() {
        return this.clusters != null ? GenericPlacementFieldsFluent.build(this.clusters) : null;
    }

    public GenericClusterReference buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    public GenericClusterReference buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    public GenericClusterReference buildLastCluster() {
        return this.clusters.get(this.clusters.size() - 1).build();
    }

    public GenericClusterReference buildMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        for (GenericClusterReferenceBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        for (GenericClusterReferenceBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusters(List<GenericClusterReference> clusters) {
        if (this.clusters != null) {
            this._visitables.get((Object)"clusters").clear();
        }
        if (clusters != null) {
            this.clusters = new ArrayList();
            for (GenericClusterReference item : clusters) {
                this.addToClusters(item);
            }
        } else {
            this.clusters = null;
        }
        return (A)((Object)this);
    }

    public A withClusters(GenericClusterReference ... clusters) {
        if (this.clusters != null) {
            this.clusters.clear();
            this._visitables.remove((Object)"clusters");
        }
        if (clusters != null) {
            for (GenericClusterReference item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusters() {
        return this.clusters != null && !this.clusters.isEmpty();
    }

    public A addNewCluster(String name) {
        return this.addToClusters(new GenericClusterReference(name));
    }

    public ClustersNested<A> addNewCluster() {
        return new ClustersNested(-1, null);
    }

    public ClustersNested<A> addNewClusterLike(GenericClusterReference item) {
        return new ClustersNested(-1, item);
    }

    public ClustersNested<A> setNewClusterLike(int index, GenericClusterReference item) {
        return new ClustersNested(index, item);
    }

    public ClustersNested<A> editCluster(int index) {
        if (this.clusters.size() <= index) {
            throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editFirstCluster() {
        if (this.clusters.size() == 0) {
            throw new RuntimeException("Can't edit first clusters. The list is empty.");
        }
        return this.setNewClusterLike(0, this.buildCluster(0));
    }

    public ClustersNested<A> editLastCluster() {
        int index = this.clusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusters. The list is empty.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!predicate.test(this.clusters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusters. No match found.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericPlacementFieldsFluent that = (GenericPlacementFieldsFluent)((Object)o);
        if (!Objects.equals(this.clusterSelector, that.clusterSelector)) {
            return false;
        }
        if (!Objects.equals(this.clusters, that.clusters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clusterSelector, this.clusters, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSelector != null) {
            sb.append("clusterSelector:");
            sb.append(String.valueOf(this.clusterSelector) + ",");
        }
        if (this.clusters != null && !this.clusters.isEmpty()) {
            sb.append("clusters:");
            sb.append(String.valueOf(this.clusters) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClustersNested<N>
    extends GenericClusterReferenceFluent<ClustersNested<N>>
    implements Nested<N> {
        GenericClusterReferenceBuilder builder;
        int index;

        ClustersNested(int index, GenericClusterReference item) {
            this.index = index;
            this.builder = new GenericClusterReferenceBuilder(this, item);
        }

        public N and() {
            return (N)GenericPlacementFieldsFluent.this.setToClusters(this.index, this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }

    public class ClusterSelectorNested<N>
    extends LabelSelectorFluent<ClusterSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        ClusterSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)GenericPlacementFieldsFluent.this.withClusterSelector(this.builder.build());
        }

        public N endClusterSelector() {
            return this.and();
        }
    }
}

