/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfig;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfigBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfigFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec;
import io.fabric8.openclustermanagement.api.model.cluster.v1.Taint;
import io.fabric8.openclustermanagement.api.model.cluster.v1.TaintBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.TaintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ManagedClusterSpecFluent<A extends ManagedClusterSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean hubAcceptsClient;
    private Integer leaseDurationSeconds;
    private ArrayList<ClientConfigBuilder> managedClusterClientConfigs = new ArrayList();
    private ArrayList<TaintBuilder> taints = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ManagedClusterSpecFluent() {
    }

    public ManagedClusterSpecFluent(ManagedClusterSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ManagedClusterSpec instance) {
        ManagedClusterSpec managedClusterSpec = instance = instance != null ? instance : new ManagedClusterSpec();
        if (instance != null) {
            this.withHubAcceptsClient(instance.getHubAcceptsClient());
            this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
            this.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
            this.withTaints(instance.getTaints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getHubAcceptsClient() {
        return this.hubAcceptsClient;
    }

    public A withHubAcceptsClient(Boolean hubAcceptsClient) {
        this.hubAcceptsClient = hubAcceptsClient;
        return (A)((Object)this);
    }

    public boolean hasHubAcceptsClient() {
        return this.hubAcceptsClient != null;
    }

    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
        return (A)((Object)this);
    }

    public boolean hasLeaseDurationSeconds() {
        return this.leaseDurationSeconds != null;
    }

    public A addToManagedClusterClientConfigs(int index, ClientConfig item) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList();
        }
        ClientConfigBuilder builder = new ClientConfigBuilder(item);
        if (index < 0 || index >= this.managedClusterClientConfigs.size()) {
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.add(builder);
        } else {
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToManagedClusterClientConfigs(int index, ClientConfig item) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList();
        }
        ClientConfigBuilder builder = new ClientConfigBuilder(item);
        if (index < 0 || index >= this.managedClusterClientConfigs.size()) {
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.add(builder);
        } else {
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToManagedClusterClientConfigs(ClientConfig ... items) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList();
        }
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToManagedClusterClientConfigs(Collection<ClientConfig> items) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList();
        }
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromManagedClusterClientConfigs(ClientConfig ... items) {
        if (this.managedClusterClientConfigs == null) {
            return (A)((Object)this);
        }
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").remove((Object)builder);
            this.managedClusterClientConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromManagedClusterClientConfigs(Collection<ClientConfig> items) {
        if (this.managedClusterClientConfigs == null) {
            return (A)((Object)this);
        }
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").remove((Object)builder);
            this.managedClusterClientConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromManagedClusterClientConfigs(Predicate<ClientConfigBuilder> predicate) {
        if (this.managedClusterClientConfigs == null) {
            return (A)((Object)this);
        }
        Iterator<ClientConfigBuilder> each = this.managedClusterClientConfigs.iterator();
        List visitables = this._visitables.get((Object)"managedClusterClientConfigs");
        while (each.hasNext()) {
            ClientConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClientConfig> buildManagedClusterClientConfigs() {
        return this.managedClusterClientConfigs != null ? ManagedClusterSpecFluent.build(this.managedClusterClientConfigs) : null;
    }

    public ClientConfig buildManagedClusterClientConfig(int index) {
        return this.managedClusterClientConfigs.get(index).build();
    }

    public ClientConfig buildFirstManagedClusterClientConfig() {
        return this.managedClusterClientConfigs.get(0).build();
    }

    public ClientConfig buildLastManagedClusterClientConfig() {
        return this.managedClusterClientConfigs.get(this.managedClusterClientConfigs.size() - 1).build();
    }

    public ClientConfig buildMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
        for (ClientConfigBuilder item : this.managedClusterClientConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
        for (ClientConfigBuilder item : this.managedClusterClientConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withManagedClusterClientConfigs(List<ClientConfig> managedClusterClientConfigs) {
        if (this.managedClusterClientConfigs != null) {
            this._visitables.get((Object)"managedClusterClientConfigs").clear();
        }
        if (managedClusterClientConfigs != null) {
            this.managedClusterClientConfigs = new ArrayList();
            for (ClientConfig item : managedClusterClientConfigs) {
                this.addToManagedClusterClientConfigs(item);
            }
        } else {
            this.managedClusterClientConfigs = null;
        }
        return (A)((Object)this);
    }

    public A withManagedClusterClientConfigs(ClientConfig ... managedClusterClientConfigs) {
        if (this.managedClusterClientConfigs != null) {
            this.managedClusterClientConfigs.clear();
            this._visitables.remove((Object)"managedClusterClientConfigs");
        }
        if (managedClusterClientConfigs != null) {
            for (ClientConfig item : managedClusterClientConfigs) {
                this.addToManagedClusterClientConfigs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasManagedClusterClientConfigs() {
        return this.managedClusterClientConfigs != null && !this.managedClusterClientConfigs.isEmpty();
    }

    public A addNewManagedClusterClientConfig(String caBundle, String url) {
        return this.addToManagedClusterClientConfigs(new ClientConfig(caBundle, url));
    }

    public ManagedClusterClientConfigsNested<A> addNewManagedClusterClientConfig() {
        return new ManagedClusterClientConfigsNested(-1, null);
    }

    public ManagedClusterClientConfigsNested<A> addNewManagedClusterClientConfigLike(ClientConfig item) {
        return new ManagedClusterClientConfigsNested(-1, item);
    }

    public ManagedClusterClientConfigsNested<A> setNewManagedClusterClientConfigLike(int index, ClientConfig item) {
        return new ManagedClusterClientConfigsNested(index, item);
    }

    public ManagedClusterClientConfigsNested<A> editManagedClusterClientConfig(int index) {
        if (this.managedClusterClientConfigs.size() <= index) {
            throw new RuntimeException("Can't edit managedClusterClientConfigs. Index exceeds size.");
        }
        return this.setNewManagedClusterClientConfigLike(index, this.buildManagedClusterClientConfig(index));
    }

    public ManagedClusterClientConfigsNested<A> editFirstManagedClusterClientConfig() {
        if (this.managedClusterClientConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first managedClusterClientConfigs. The list is empty.");
        }
        return this.setNewManagedClusterClientConfigLike(0, this.buildManagedClusterClientConfig(0));
    }

    public ManagedClusterClientConfigsNested<A> editLastManagedClusterClientConfig() {
        int index = this.managedClusterClientConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last managedClusterClientConfigs. The list is empty.");
        }
        return this.setNewManagedClusterClientConfigLike(index, this.buildManagedClusterClientConfig(index));
    }

    public ManagedClusterClientConfigsNested<A> editMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.managedClusterClientConfigs.size(); ++i) {
            if (!predicate.test(this.managedClusterClientConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching managedClusterClientConfigs. No match found.");
        }
        return this.setNewManagedClusterClientConfigLike(index, this.buildManagedClusterClientConfig(index));
    }

    public A addToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        TaintBuilder builder = new TaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        TaintBuilder builder = new TaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTaints(Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTaints(Collection<Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTaints(Taint ... items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get((Object)"taints").remove((Object)builder);
            this.taints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTaints(Collection<Taint> items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get((Object)"taints").remove((Object)builder);
            this.taints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTaints(Predicate<TaintBuilder> predicate) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        Iterator<TaintBuilder> each = this.taints.iterator();
        List visitables = this._visitables.get((Object)"taints");
        while (each.hasNext()) {
            TaintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Taint> buildTaints() {
        return this.taints != null ? ManagedClusterSpecFluent.build(this.taints) : null;
    }

    public Taint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    public Taint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    public Taint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    public Taint buildMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTaints(List<Taint> taints) {
        if (this.taints != null) {
            this._visitables.get((Object)"taints").clear();
        }
        if (taints != null) {
            this.taints = new ArrayList();
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)((Object)this);
    }

    public A withTaints(Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove((Object)"taints");
        }
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    public TaintsNested<A> addNewTaint() {
        return new TaintsNested(-1, null);
    }

    public TaintsNested<A> addNewTaintLike(Taint item) {
        return new TaintsNested(-1, item);
    }

    public TaintsNested<A> setNewTaintLike(int index, Taint item) {
        return new TaintsNested(index, item);
    }

    public TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    public TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editMatchingTaint(Predicate<TaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.test(this.taints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManagedClusterSpecFluent that = (ManagedClusterSpecFluent)((Object)o);
        if (!Objects.equals(this.hubAcceptsClient, that.hubAcceptsClient)) {
            return false;
        }
        if (!Objects.equals(this.leaseDurationSeconds, that.leaseDurationSeconds)) {
            return false;
        }
        if (!Objects.equals(this.managedClusterClientConfigs, that.managedClusterClientConfigs)) {
            return false;
        }
        if (!Objects.equals(this.taints, that.taints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hubAcceptsClient, this.leaseDurationSeconds, this.managedClusterClientConfigs, this.taints, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hubAcceptsClient != null) {
            sb.append("hubAcceptsClient:");
            sb.append(this.hubAcceptsClient + ",");
        }
        if (this.leaseDurationSeconds != null) {
            sb.append("leaseDurationSeconds:");
            sb.append(this.leaseDurationSeconds + ",");
        }
        if (this.managedClusterClientConfigs != null && !this.managedClusterClientConfigs.isEmpty()) {
            sb.append("managedClusterClientConfigs:");
            sb.append(String.valueOf(this.managedClusterClientConfigs) + ",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(String.valueOf(this.taints) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withHubAcceptsClient() {
        return this.withHubAcceptsClient(true);
    }

    public class TaintsNested<N>
    extends TaintFluent<TaintsNested<N>>
    implements Nested<N> {
        TaintBuilder builder;
        int index;

        TaintsNested(int index, Taint item) {
            this.index = index;
            this.builder = new TaintBuilder(this, item);
        }

        public N and() {
            return (N)ManagedClusterSpecFluent.this.setToTaints(this.index, this.builder.build());
        }

        public N endTaint() {
            return this.and();
        }
    }

    public class ManagedClusterClientConfigsNested<N>
    extends ClientConfigFluent<ManagedClusterClientConfigsNested<N>>
    implements Nested<N> {
        ClientConfigBuilder builder;
        int index;

        ManagedClusterClientConfigsNested(int index, ClientConfig item) {
            this.index = index;
            this.builder = new ClientConfigBuilder(this, item);
        }

        public N and() {
            return (N)ManagedClusterSpecFluent.this.setToManagedClusterClientConfigs(this.index, this.builder.build());
        }

        public N endManagedClusterClientConfig() {
            return this.and();
        }
    }
}

