/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatus;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ManagedClusterStatusFluent<A extends ManagedClusterStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> allocatable;
    private Map<String, Quantity> capacity;
    private ArrayList<ManagedClusterClaimBuilder> clusterClaims = new ArrayList();
    private List<Condition> conditions = new ArrayList<Condition>();
    private ManagedClusterVersionBuilder version;
    private Map<String, Object> additionalProperties;

    public ManagedClusterStatusFluent() {
    }

    public ManagedClusterStatusFluent(ManagedClusterStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ManagedClusterStatus instance) {
        ManagedClusterStatus managedClusterStatus = instance = instance != null ? instance : new ManagedClusterStatus();
        if (instance != null) {
            this.withAllocatable(instance.getAllocatable());
            this.withCapacity(instance.getCapacity());
            this.withClusterClaims(instance.getClusterClaims());
            this.withConditions(instance.getConditions());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllocatable(String key, Quantity value) {
        if (this.allocatable == null && key != null && value != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null && map != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatable(String key) {
        if (this.allocatable == null) {
            return (A)((Object)this);
        }
        if (key != null && this.allocatable != null) {
            this.allocatable.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatable == null) continue;
                this.allocatable.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    public <K, V> A withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable == null ? null : new LinkedHashMap<String, Quantity>(allocatable);
        return (A)((Object)this);
    }

    public boolean hasAllocatable() {
        return this.allocatable != null;
    }

    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)((Object)this);
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public <K, V> A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, Quantity>(capacity);
        return (A)((Object)this);
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public A addToClusterClaims(int index, ManagedClusterClaim item) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList();
        }
        ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
        if (index < 0 || index >= this.clusterClaims.size()) {
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.add(builder);
        } else {
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusterClaims(int index, ManagedClusterClaim item) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList();
        }
        ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
        if (index < 0 || index >= this.clusterClaims.size()) {
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.add(builder);
        } else {
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusterClaims(ManagedClusterClaim ... items) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList();
        }
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterClaims(Collection<ManagedClusterClaim> items) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList();
        }
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterClaims(ManagedClusterClaim ... items) {
        if (this.clusterClaims == null) {
            return (A)((Object)this);
        }
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").remove((Object)builder);
            this.clusterClaims.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterClaims(Collection<ManagedClusterClaim> items) {
        if (this.clusterClaims == null) {
            return (A)((Object)this);
        }
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").remove((Object)builder);
            this.clusterClaims.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusterClaims(Predicate<ManagedClusterClaimBuilder> predicate) {
        if (this.clusterClaims == null) {
            return (A)((Object)this);
        }
        Iterator<ManagedClusterClaimBuilder> each = this.clusterClaims.iterator();
        List visitables = this._visitables.get((Object)"clusterClaims");
        while (each.hasNext()) {
            ManagedClusterClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ManagedClusterClaim> buildClusterClaims() {
        return this.clusterClaims != null ? ManagedClusterStatusFluent.build(this.clusterClaims) : null;
    }

    public ManagedClusterClaim buildClusterClaim(int index) {
        return this.clusterClaims.get(index).build();
    }

    public ManagedClusterClaim buildFirstClusterClaim() {
        return this.clusterClaims.get(0).build();
    }

    public ManagedClusterClaim buildLastClusterClaim() {
        return this.clusterClaims.get(this.clusterClaims.size() - 1).build();
    }

    public ManagedClusterClaim buildMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
        for (ManagedClusterClaimBuilder item : this.clusterClaims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
        for (ManagedClusterClaimBuilder item : this.clusterClaims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterClaims(List<ManagedClusterClaim> clusterClaims) {
        if (this.clusterClaims != null) {
            this._visitables.get((Object)"clusterClaims").clear();
        }
        if (clusterClaims != null) {
            this.clusterClaims = new ArrayList();
            for (ManagedClusterClaim item : clusterClaims) {
                this.addToClusterClaims(item);
            }
        } else {
            this.clusterClaims = null;
        }
        return (A)((Object)this);
    }

    public A withClusterClaims(ManagedClusterClaim ... clusterClaims) {
        if (this.clusterClaims != null) {
            this.clusterClaims.clear();
            this._visitables.remove((Object)"clusterClaims");
        }
        if (clusterClaims != null) {
            for (ManagedClusterClaim item : clusterClaims) {
                this.addToClusterClaims(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterClaims() {
        return this.clusterClaims != null && !this.clusterClaims.isEmpty();
    }

    public A addNewClusterClaim(String name, String value) {
        return this.addToClusterClaims(new ManagedClusterClaim(name, value));
    }

    public ClusterClaimsNested<A> addNewClusterClaim() {
        return new ClusterClaimsNested(-1, null);
    }

    public ClusterClaimsNested<A> addNewClusterClaimLike(ManagedClusterClaim item) {
        return new ClusterClaimsNested(-1, item);
    }

    public ClusterClaimsNested<A> setNewClusterClaimLike(int index, ManagedClusterClaim item) {
        return new ClusterClaimsNested(index, item);
    }

    public ClusterClaimsNested<A> editClusterClaim(int index) {
        if (this.clusterClaims.size() <= index) {
            throw new RuntimeException("Can't edit clusterClaims. Index exceeds size.");
        }
        return this.setNewClusterClaimLike(index, this.buildClusterClaim(index));
    }

    public ClusterClaimsNested<A> editFirstClusterClaim() {
        if (this.clusterClaims.size() == 0) {
            throw new RuntimeException("Can't edit first clusterClaims. The list is empty.");
        }
        return this.setNewClusterClaimLike(0, this.buildClusterClaim(0));
    }

    public ClusterClaimsNested<A> editLastClusterClaim() {
        int index = this.clusterClaims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterClaims. The list is empty.");
        }
        return this.setNewClusterClaimLike(index, this.buildClusterClaim(index));
    }

    public ClusterClaimsNested<A> editMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterClaims.size(); ++i) {
            if (!predicate.test(this.clusterClaims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterClaims. No match found.");
        }
        return this.setNewClusterClaimLike(index, this.buildClusterClaim(index));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ManagedClusterVersion buildVersion() {
        return this.version != null ? this.version.build() : null;
    }

    public A withVersion(ManagedClusterVersion version) {
        this._visitables.remove((Object)"version");
        if (version != null) {
            this.version = new ManagedClusterVersionBuilder(version);
            this._visitables.get((Object)"version").add(this.version);
        } else {
            this.version = null;
            this._visitables.get((Object)"version").remove((Object)this.version);
        }
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String kubernetes) {
        return this.withVersion(new ManagedClusterVersion(kubernetes));
    }

    public VersionNested<A> withNewVersion() {
        return new VersionNested(null);
    }

    public VersionNested<A> withNewVersionLike(ManagedClusterVersion item) {
        return new VersionNested(item);
    }

    public VersionNested<A> editVersion() {
        return this.withNewVersionLike(Optional.ofNullable(this.buildVersion()).orElse(null));
    }

    public VersionNested<A> editOrNewVersion() {
        return this.withNewVersionLike(Optional.ofNullable(this.buildVersion()).orElse(new ManagedClusterVersionBuilder().build()));
    }

    public VersionNested<A> editOrNewVersionLike(ManagedClusterVersion item) {
        return this.withNewVersionLike(Optional.ofNullable(this.buildVersion()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManagedClusterStatusFluent that = (ManagedClusterStatusFluent)((Object)o);
        if (!Objects.equals(this.allocatable, that.allocatable)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.clusterClaims, that.clusterClaims)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.version, (Object)that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allocatable, this.capacity, this.clusterClaims, this.conditions, this.version, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatable != null && !this.allocatable.isEmpty()) {
            sb.append("allocatable:");
            sb.append(String.valueOf(this.allocatable) + ",");
        }
        if (this.capacity != null && !this.capacity.isEmpty()) {
            sb.append("capacity:");
            sb.append(String.valueOf(this.capacity) + ",");
        }
        if (this.clusterClaims != null && !this.clusterClaims.isEmpty()) {
            sb.append("clusterClaims:");
            sb.append(String.valueOf(this.clusterClaims) + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(String.valueOf((Object)this.version) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VersionNested<N>
    extends ManagedClusterVersionFluent<VersionNested<N>>
    implements Nested<N> {
        ManagedClusterVersionBuilder builder;

        VersionNested(ManagedClusterVersion item) {
            this.builder = new ManagedClusterVersionBuilder(this, item);
        }

        public N and() {
            return (N)ManagedClusterStatusFluent.this.withVersion(this.builder.build());
        }

        public N endVersion() {
            return this.and();
        }
    }

    public class ClusterClaimsNested<N>
    extends ManagedClusterClaimFluent<ClusterClaimsNested<N>>
    implements Nested<N> {
        ManagedClusterClaimBuilder builder;
        int index;

        ClusterClaimsNested(int index, ManagedClusterClaim item) {
            this.index = index;
            this.builder = new ManagedClusterClaimBuilder(this, item);
        }

        public N and() {
            return (N)ManagedClusterStatusFluent.this.setToClusterClaims(this.index, this.builder.build());
        }

        public N endClusterClaim() {
            return this.and();
        }
    }
}

