/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DecisionGroupStatusFluent<A extends DecisionGroupStatusFluent<A>>
extends BaseFluent<A> {
    private Integer clusterCount;
    private Integer decisionGroupIndex;
    private String decisionGroupName;
    private List<String> decisions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public DecisionGroupStatusFluent() {
    }

    public DecisionGroupStatusFluent(DecisionGroupStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DecisionGroupStatus instance) {
        DecisionGroupStatus decisionGroupStatus = instance = instance != null ? instance : new DecisionGroupStatus();
        if (instance != null) {
            this.withClusterCount(instance.getClusterCount());
            this.withDecisionGroupIndex(instance.getDecisionGroupIndex());
            this.withDecisionGroupName(instance.getDecisionGroupName());
            this.withDecisions(instance.getDecisions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getClusterCount() {
        return this.clusterCount;
    }

    public A withClusterCount(Integer clusterCount) {
        this.clusterCount = clusterCount;
        return (A)((Object)this);
    }

    public boolean hasClusterCount() {
        return this.clusterCount != null;
    }

    public Integer getDecisionGroupIndex() {
        return this.decisionGroupIndex;
    }

    public A withDecisionGroupIndex(Integer decisionGroupIndex) {
        this.decisionGroupIndex = decisionGroupIndex;
        return (A)((Object)this);
    }

    public boolean hasDecisionGroupIndex() {
        return this.decisionGroupIndex != null;
    }

    public String getDecisionGroupName() {
        return this.decisionGroupName;
    }

    public A withDecisionGroupName(String decisionGroupName) {
        this.decisionGroupName = decisionGroupName;
        return (A)((Object)this);
    }

    public boolean hasDecisionGroupName() {
        return this.decisionGroupName != null;
    }

    public A addToDecisions(int index, String item) {
        if (this.decisions == null) {
            this.decisions = new ArrayList<String>();
        }
        this.decisions.add(index, item);
        return (A)((Object)this);
    }

    public A setToDecisions(int index, String item) {
        if (this.decisions == null) {
            this.decisions = new ArrayList<String>();
        }
        this.decisions.set(index, item);
        return (A)((Object)this);
    }

    public A addToDecisions(String ... items) {
        if (this.decisions == null) {
            this.decisions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decisions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDecisions(Collection<String> items) {
        if (this.decisions == null) {
            this.decisions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decisions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDecisions(String ... items) {
        if (this.decisions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.decisions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDecisions(Collection<String> items) {
        if (this.decisions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.decisions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDecisions() {
        return this.decisions;
    }

    public String getDecision(int index) {
        return this.decisions.get(index);
    }

    public String getFirstDecision() {
        return this.decisions.get(0);
    }

    public String getLastDecision() {
        return this.decisions.get(this.decisions.size() - 1);
    }

    public String getMatchingDecision(Predicate<String> predicate) {
        for (String item : this.decisions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDecision(Predicate<String> predicate) {
        for (String item : this.decisions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDecisions(List<String> decisions) {
        if (decisions != null) {
            this.decisions = new ArrayList<String>();
            for (String item : decisions) {
                this.addToDecisions(item);
            }
        } else {
            this.decisions = null;
        }
        return (A)((Object)this);
    }

    public A withDecisions(String ... decisions) {
        if (this.decisions != null) {
            this.decisions.clear();
            this._visitables.remove((Object)"decisions");
        }
        if (decisions != null) {
            for (String item : decisions) {
                this.addToDecisions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDecisions() {
        return this.decisions != null && !this.decisions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DecisionGroupStatusFluent that = (DecisionGroupStatusFluent)((Object)o);
        if (!Objects.equals(this.clusterCount, that.clusterCount)) {
            return false;
        }
        if (!Objects.equals(this.decisionGroupIndex, that.decisionGroupIndex)) {
            return false;
        }
        if (!Objects.equals(this.decisionGroupName, that.decisionGroupName)) {
            return false;
        }
        if (!Objects.equals(this.decisions, that.decisions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clusterCount, this.decisionGroupIndex, this.decisionGroupName, this.decisions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterCount != null) {
            sb.append("clusterCount:");
            sb.append(this.clusterCount + ",");
        }
        if (this.decisionGroupIndex != null) {
            sb.append("decisionGroupIndex:");
            sb.append(this.decisionGroupIndex + ",");
        }
        if (this.decisionGroupName != null) {
            sb.append("decisionGroupName:");
            sb.append(this.decisionGroupName + ",");
        }
        if (this.decisions != null && !this.decisions.isEmpty()) {
            sb.append("decisions:");
            sb.append(String.valueOf(this.decisions) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

