/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroup;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.GroupStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GroupStrategyFluent<A extends GroupStrategyFluent<A>>
extends BaseFluent<A> {
    private IntOrStringBuilder clustersPerDecisionGroup;
    private ArrayList<DecisionGroupBuilder> decisionGroups = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GroupStrategyFluent() {
    }

    public GroupStrategyFluent(GroupStrategy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GroupStrategy instance) {
        GroupStrategy groupStrategy = instance = instance != null ? instance : new GroupStrategy();
        if (instance != null) {
            this.withClustersPerDecisionGroup(instance.getClustersPerDecisionGroup());
            this.withDecisionGroups(instance.getDecisionGroups());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IntOrString buildClustersPerDecisionGroup() {
        return this.clustersPerDecisionGroup != null ? this.clustersPerDecisionGroup.build() : null;
    }

    public A withClustersPerDecisionGroup(IntOrString clustersPerDecisionGroup) {
        this._visitables.remove((Object)"clustersPerDecisionGroup");
        if (clustersPerDecisionGroup != null) {
            this.clustersPerDecisionGroup = new IntOrStringBuilder(clustersPerDecisionGroup);
            this._visitables.get((Object)"clustersPerDecisionGroup").add(this.clustersPerDecisionGroup);
        } else {
            this.clustersPerDecisionGroup = null;
            this._visitables.get((Object)"clustersPerDecisionGroup").remove(this.clustersPerDecisionGroup);
        }
        return (A)((Object)this);
    }

    public boolean hasClustersPerDecisionGroup() {
        return this.clustersPerDecisionGroup != null;
    }

    public A withNewClustersPerDecisionGroup(Object value) {
        return this.withClustersPerDecisionGroup(new IntOrString(value));
    }

    public ClustersPerDecisionGroupNested<A> withNewClustersPerDecisionGroup() {
        return new ClustersPerDecisionGroupNested(null);
    }

    public ClustersPerDecisionGroupNested<A> withNewClustersPerDecisionGroupLike(IntOrString item) {
        return new ClustersPerDecisionGroupNested(item);
    }

    public ClustersPerDecisionGroupNested<A> editClustersPerDecisionGroup() {
        return this.withNewClustersPerDecisionGroupLike(Optional.ofNullable(this.buildClustersPerDecisionGroup()).orElse(null));
    }

    public ClustersPerDecisionGroupNested<A> editOrNewClustersPerDecisionGroup() {
        return this.withNewClustersPerDecisionGroupLike(Optional.ofNullable(this.buildClustersPerDecisionGroup()).orElse(new IntOrStringBuilder().build()));
    }

    public ClustersPerDecisionGroupNested<A> editOrNewClustersPerDecisionGroupLike(IntOrString item) {
        return this.withNewClustersPerDecisionGroupLike(Optional.ofNullable(this.buildClustersPerDecisionGroup()).orElse(item));
    }

    public A addToDecisionGroups(int index, DecisionGroup item) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
        if (index < 0 || index >= this.decisionGroups.size()) {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        } else {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDecisionGroups(int index, DecisionGroup item) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
        if (index < 0 || index >= this.decisionGroups.size()) {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        } else {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDecisionGroups(DecisionGroup ... items) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        for (DecisionGroup item : items) {
            DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDecisionGroups(Collection<DecisionGroup> items) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        for (DecisionGroup item : items) {
            DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDecisionGroups(DecisionGroup ... items) {
        if (this.decisionGroups == null) {
            return (A)((Object)this);
        }
        for (DecisionGroup item : items) {
            DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
            this._visitables.get((Object)"decisionGroups").remove((Object)builder);
            this.decisionGroups.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDecisionGroups(Collection<DecisionGroup> items) {
        if (this.decisionGroups == null) {
            return (A)((Object)this);
        }
        for (DecisionGroup item : items) {
            DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
            this._visitables.get((Object)"decisionGroups").remove((Object)builder);
            this.decisionGroups.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDecisionGroups(Predicate<DecisionGroupBuilder> predicate) {
        if (this.decisionGroups == null) {
            return (A)((Object)this);
        }
        Iterator<DecisionGroupBuilder> each = this.decisionGroups.iterator();
        List visitables = this._visitables.get((Object)"decisionGroups");
        while (each.hasNext()) {
            DecisionGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DecisionGroup> buildDecisionGroups() {
        return this.decisionGroups != null ? GroupStrategyFluent.build(this.decisionGroups) : null;
    }

    public DecisionGroup buildDecisionGroup(int index) {
        return this.decisionGroups.get(index).build();
    }

    public DecisionGroup buildFirstDecisionGroup() {
        return this.decisionGroups.get(0).build();
    }

    public DecisionGroup buildLastDecisionGroup() {
        return this.decisionGroups.get(this.decisionGroups.size() - 1).build();
    }

    public DecisionGroup buildMatchingDecisionGroup(Predicate<DecisionGroupBuilder> predicate) {
        for (DecisionGroupBuilder item : this.decisionGroups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDecisionGroup(Predicate<DecisionGroupBuilder> predicate) {
        for (DecisionGroupBuilder item : this.decisionGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDecisionGroups(List<DecisionGroup> decisionGroups) {
        if (this.decisionGroups != null) {
            this._visitables.get((Object)"decisionGroups").clear();
        }
        if (decisionGroups != null) {
            this.decisionGroups = new ArrayList();
            for (DecisionGroup item : decisionGroups) {
                this.addToDecisionGroups(item);
            }
        } else {
            this.decisionGroups = null;
        }
        return (A)((Object)this);
    }

    public A withDecisionGroups(DecisionGroup ... decisionGroups) {
        if (this.decisionGroups != null) {
            this.decisionGroups.clear();
            this._visitables.remove((Object)"decisionGroups");
        }
        if (decisionGroups != null) {
            for (DecisionGroup item : decisionGroups) {
                this.addToDecisionGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDecisionGroups() {
        return this.decisionGroups != null && !this.decisionGroups.isEmpty();
    }

    public DecisionGroupsNested<A> addNewDecisionGroup() {
        return new DecisionGroupsNested(-1, null);
    }

    public DecisionGroupsNested<A> addNewDecisionGroupLike(DecisionGroup item) {
        return new DecisionGroupsNested(-1, item);
    }

    public DecisionGroupsNested<A> setNewDecisionGroupLike(int index, DecisionGroup item) {
        return new DecisionGroupsNested(index, item);
    }

    public DecisionGroupsNested<A> editDecisionGroup(int index) {
        if (this.decisionGroups.size() <= index) {
            throw new RuntimeException("Can't edit decisionGroups. Index exceeds size.");
        }
        return this.setNewDecisionGroupLike(index, this.buildDecisionGroup(index));
    }

    public DecisionGroupsNested<A> editFirstDecisionGroup() {
        if (this.decisionGroups.size() == 0) {
            throw new RuntimeException("Can't edit first decisionGroups. The list is empty.");
        }
        return this.setNewDecisionGroupLike(0, this.buildDecisionGroup(0));
    }

    public DecisionGroupsNested<A> editLastDecisionGroup() {
        int index = this.decisionGroups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last decisionGroups. The list is empty.");
        }
        return this.setNewDecisionGroupLike(index, this.buildDecisionGroup(index));
    }

    public DecisionGroupsNested<A> editMatchingDecisionGroup(Predicate<DecisionGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.decisionGroups.size(); ++i) {
            if (!predicate.test(this.decisionGroups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching decisionGroups. No match found.");
        }
        return this.setNewDecisionGroupLike(index, this.buildDecisionGroup(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupStrategyFluent that = (GroupStrategyFluent)((Object)o);
        if (!Objects.equals(this.clustersPerDecisionGroup, that.clustersPerDecisionGroup)) {
            return false;
        }
        if (!Objects.equals(this.decisionGroups, that.decisionGroups)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clustersPerDecisionGroup, this.decisionGroups, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clustersPerDecisionGroup != null) {
            sb.append("clustersPerDecisionGroup:");
            sb.append(String.valueOf(this.clustersPerDecisionGroup) + ",");
        }
        if (this.decisionGroups != null && !this.decisionGroups.isEmpty()) {
            sb.append("decisionGroups:");
            sb.append(String.valueOf(this.decisionGroups) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DecisionGroupsNested<N>
    extends DecisionGroupFluent<DecisionGroupsNested<N>>
    implements Nested<N> {
        DecisionGroupBuilder builder;
        int index;

        DecisionGroupsNested(int index, DecisionGroup item) {
            this.index = index;
            this.builder = new DecisionGroupBuilder(this, item);
        }

        public N and() {
            return (N)GroupStrategyFluent.this.setToDecisionGroups(this.index, this.builder.build());
        }

        public N endDecisionGroup() {
            return this.and();
        }
    }

    public class ClustersPerDecisionGroupNested<N>
    extends IntOrStringFluent<ClustersPerDecisionGroupNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        ClustersPerDecisionGroupNested(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        public N and() {
            return (N)GroupStrategyFluent.this.withClustersPerDecisionGroup(this.builder.build());
        }

        public N endClustersPerDecisionGroup() {
            return this.and();
        }
    }
}

