/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupStatus;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupStatusBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupStatusFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.PlacementStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlacementStatusFluent<A extends PlacementStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<DecisionGroupStatusBuilder> decisionGroups = new ArrayList();
    private Integer numberOfSelectedClusters;
    private Map<String, Object> additionalProperties;

    public PlacementStatusFluent() {
    }

    public PlacementStatusFluent(PlacementStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PlacementStatus instance) {
        PlacementStatus placementStatus = instance = instance != null ? instance : new PlacementStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withDecisionGroups(instance.getDecisionGroups());
            this.withNumberOfSelectedClusters(instance.getNumberOfSelectedClusters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToDecisionGroups(int index, DecisionGroupStatus item) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
        if (index < 0 || index >= this.decisionGroups.size()) {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        } else {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDecisionGroups(int index, DecisionGroupStatus item) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
        if (index < 0 || index >= this.decisionGroups.size()) {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        } else {
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDecisionGroups(DecisionGroupStatus ... items) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        for (DecisionGroupStatus item : items) {
            DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDecisionGroups(Collection<DecisionGroupStatus> items) {
        if (this.decisionGroups == null) {
            this.decisionGroups = new ArrayList();
        }
        for (DecisionGroupStatus item : items) {
            DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
            this._visitables.get((Object)"decisionGroups").add(builder);
            this.decisionGroups.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDecisionGroups(DecisionGroupStatus ... items) {
        if (this.decisionGroups == null) {
            return (A)((Object)this);
        }
        for (DecisionGroupStatus item : items) {
            DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
            this._visitables.get((Object)"decisionGroups").remove((Object)builder);
            this.decisionGroups.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDecisionGroups(Collection<DecisionGroupStatus> items) {
        if (this.decisionGroups == null) {
            return (A)((Object)this);
        }
        for (DecisionGroupStatus item : items) {
            DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
            this._visitables.get((Object)"decisionGroups").remove((Object)builder);
            this.decisionGroups.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDecisionGroups(Predicate<DecisionGroupStatusBuilder> predicate) {
        if (this.decisionGroups == null) {
            return (A)((Object)this);
        }
        Iterator<DecisionGroupStatusBuilder> each = this.decisionGroups.iterator();
        List visitables = this._visitables.get((Object)"decisionGroups");
        while (each.hasNext()) {
            DecisionGroupStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DecisionGroupStatus> buildDecisionGroups() {
        return this.decisionGroups != null ? PlacementStatusFluent.build(this.decisionGroups) : null;
    }

    public DecisionGroupStatus buildDecisionGroup(int index) {
        return this.decisionGroups.get(index).build();
    }

    public DecisionGroupStatus buildFirstDecisionGroup() {
        return this.decisionGroups.get(0).build();
    }

    public DecisionGroupStatus buildLastDecisionGroup() {
        return this.decisionGroups.get(this.decisionGroups.size() - 1).build();
    }

    public DecisionGroupStatus buildMatchingDecisionGroup(Predicate<DecisionGroupStatusBuilder> predicate) {
        for (DecisionGroupStatusBuilder item : this.decisionGroups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDecisionGroup(Predicate<DecisionGroupStatusBuilder> predicate) {
        for (DecisionGroupStatusBuilder item : this.decisionGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDecisionGroups(List<DecisionGroupStatus> decisionGroups) {
        if (this.decisionGroups != null) {
            this._visitables.get((Object)"decisionGroups").clear();
        }
        if (decisionGroups != null) {
            this.decisionGroups = new ArrayList();
            for (DecisionGroupStatus item : decisionGroups) {
                this.addToDecisionGroups(item);
            }
        } else {
            this.decisionGroups = null;
        }
        return (A)((Object)this);
    }

    public A withDecisionGroups(DecisionGroupStatus ... decisionGroups) {
        if (this.decisionGroups != null) {
            this.decisionGroups.clear();
            this._visitables.remove((Object)"decisionGroups");
        }
        if (decisionGroups != null) {
            for (DecisionGroupStatus item : decisionGroups) {
                this.addToDecisionGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDecisionGroups() {
        return this.decisionGroups != null && !this.decisionGroups.isEmpty();
    }

    public DecisionGroupsNested<A> addNewDecisionGroup() {
        return new DecisionGroupsNested(-1, null);
    }

    public DecisionGroupsNested<A> addNewDecisionGroupLike(DecisionGroupStatus item) {
        return new DecisionGroupsNested(-1, item);
    }

    public DecisionGroupsNested<A> setNewDecisionGroupLike(int index, DecisionGroupStatus item) {
        return new DecisionGroupsNested(index, item);
    }

    public DecisionGroupsNested<A> editDecisionGroup(int index) {
        if (this.decisionGroups.size() <= index) {
            throw new RuntimeException("Can't edit decisionGroups. Index exceeds size.");
        }
        return this.setNewDecisionGroupLike(index, this.buildDecisionGroup(index));
    }

    public DecisionGroupsNested<A> editFirstDecisionGroup() {
        if (this.decisionGroups.size() == 0) {
            throw new RuntimeException("Can't edit first decisionGroups. The list is empty.");
        }
        return this.setNewDecisionGroupLike(0, this.buildDecisionGroup(0));
    }

    public DecisionGroupsNested<A> editLastDecisionGroup() {
        int index = this.decisionGroups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last decisionGroups. The list is empty.");
        }
        return this.setNewDecisionGroupLike(index, this.buildDecisionGroup(index));
    }

    public DecisionGroupsNested<A> editMatchingDecisionGroup(Predicate<DecisionGroupStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.decisionGroups.size(); ++i) {
            if (!predicate.test(this.decisionGroups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching decisionGroups. No match found.");
        }
        return this.setNewDecisionGroupLike(index, this.buildDecisionGroup(index));
    }

    public Integer getNumberOfSelectedClusters() {
        return this.numberOfSelectedClusters;
    }

    public A withNumberOfSelectedClusters(Integer numberOfSelectedClusters) {
        this.numberOfSelectedClusters = numberOfSelectedClusters;
        return (A)((Object)this);
    }

    public boolean hasNumberOfSelectedClusters() {
        return this.numberOfSelectedClusters != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlacementStatusFluent that = (PlacementStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.decisionGroups, that.decisionGroups)) {
            return false;
        }
        if (!Objects.equals(this.numberOfSelectedClusters, that.numberOfSelectedClusters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.decisionGroups, this.numberOfSelectedClusters, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.decisionGroups != null && !this.decisionGroups.isEmpty()) {
            sb.append("decisionGroups:");
            sb.append(String.valueOf(this.decisionGroups) + ",");
        }
        if (this.numberOfSelectedClusters != null) {
            sb.append("numberOfSelectedClusters:");
            sb.append(this.numberOfSelectedClusters + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DecisionGroupsNested<N>
    extends DecisionGroupStatusFluent<DecisionGroupsNested<N>>
    implements Nested<N> {
        DecisionGroupStatusBuilder builder;
        int index;

        DecisionGroupsNested(int index, DecisionGroupStatus item) {
            this.index = index;
            this.builder = new DecisionGroupStatusBuilder(this, item);
        }

        public N and() {
            return (N)PlacementStatusFluent.this.setToDecisionGroups(this.index, this.builder.build());
        }

        public N endDecisionGroup() {
            return this.and();
        }
    }
}

