/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigSpec;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.Filter;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.FilterBuilder;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.FilterFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DiscoveryConfigSpecFluent<A extends DiscoveryConfigSpecFluent<A>>
extends BaseFluent<A> {
    private String credential;
    private FilterBuilder filters;
    private Map<String, Object> additionalProperties;

    public DiscoveryConfigSpecFluent() {
    }

    public DiscoveryConfigSpecFluent(DiscoveryConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DiscoveryConfigSpec instance) {
        DiscoveryConfigSpec discoveryConfigSpec = instance = instance != null ? instance : new DiscoveryConfigSpec();
        if (instance != null) {
            this.withCredential(instance.getCredential());
            this.withFilters(instance.getFilters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCredential() {
        return this.credential;
    }

    public A withCredential(String credential) {
        this.credential = credential;
        return (A)((Object)this);
    }

    public boolean hasCredential() {
        return this.credential != null;
    }

    public Filter buildFilters() {
        return this.filters != null ? this.filters.build() : null;
    }

    public A withFilters(Filter filters) {
        this._visitables.remove((Object)"filters");
        if (filters != null) {
            this.filters = new FilterBuilder(filters);
            this._visitables.get((Object)"filters").add(this.filters);
        } else {
            this.filters = null;
            this._visitables.get((Object)"filters").remove((Object)this.filters);
        }
        return (A)((Object)this);
    }

    public boolean hasFilters() {
        return this.filters != null;
    }

    public FiltersNested<A> withNewFilters() {
        return new FiltersNested(null);
    }

    public FiltersNested<A> withNewFiltersLike(Filter item) {
        return new FiltersNested(item);
    }

    public FiltersNested<A> editFilters() {
        return this.withNewFiltersLike(Optional.ofNullable(this.buildFilters()).orElse(null));
    }

    public FiltersNested<A> editOrNewFilters() {
        return this.withNewFiltersLike(Optional.ofNullable(this.buildFilters()).orElse(new FilterBuilder().build()));
    }

    public FiltersNested<A> editOrNewFiltersLike(Filter item) {
        return this.withNewFiltersLike(Optional.ofNullable(this.buildFilters()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiscoveryConfigSpecFluent that = (DiscoveryConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.credential, that.credential)) {
            return false;
        }
        if (!Objects.equals((Object)this.filters, (Object)that.filters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credential, this.filters, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.credential != null) {
            sb.append("credential:");
            sb.append(this.credential + ",");
        }
        if (this.filters != null) {
            sb.append("filters:");
            sb.append(String.valueOf((Object)this.filters) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FiltersNested<N>
    extends FilterFluent<FiltersNested<N>>
    implements Nested<N> {
        FilterBuilder builder;

        FiltersNested(Filter item) {
            this.builder = new FilterBuilder(this, item);
        }

        public N and() {
            return (N)DiscoveryConfigSpecFluent.this.withFilters(this.builder.build());
        }

        public N endFilters() {
            return this.and();
        }
    }
}

