/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FilterFluent<A extends FilterFluent<A>>
extends BaseFluent<A> {
    private Integer lastActive;
    private List<String> openShiftVersions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public FilterFluent() {
    }

    public FilterFluent(Filter instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Filter instance) {
        Filter filter = instance = instance != null ? instance : new Filter();
        if (instance != null) {
            this.withLastActive(instance.getLastActive());
            this.withOpenShiftVersions(instance.getOpenShiftVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getLastActive() {
        return this.lastActive;
    }

    public A withLastActive(Integer lastActive) {
        this.lastActive = lastActive;
        return (A)((Object)this);
    }

    public boolean hasLastActive() {
        return this.lastActive != null;
    }

    public A addToOpenShiftVersions(int index, String item) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        this.openShiftVersions.add(index, item);
        return (A)((Object)this);
    }

    public A setToOpenShiftVersions(int index, String item) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        this.openShiftVersions.set(index, item);
        return (A)((Object)this);
    }

    public A addToOpenShiftVersions(String ... items) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.openShiftVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOpenShiftVersions(Collection<String> items) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.openShiftVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOpenShiftVersions(String ... items) {
        if (this.openShiftVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.openShiftVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOpenShiftVersions(Collection<String> items) {
        if (this.openShiftVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.openShiftVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOpenShiftVersions() {
        return this.openShiftVersions;
    }

    public String getOpenShiftVersion(int index) {
        return this.openShiftVersions.get(index);
    }

    public String getFirstOpenShiftVersion() {
        return this.openShiftVersions.get(0);
    }

    public String getLastOpenShiftVersion() {
        return this.openShiftVersions.get(this.openShiftVersions.size() - 1);
    }

    public String getMatchingOpenShiftVersion(Predicate<String> predicate) {
        for (String item : this.openShiftVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOpenShiftVersion(Predicate<String> predicate) {
        for (String item : this.openShiftVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOpenShiftVersions(List<String> openShiftVersions) {
        if (openShiftVersions != null) {
            this.openShiftVersions = new ArrayList<String>();
            for (String item : openShiftVersions) {
                this.addToOpenShiftVersions(item);
            }
        } else {
            this.openShiftVersions = null;
        }
        return (A)((Object)this);
    }

    public A withOpenShiftVersions(String ... openShiftVersions) {
        if (this.openShiftVersions != null) {
            this.openShiftVersions.clear();
            this._visitables.remove((Object)"openShiftVersions");
        }
        if (openShiftVersions != null) {
            for (String item : openShiftVersions) {
                this.addToOpenShiftVersions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOpenShiftVersions() {
        return this.openShiftVersions != null && !this.openShiftVersions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterFluent that = (FilterFluent)((Object)o);
        if (!Objects.equals(this.lastActive, that.lastActive)) {
            return false;
        }
        if (!Objects.equals(this.openShiftVersions, that.openShiftVersions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.lastActive, this.openShiftVersions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lastActive != null) {
            sb.append("lastActive:");
            sb.append(this.lastActive + ",");
        }
        if (this.openShiftVersions != null && !this.openShiftVersions.isEmpty()) {
            sb.append("openShiftVersions:");
            sb.append(String.valueOf(this.openShiftVersions) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

