/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.observability.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.openclustermanagement.api.model.observability.v1beta1.MultiClusterObservabilitySpec;
import io.fabric8.openclustermanagement.api.model.observability.v1beta1.StorageConfigObject;
import io.fabric8.openclustermanagement.api.model.observability.v1beta1.StorageConfigObjectBuilder;
import io.fabric8.openclustermanagement.api.model.observability.v1beta1.StorageConfigObjectFluent;
import io.fabric8.openclustermanagement.api.model.shared.ObservabilityAddonSpec;
import io.fabric8.openclustermanagement.api.model.shared.ObservabilityAddonSpecBuilder;
import io.fabric8.openclustermanagement.api.model.shared.ObservabilityAddonSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MultiClusterObservabilitySpecFluent<A extends MultiClusterObservabilitySpecFluent<A>>
extends BaseFluent<A> {
    private String availabilityConfig;
    private Boolean enableDownSampling;
    private String imagePullPolicy;
    private String imagePullSecret;
    private Map<String, String> nodeSelector;
    private ObservabilityAddonSpecBuilder observabilityAddonSpec;
    private String retentionResolution1h;
    private String retentionResolution5m;
    private String retentionResolutionRaw;
    private StorageConfigObjectBuilder storageConfigObject;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public MultiClusterObservabilitySpecFluent() {
    }

    public MultiClusterObservabilitySpecFluent(MultiClusterObservabilitySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MultiClusterObservabilitySpec instance) {
        MultiClusterObservabilitySpec multiClusterObservabilitySpec = instance = instance != null ? instance : new MultiClusterObservabilitySpec();
        if (instance != null) {
            this.withAvailabilityConfig(instance.getAvailabilityConfig());
            this.withEnableDownSampling(instance.getEnableDownSampling());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecret(instance.getImagePullSecret());
            this.withNodeSelector(instance.getNodeSelector());
            this.withObservabilityAddonSpec(instance.getObservabilityAddonSpec());
            this.withRetentionResolution1h(instance.getRetentionResolution1h());
            this.withRetentionResolution5m(instance.getRetentionResolution5m());
            this.withRetentionResolutionRaw(instance.getRetentionResolutionRaw());
            this.withStorageConfigObject(instance.getStorageConfigObject());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAvailabilityConfig() {
        return this.availabilityConfig;
    }

    public A withAvailabilityConfig(String availabilityConfig) {
        this.availabilityConfig = availabilityConfig;
        return (A)((Object)this);
    }

    public boolean hasAvailabilityConfig() {
        return this.availabilityConfig != null;
    }

    public Boolean getEnableDownSampling() {
        return this.enableDownSampling;
    }

    public A withEnableDownSampling(Boolean enableDownSampling) {
        this.enableDownSampling = enableDownSampling;
        return (A)((Object)this);
    }

    public boolean hasEnableDownSampling() {
        return this.enableDownSampling != null;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public A withImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
        return (A)((Object)this);
    }

    public boolean hasImagePullSecret() {
        return this.imagePullSecret != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public ObservabilityAddonSpec buildObservabilityAddonSpec() {
        return this.observabilityAddonSpec != null ? this.observabilityAddonSpec.build() : null;
    }

    public A withObservabilityAddonSpec(ObservabilityAddonSpec observabilityAddonSpec) {
        this._visitables.remove((Object)"observabilityAddonSpec");
        if (observabilityAddonSpec != null) {
            this.observabilityAddonSpec = new ObservabilityAddonSpecBuilder(observabilityAddonSpec);
            this._visitables.get((Object)"observabilityAddonSpec").add(this.observabilityAddonSpec);
        } else {
            this.observabilityAddonSpec = null;
            this._visitables.get((Object)"observabilityAddonSpec").remove((Object)this.observabilityAddonSpec);
        }
        return (A)((Object)this);
    }

    public boolean hasObservabilityAddonSpec() {
        return this.observabilityAddonSpec != null;
    }

    public ObservabilityAddonSpecNested<A> withNewObservabilityAddonSpec() {
        return new ObservabilityAddonSpecNested(null);
    }

    public ObservabilityAddonSpecNested<A> withNewObservabilityAddonSpecLike(ObservabilityAddonSpec item) {
        return new ObservabilityAddonSpecNested(item);
    }

    public ObservabilityAddonSpecNested<A> editObservabilityAddonSpec() {
        return this.withNewObservabilityAddonSpecLike(Optional.ofNullable(this.buildObservabilityAddonSpec()).orElse(null));
    }

    public ObservabilityAddonSpecNested<A> editOrNewObservabilityAddonSpec() {
        return this.withNewObservabilityAddonSpecLike(Optional.ofNullable(this.buildObservabilityAddonSpec()).orElse(new ObservabilityAddonSpecBuilder().build()));
    }

    public ObservabilityAddonSpecNested<A> editOrNewObservabilityAddonSpecLike(ObservabilityAddonSpec item) {
        return this.withNewObservabilityAddonSpecLike(Optional.ofNullable(this.buildObservabilityAddonSpec()).orElse(item));
    }

    public String getRetentionResolution1h() {
        return this.retentionResolution1h;
    }

    public A withRetentionResolution1h(String retentionResolution1h) {
        this.retentionResolution1h = retentionResolution1h;
        return (A)((Object)this);
    }

    public boolean hasRetentionResolution1h() {
        return this.retentionResolution1h != null;
    }

    public String getRetentionResolution5m() {
        return this.retentionResolution5m;
    }

    public A withRetentionResolution5m(String retentionResolution5m) {
        this.retentionResolution5m = retentionResolution5m;
        return (A)((Object)this);
    }

    public boolean hasRetentionResolution5m() {
        return this.retentionResolution5m != null;
    }

    public String getRetentionResolutionRaw() {
        return this.retentionResolutionRaw;
    }

    public A withRetentionResolutionRaw(String retentionResolutionRaw) {
        this.retentionResolutionRaw = retentionResolutionRaw;
        return (A)((Object)this);
    }

    public boolean hasRetentionResolutionRaw() {
        return this.retentionResolutionRaw != null;
    }

    public StorageConfigObject buildStorageConfigObject() {
        return this.storageConfigObject != null ? this.storageConfigObject.build() : null;
    }

    public A withStorageConfigObject(StorageConfigObject storageConfigObject) {
        this._visitables.remove((Object)"storageConfigObject");
        if (storageConfigObject != null) {
            this.storageConfigObject = new StorageConfigObjectBuilder(storageConfigObject);
            this._visitables.get((Object)"storageConfigObject").add(this.storageConfigObject);
        } else {
            this.storageConfigObject = null;
            this._visitables.get((Object)"storageConfigObject").remove((Object)this.storageConfigObject);
        }
        return (A)((Object)this);
    }

    public boolean hasStorageConfigObject() {
        return this.storageConfigObject != null;
    }

    public StorageConfigObjectNested<A> withNewStorageConfigObject() {
        return new StorageConfigObjectNested(null);
    }

    public StorageConfigObjectNested<A> withNewStorageConfigObjectLike(StorageConfigObject item) {
        return new StorageConfigObjectNested(item);
    }

    public StorageConfigObjectNested<A> editStorageConfigObject() {
        return this.withNewStorageConfigObjectLike(Optional.ofNullable(this.buildStorageConfigObject()).orElse(null));
    }

    public StorageConfigObjectNested<A> editOrNewStorageConfigObject() {
        return this.withNewStorageConfigObjectLike(Optional.ofNullable(this.buildStorageConfigObject()).orElse(new StorageConfigObjectBuilder().build()));
    }

    public StorageConfigObjectNested<A> editOrNewStorageConfigObjectLike(StorageConfigObject item) {
        return this.withNewStorageConfigObjectLike(Optional.ofNullable(this.buildStorageConfigObject()).orElse(item));
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiClusterObservabilitySpecFluent that = (MultiClusterObservabilitySpecFluent)((Object)o);
        if (!Objects.equals(this.availabilityConfig, that.availabilityConfig)) {
            return false;
        }
        if (!Objects.equals(this.enableDownSampling, that.enableDownSampling)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecret, that.imagePullSecret)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.observabilityAddonSpec, (Object)that.observabilityAddonSpec)) {
            return false;
        }
        if (!Objects.equals(this.retentionResolution1h, that.retentionResolution1h)) {
            return false;
        }
        if (!Objects.equals(this.retentionResolution5m, that.retentionResolution5m)) {
            return false;
        }
        if (!Objects.equals(this.retentionResolutionRaw, that.retentionResolutionRaw)) {
            return false;
        }
        if (!Objects.equals((Object)this.storageConfigObject, (Object)that.storageConfigObject)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.availabilityConfig, this.enableDownSampling, this.imagePullPolicy, this.imagePullSecret, this.nodeSelector, this.observabilityAddonSpec, this.retentionResolution1h, this.retentionResolution5m, this.retentionResolutionRaw, this.storageConfigObject, this.tolerations, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityConfig != null) {
            sb.append("availabilityConfig:");
            sb.append(this.availabilityConfig + ",");
        }
        if (this.enableDownSampling != null) {
            sb.append("enableDownSampling:");
            sb.append(this.enableDownSampling + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.imagePullSecret != null) {
            sb.append("imagePullSecret:");
            sb.append(this.imagePullSecret + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(String.valueOf(this.nodeSelector) + ",");
        }
        if (this.observabilityAddonSpec != null) {
            sb.append("observabilityAddonSpec:");
            sb.append(String.valueOf((Object)this.observabilityAddonSpec) + ",");
        }
        if (this.retentionResolution1h != null) {
            sb.append("retentionResolution1h:");
            sb.append(this.retentionResolution1h + ",");
        }
        if (this.retentionResolution5m != null) {
            sb.append("retentionResolution5m:");
            sb.append(this.retentionResolution5m + ",");
        }
        if (this.retentionResolutionRaw != null) {
            sb.append("retentionResolutionRaw:");
            sb.append(this.retentionResolutionRaw + ",");
        }
        if (this.storageConfigObject != null) {
            sb.append("storageConfigObject:");
            sb.append(String.valueOf((Object)this.storageConfigObject) + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(String.valueOf(this.tolerations) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnableDownSampling() {
        return this.withEnableDownSampling(true);
    }

    public class StorageConfigObjectNested<N>
    extends StorageConfigObjectFluent<StorageConfigObjectNested<N>>
    implements Nested<N> {
        StorageConfigObjectBuilder builder;

        StorageConfigObjectNested(StorageConfigObject item) {
            this.builder = new StorageConfigObjectBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterObservabilitySpecFluent.this.withStorageConfigObject(this.builder.build());
        }

        public N endStorageConfigObject() {
            return this.and();
        }
    }

    public class ObservabilityAddonSpecNested<N>
    extends ObservabilityAddonSpecFluent<ObservabilityAddonSpecNested<N>>
    implements Nested<N> {
        ObservabilityAddonSpecBuilder builder;

        ObservabilityAddonSpecNested(ObservabilityAddonSpec item) {
            this.builder = new ObservabilityAddonSpecBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterObservabilitySpecFluent.this.withObservabilityAddonSpec(this.builder.build());
        }

        public N endObservabilityAddonSpec() {
            return this.and();
        }
    }
}

