/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.AdvancedConfig;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.AdvancedConfigBuilder;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.AdvancedConfigFluent;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.CapabilitiesSpec;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.CapabilitiesSpecBuilder;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.CapabilitiesSpecFluent;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.MultiClusterObservabilitySpec;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.StorageConfig;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.StorageConfigBuilder;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.StorageConfigFluent;
import io.fabric8.openclustermanagement.api.model.shared.ObservabilityAddonSpec;
import io.fabric8.openclustermanagement.api.model.shared.ObservabilityAddonSpecBuilder;
import io.fabric8.openclustermanagement.api.model.shared.ObservabilityAddonSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MultiClusterObservabilitySpecFluent<A extends MultiClusterObservabilitySpecFluent<A>>
extends BaseFluent<A> {
    private AdvancedConfigBuilder advanced;
    private CapabilitiesSpecBuilder capabilities;
    private Boolean enableDownsampling;
    private String imagePullPolicy;
    private String imagePullSecret;
    private String instanceSize;
    private Map<String, String> nodeSelector;
    private ObservabilityAddonSpecBuilder observabilityAddonSpec;
    private StorageConfigBuilder storageConfig;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public MultiClusterObservabilitySpecFluent() {
    }

    public MultiClusterObservabilitySpecFluent(MultiClusterObservabilitySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MultiClusterObservabilitySpec instance) {
        MultiClusterObservabilitySpec multiClusterObservabilitySpec = instance = instance != null ? instance : new MultiClusterObservabilitySpec();
        if (instance != null) {
            this.withAdvanced(instance.getAdvanced());
            this.withCapabilities(instance.getCapabilities());
            this.withEnableDownsampling(instance.getEnableDownsampling());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecret(instance.getImagePullSecret());
            this.withInstanceSize(instance.getInstanceSize());
            this.withNodeSelector(instance.getNodeSelector());
            this.withObservabilityAddonSpec(instance.getObservabilityAddonSpec());
            this.withStorageConfig(instance.getStorageConfig());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AdvancedConfig buildAdvanced() {
        return this.advanced != null ? this.advanced.build() : null;
    }

    public A withAdvanced(AdvancedConfig advanced) {
        this._visitables.remove((Object)"advanced");
        if (advanced != null) {
            this.advanced = new AdvancedConfigBuilder(advanced);
            this._visitables.get((Object)"advanced").add(this.advanced);
        } else {
            this.advanced = null;
            this._visitables.get((Object)"advanced").remove((Object)this.advanced);
        }
        return (A)((Object)this);
    }

    public boolean hasAdvanced() {
        return this.advanced != null;
    }

    public AdvancedNested<A> withNewAdvanced() {
        return new AdvancedNested(null);
    }

    public AdvancedNested<A> withNewAdvancedLike(AdvancedConfig item) {
        return new AdvancedNested(item);
    }

    public AdvancedNested<A> editAdvanced() {
        return this.withNewAdvancedLike(Optional.ofNullable(this.buildAdvanced()).orElse(null));
    }

    public AdvancedNested<A> editOrNewAdvanced() {
        return this.withNewAdvancedLike(Optional.ofNullable(this.buildAdvanced()).orElse(new AdvancedConfigBuilder().build()));
    }

    public AdvancedNested<A> editOrNewAdvancedLike(AdvancedConfig item) {
        return this.withNewAdvancedLike(Optional.ofNullable(this.buildAdvanced()).orElse(item));
    }

    public CapabilitiesSpec buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    public A withCapabilities(CapabilitiesSpec capabilities) {
        this._visitables.remove((Object)"capabilities");
        if (capabilities != null) {
            this.capabilities = new CapabilitiesSpecBuilder(capabilities);
            this._visitables.get((Object)"capabilities").add(this.capabilities);
        } else {
            this.capabilities = null;
            this._visitables.get((Object)"capabilities").remove((Object)this.capabilities);
        }
        return (A)((Object)this);
    }

    public boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNested(null);
    }

    public CapabilitiesNested<A> withNewCapabilitiesLike(CapabilitiesSpec item) {
        return new CapabilitiesNested(item);
    }

    public CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(null));
    }

    public CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(new CapabilitiesSpecBuilder().build()));
    }

    public CapabilitiesNested<A> editOrNewCapabilitiesLike(CapabilitiesSpec item) {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(item));
    }

    public Boolean getEnableDownsampling() {
        return this.enableDownsampling;
    }

    public A withEnableDownsampling(Boolean enableDownsampling) {
        this.enableDownsampling = enableDownsampling;
        return (A)((Object)this);
    }

    public boolean hasEnableDownsampling() {
        return this.enableDownsampling != null;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public A withImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
        return (A)((Object)this);
    }

    public boolean hasImagePullSecret() {
        return this.imagePullSecret != null;
    }

    public String getInstanceSize() {
        return this.instanceSize;
    }

    public A withInstanceSize(String instanceSize) {
        this.instanceSize = instanceSize;
        return (A)((Object)this);
    }

    public boolean hasInstanceSize() {
        return this.instanceSize != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public ObservabilityAddonSpec buildObservabilityAddonSpec() {
        return this.observabilityAddonSpec != null ? this.observabilityAddonSpec.build() : null;
    }

    public A withObservabilityAddonSpec(ObservabilityAddonSpec observabilityAddonSpec) {
        this._visitables.remove((Object)"observabilityAddonSpec");
        if (observabilityAddonSpec != null) {
            this.observabilityAddonSpec = new ObservabilityAddonSpecBuilder(observabilityAddonSpec);
            this._visitables.get((Object)"observabilityAddonSpec").add(this.observabilityAddonSpec);
        } else {
            this.observabilityAddonSpec = null;
            this._visitables.get((Object)"observabilityAddonSpec").remove((Object)this.observabilityAddonSpec);
        }
        return (A)((Object)this);
    }

    public boolean hasObservabilityAddonSpec() {
        return this.observabilityAddonSpec != null;
    }

    public ObservabilityAddonSpecNested<A> withNewObservabilityAddonSpec() {
        return new ObservabilityAddonSpecNested(null);
    }

    public ObservabilityAddonSpecNested<A> withNewObservabilityAddonSpecLike(ObservabilityAddonSpec item) {
        return new ObservabilityAddonSpecNested(item);
    }

    public ObservabilityAddonSpecNested<A> editObservabilityAddonSpec() {
        return this.withNewObservabilityAddonSpecLike(Optional.ofNullable(this.buildObservabilityAddonSpec()).orElse(null));
    }

    public ObservabilityAddonSpecNested<A> editOrNewObservabilityAddonSpec() {
        return this.withNewObservabilityAddonSpecLike(Optional.ofNullable(this.buildObservabilityAddonSpec()).orElse(new ObservabilityAddonSpecBuilder().build()));
    }

    public ObservabilityAddonSpecNested<A> editOrNewObservabilityAddonSpecLike(ObservabilityAddonSpec item) {
        return this.withNewObservabilityAddonSpecLike(Optional.ofNullable(this.buildObservabilityAddonSpec()).orElse(item));
    }

    public StorageConfig buildStorageConfig() {
        return this.storageConfig != null ? this.storageConfig.build() : null;
    }

    public A withStorageConfig(StorageConfig storageConfig) {
        this._visitables.remove((Object)"storageConfig");
        if (storageConfig != null) {
            this.storageConfig = new StorageConfigBuilder(storageConfig);
            this._visitables.get((Object)"storageConfig").add(this.storageConfig);
        } else {
            this.storageConfig = null;
            this._visitables.get((Object)"storageConfig").remove((Object)this.storageConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasStorageConfig() {
        return this.storageConfig != null;
    }

    public StorageConfigNested<A> withNewStorageConfig() {
        return new StorageConfigNested(null);
    }

    public StorageConfigNested<A> withNewStorageConfigLike(StorageConfig item) {
        return new StorageConfigNested(item);
    }

    public StorageConfigNested<A> editStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(null));
    }

    public StorageConfigNested<A> editOrNewStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(new StorageConfigBuilder().build()));
    }

    public StorageConfigNested<A> editOrNewStorageConfigLike(StorageConfig item) {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(item));
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiClusterObservabilitySpecFluent that = (MultiClusterObservabilitySpecFluent)((Object)o);
        if (!Objects.equals((Object)this.advanced, (Object)that.advanced)) {
            return false;
        }
        if (!Objects.equals((Object)this.capabilities, (Object)that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.enableDownsampling, that.enableDownsampling)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecret, that.imagePullSecret)) {
            return false;
        }
        if (!Objects.equals(this.instanceSize, that.instanceSize)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.observabilityAddonSpec, (Object)that.observabilityAddonSpec)) {
            return false;
        }
        if (!Objects.equals((Object)this.storageConfig, (Object)that.storageConfig)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.advanced, this.capabilities, this.enableDownsampling, this.imagePullPolicy, this.imagePullSecret, this.instanceSize, this.nodeSelector, this.observabilityAddonSpec, this.storageConfig, this.tolerations, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.advanced != null) {
            sb.append("advanced:");
            sb.append(String.valueOf((Object)this.advanced) + ",");
        }
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append(String.valueOf((Object)this.capabilities) + ",");
        }
        if (this.enableDownsampling != null) {
            sb.append("enableDownsampling:");
            sb.append(this.enableDownsampling + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.imagePullSecret != null) {
            sb.append("imagePullSecret:");
            sb.append(this.imagePullSecret + ",");
        }
        if (this.instanceSize != null) {
            sb.append("instanceSize:");
            sb.append(this.instanceSize + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(String.valueOf(this.nodeSelector) + ",");
        }
        if (this.observabilityAddonSpec != null) {
            sb.append("observabilityAddonSpec:");
            sb.append(String.valueOf((Object)this.observabilityAddonSpec) + ",");
        }
        if (this.storageConfig != null) {
            sb.append("storageConfig:");
            sb.append(String.valueOf((Object)this.storageConfig) + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(String.valueOf(this.tolerations) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnableDownsampling() {
        return this.withEnableDownsampling(true);
    }

    public class StorageConfigNested<N>
    extends StorageConfigFluent<StorageConfigNested<N>>
    implements Nested<N> {
        StorageConfigBuilder builder;

        StorageConfigNested(StorageConfig item) {
            this.builder = new StorageConfigBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterObservabilitySpecFluent.this.withStorageConfig(this.builder.build());
        }

        public N endStorageConfig() {
            return this.and();
        }
    }

    public class ObservabilityAddonSpecNested<N>
    extends ObservabilityAddonSpecFluent<ObservabilityAddonSpecNested<N>>
    implements Nested<N> {
        ObservabilityAddonSpecBuilder builder;

        ObservabilityAddonSpecNested(ObservabilityAddonSpec item) {
            this.builder = new ObservabilityAddonSpecBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterObservabilitySpecFluent.this.withObservabilityAddonSpec(this.builder.build());
        }

        public N endObservabilityAddonSpec() {
            return this.and();
        }
    }

    public class CapabilitiesNested<N>
    extends CapabilitiesSpecFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        CapabilitiesSpecBuilder builder;

        CapabilitiesNested(CapabilitiesSpec item) {
            this.builder = new CapabilitiesSpecBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterObservabilitySpecFluent.this.withCapabilities(this.builder.build());
        }

        public N endCapabilities() {
            return this.and();
        }
    }

    public class AdvancedNested<N>
    extends AdvancedConfigFluent<AdvancedNested<N>>
    implements Nested<N> {
        AdvancedConfigBuilder builder;

        AdvancedNested(AdvancedConfig item) {
            this.builder = new AdvancedConfigBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterObservabilitySpecFluent.this.withAdvanced(this.builder.build());
        }

        public N endAdvanced() {
            return this.and();
        }
    }
}

