/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.StoreSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StoreSpecFluent<A extends StoreSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ContainerBuilder> containers = new ArrayList();
    private Integer replicas;
    private ResourceRequirementsBuilder resources;
    private Map<String, String> serviceAccountAnnotations;
    private Map<String, Object> additionalProperties;

    public StoreSpecFluent() {
    }

    public StoreSpecFluent(StoreSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StoreSpec instance) {
        StoreSpec storeSpec = instance = instance != null ? instance : new StoreSpec();
        if (instance != null) {
            this.withContainers(instance.getContainers());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withServiceAccountAnnotations(instance.getServiceAccountAnnotations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainers(Container ... items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainers(Collection<Container> items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Container> buildContainers() {
        return this.containers != null ? StoreSpecFluent.build(this.containers) : null;
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)((Object)this);
    }

    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove((Object)"containers");
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove(this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public A addToServiceAccountAnnotations(String key, String value) {
        if (this.serviceAccountAnnotations == null && key != null && value != null) {
            this.serviceAccountAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.serviceAccountAnnotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToServiceAccountAnnotations(Map<String, String> map) {
        if (this.serviceAccountAnnotations == null && map != null) {
            this.serviceAccountAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.serviceAccountAnnotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceAccountAnnotations(String key) {
        if (this.serviceAccountAnnotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.serviceAccountAnnotations != null) {
            this.serviceAccountAnnotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceAccountAnnotations(Map<String, String> map) {
        if (this.serviceAccountAnnotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.serviceAccountAnnotations == null) continue;
                this.serviceAccountAnnotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getServiceAccountAnnotations() {
        return this.serviceAccountAnnotations;
    }

    public <K, V> A withServiceAccountAnnotations(Map<String, String> serviceAccountAnnotations) {
        this.serviceAccountAnnotations = serviceAccountAnnotations == null ? null : new LinkedHashMap<String, String>(serviceAccountAnnotations);
        return (A)((Object)this);
    }

    public boolean hasServiceAccountAnnotations() {
        return this.serviceAccountAnnotations != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StoreSpecFluent that = (StoreSpecFluent)((Object)o);
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountAnnotations, that.serviceAccountAnnotations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.containers, this.replicas, this.resources, this.serviceAccountAnnotations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(String.valueOf(this.containers) + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(String.valueOf(this.resources) + ",");
        }
        if (this.serviceAccountAnnotations != null && !this.serviceAccountAnnotations.isEmpty()) {
            sb.append("serviceAccountAnnotations:");
            sb.append(String.valueOf(this.serviceAccountAnnotations) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)StoreSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        ContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        public N and() {
            return (N)StoreSpecFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }
}

