/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.AwsIrsaConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AwsIrsaConfigFluent<A extends AwsIrsaConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> autoApprovedIdentities = new ArrayList<String>();
    private String hubClusterArn;
    private List<String> tags = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public AwsIrsaConfigFluent() {
    }

    public AwsIrsaConfigFluent(AwsIrsaConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AwsIrsaConfig instance) {
        AwsIrsaConfig awsIrsaConfig = instance = instance != null ? instance : new AwsIrsaConfig();
        if (instance != null) {
            this.withAutoApprovedIdentities(instance.getAutoApprovedIdentities());
            this.withHubClusterArn(instance.getHubClusterArn());
            this.withTags(instance.getTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAutoApprovedIdentities(int index, String item) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        this.autoApprovedIdentities.add(index, item);
        return (A)((Object)this);
    }

    public A setToAutoApprovedIdentities(int index, String item) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        this.autoApprovedIdentities.set(index, item);
        return (A)((Object)this);
    }

    public A addToAutoApprovedIdentities(String ... items) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoApprovedIdentities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAutoApprovedIdentities(Collection<String> items) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoApprovedIdentities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAutoApprovedIdentities(String ... items) {
        if (this.autoApprovedIdentities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoApprovedIdentities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAutoApprovedIdentities(Collection<String> items) {
        if (this.autoApprovedIdentities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoApprovedIdentities.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAutoApprovedIdentities() {
        return this.autoApprovedIdentities;
    }

    public String getAutoApprovedIdentity(int index) {
        return this.autoApprovedIdentities.get(index);
    }

    public String getFirstAutoApprovedIdentity() {
        return this.autoApprovedIdentities.get(0);
    }

    public String getLastAutoApprovedIdentity() {
        return this.autoApprovedIdentities.get(this.autoApprovedIdentities.size() - 1);
    }

    public String getMatchingAutoApprovedIdentity(Predicate<String> predicate) {
        for (String item : this.autoApprovedIdentities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAutoApprovedIdentity(Predicate<String> predicate) {
        for (String item : this.autoApprovedIdentities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAutoApprovedIdentities(List<String> autoApprovedIdentities) {
        if (autoApprovedIdentities != null) {
            this.autoApprovedIdentities = new ArrayList<String>();
            for (String item : autoApprovedIdentities) {
                this.addToAutoApprovedIdentities(item);
            }
        } else {
            this.autoApprovedIdentities = null;
        }
        return (A)((Object)this);
    }

    public A withAutoApprovedIdentities(String ... autoApprovedIdentities) {
        if (this.autoApprovedIdentities != null) {
            this.autoApprovedIdentities.clear();
            this._visitables.remove((Object)"autoApprovedIdentities");
        }
        if (autoApprovedIdentities != null) {
            for (String item : autoApprovedIdentities) {
                this.addToAutoApprovedIdentities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAutoApprovedIdentities() {
        return this.autoApprovedIdentities != null && !this.autoApprovedIdentities.isEmpty();
    }

    public String getHubClusterArn() {
        return this.hubClusterArn;
    }

    public A withHubClusterArn(String hubClusterArn) {
        this.hubClusterArn = hubClusterArn;
        return (A)((Object)this);
    }

    public boolean hasHubClusterArn() {
        return this.hubClusterArn != null;
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)((Object)this);
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)((Object)this);
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTag(int index) {
        return this.tags.get(index);
    }

    public String getFirstTag() {
        return this.tags.get(0);
    }

    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)((Object)this);
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AwsIrsaConfigFluent that = (AwsIrsaConfigFluent)((Object)o);
        if (!Objects.equals(this.autoApprovedIdentities, that.autoApprovedIdentities)) {
            return false;
        }
        if (!Objects.equals(this.hubClusterArn, that.hubClusterArn)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.autoApprovedIdentities, this.hubClusterArn, this.tags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoApprovedIdentities != null && !this.autoApprovedIdentities.isEmpty()) {
            sb.append("autoApprovedIdentities:");
            sb.append(String.valueOf(this.autoApprovedIdentities) + ",");
        }
        if (this.hubClusterArn != null) {
            sb.append("hubClusterArn:");
            sb.append(this.hubClusterArn + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(String.valueOf(this.tags) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

