/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import io.fabric8.openclustermanagement.api.model.operator.v1.BlockDeletionResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BlockDeletionResourceFluent<A extends BlockDeletionResourceFluent<A>>
extends BaseFluent<A> {
    private Integer exceptionTotal;
    private GroupVersionKind gVK;
    private Map<String, String> labelExceptions;
    private String name;
    private List<String> nameExceptions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public BlockDeletionResourceFluent() {
    }

    public BlockDeletionResourceFluent(BlockDeletionResource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BlockDeletionResource instance) {
        BlockDeletionResource blockDeletionResource = instance = instance != null ? instance : new BlockDeletionResource();
        if (instance != null) {
            this.withExceptionTotal(instance.getExceptionTotal());
            this.withGVK(instance.getGVK());
            this.withLabelExceptions(instance.getLabelExceptions());
            this.withName(instance.getName());
            this.withNameExceptions(instance.getNameExceptions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getExceptionTotal() {
        return this.exceptionTotal;
    }

    public A withExceptionTotal(Integer exceptionTotal) {
        this.exceptionTotal = exceptionTotal;
        return (A)((Object)this);
    }

    public boolean hasExceptionTotal() {
        return this.exceptionTotal != null;
    }

    public GroupVersionKind getGVK() {
        return this.gVK;
    }

    public A withGVK(GroupVersionKind gVK) {
        this.gVK = gVK;
        return (A)((Object)this);
    }

    public boolean hasGVK() {
        return this.gVK != null;
    }

    public A withNewGVK(String group, String kind, String version) {
        return this.withGVK(new GroupVersionKind(group, kind, version));
    }

    public A addToLabelExceptions(String key, String value) {
        if (this.labelExceptions == null && key != null && value != null) {
            this.labelExceptions = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labelExceptions.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabelExceptions(Map<String, String> map) {
        if (this.labelExceptions == null && map != null) {
            this.labelExceptions = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labelExceptions.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabelExceptions(String key) {
        if (this.labelExceptions == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labelExceptions != null) {
            this.labelExceptions.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabelExceptions(Map<String, String> map) {
        if (this.labelExceptions == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labelExceptions == null) continue;
                this.labelExceptions.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabelExceptions() {
        return this.labelExceptions;
    }

    public <K, V> A withLabelExceptions(Map<String, String> labelExceptions) {
        this.labelExceptions = labelExceptions == null ? null : new LinkedHashMap<String, String>(labelExceptions);
        return (A)((Object)this);
    }

    public boolean hasLabelExceptions() {
        return this.labelExceptions != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToNameExceptions(int index, String item) {
        if (this.nameExceptions == null) {
            this.nameExceptions = new ArrayList<String>();
        }
        this.nameExceptions.add(index, item);
        return (A)((Object)this);
    }

    public A setToNameExceptions(int index, String item) {
        if (this.nameExceptions == null) {
            this.nameExceptions = new ArrayList<String>();
        }
        this.nameExceptions.set(index, item);
        return (A)((Object)this);
    }

    public A addToNameExceptions(String ... items) {
        if (this.nameExceptions == null) {
            this.nameExceptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameExceptions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNameExceptions(Collection<String> items) {
        if (this.nameExceptions == null) {
            this.nameExceptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameExceptions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNameExceptions(String ... items) {
        if (this.nameExceptions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameExceptions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNameExceptions(Collection<String> items) {
        if (this.nameExceptions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameExceptions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNameExceptions() {
        return this.nameExceptions;
    }

    public String getNameException(int index) {
        return this.nameExceptions.get(index);
    }

    public String getFirstNameException() {
        return this.nameExceptions.get(0);
    }

    public String getLastNameException() {
        return this.nameExceptions.get(this.nameExceptions.size() - 1);
    }

    public String getMatchingNameException(Predicate<String> predicate) {
        for (String item : this.nameExceptions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameException(Predicate<String> predicate) {
        for (String item : this.nameExceptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameExceptions(List<String> nameExceptions) {
        if (nameExceptions != null) {
            this.nameExceptions = new ArrayList<String>();
            for (String item : nameExceptions) {
                this.addToNameExceptions(item);
            }
        } else {
            this.nameExceptions = null;
        }
        return (A)((Object)this);
    }

    public A withNameExceptions(String ... nameExceptions) {
        if (this.nameExceptions != null) {
            this.nameExceptions.clear();
            this._visitables.remove((Object)"nameExceptions");
        }
        if (nameExceptions != null) {
            for (String item : nameExceptions) {
                this.addToNameExceptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNameExceptions() {
        return this.nameExceptions != null && !this.nameExceptions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockDeletionResourceFluent that = (BlockDeletionResourceFluent)((Object)o);
        if (!Objects.equals(this.exceptionTotal, that.exceptionTotal)) {
            return false;
        }
        if (!Objects.equals(this.gVK, that.gVK)) {
            return false;
        }
        if (!Objects.equals(this.labelExceptions, that.labelExceptions)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nameExceptions, that.nameExceptions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.exceptionTotal, this.gVK, this.labelExceptions, this.name, this.nameExceptions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exceptionTotal != null) {
            sb.append("exceptionTotal:");
            sb.append(this.exceptionTotal + ",");
        }
        if (this.gVK != null) {
            sb.append("gVK:");
            sb.append(String.valueOf(this.gVK) + ",");
        }
        if (this.labelExceptions != null && !this.labelExceptions.isEmpty()) {
            sb.append("labelExceptions:");
            sb.append(String.valueOf(this.labelExceptions) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.nameExceptions != null && !this.nameExceptions.isEmpty()) {
            sb.append("nameExceptions:");
            sb.append(String.valueOf(this.nameExceptions) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

