/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.CSRConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CSRConfigFluent<A extends CSRConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> autoApprovedIdentities = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CSRConfigFluent() {
    }

    public CSRConfigFluent(CSRConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CSRConfig instance) {
        CSRConfig cSRConfig = instance = instance != null ? instance : new CSRConfig();
        if (instance != null) {
            this.withAutoApprovedIdentities(instance.getAutoApprovedIdentities());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAutoApprovedIdentities(int index, String item) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        this.autoApprovedIdentities.add(index, item);
        return (A)((Object)this);
    }

    public A setToAutoApprovedIdentities(int index, String item) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        this.autoApprovedIdentities.set(index, item);
        return (A)((Object)this);
    }

    public A addToAutoApprovedIdentities(String ... items) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoApprovedIdentities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAutoApprovedIdentities(Collection<String> items) {
        if (this.autoApprovedIdentities == null) {
            this.autoApprovedIdentities = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoApprovedIdentities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAutoApprovedIdentities(String ... items) {
        if (this.autoApprovedIdentities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoApprovedIdentities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAutoApprovedIdentities(Collection<String> items) {
        if (this.autoApprovedIdentities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoApprovedIdentities.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAutoApprovedIdentities() {
        return this.autoApprovedIdentities;
    }

    public String getAutoApprovedIdentity(int index) {
        return this.autoApprovedIdentities.get(index);
    }

    public String getFirstAutoApprovedIdentity() {
        return this.autoApprovedIdentities.get(0);
    }

    public String getLastAutoApprovedIdentity() {
        return this.autoApprovedIdentities.get(this.autoApprovedIdentities.size() - 1);
    }

    public String getMatchingAutoApprovedIdentity(Predicate<String> predicate) {
        for (String item : this.autoApprovedIdentities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAutoApprovedIdentity(Predicate<String> predicate) {
        for (String item : this.autoApprovedIdentities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAutoApprovedIdentities(List<String> autoApprovedIdentities) {
        if (autoApprovedIdentities != null) {
            this.autoApprovedIdentities = new ArrayList<String>();
            for (String item : autoApprovedIdentities) {
                this.addToAutoApprovedIdentities(item);
            }
        } else {
            this.autoApprovedIdentities = null;
        }
        return (A)((Object)this);
    }

    public A withAutoApprovedIdentities(String ... autoApprovedIdentities) {
        if (this.autoApprovedIdentities != null) {
            this.autoApprovedIdentities.clear();
            this._visitables.remove((Object)"autoApprovedIdentities");
        }
        if (autoApprovedIdentities != null) {
            for (String item : autoApprovedIdentities) {
                this.addToAutoApprovedIdentities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAutoApprovedIdentities() {
        return this.autoApprovedIdentities != null && !this.autoApprovedIdentities.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSRConfigFluent that = (CSRConfigFluent)((Object)o);
        if (!Objects.equals(this.autoApprovedIdentities, that.autoApprovedIdentities)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.autoApprovedIdentities, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoApprovedIdentities != null && !this.autoApprovedIdentities.isEmpty()) {
            sb.append("autoApprovedIdentities:");
            sb.append(String.valueOf(this.autoApprovedIdentities) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

