/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.ConfigOverride;
import io.fabric8.openclustermanagement.api.model.operator.v1.DeploymentConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.DeploymentConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.DeploymentConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigOverrideFluent<A extends ConfigOverrideFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DeploymentConfigBuilder> deployments = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ConfigOverrideFluent() {
    }

    public ConfigOverrideFluent(ConfigOverride instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConfigOverride instance) {
        ConfigOverride configOverride = instance = instance != null ? instance : new ConfigOverride();
        if (instance != null) {
            this.withDeployments(instance.getDeployments());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDeployments(int index, DeploymentConfig item) {
        if (this.deployments == null) {
            this.deployments = new ArrayList();
        }
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
        if (index < 0 || index >= this.deployments.size()) {
            this._visitables.get((Object)"deployments").add(builder);
            this.deployments.add(builder);
        } else {
            this._visitables.get((Object)"deployments").add(builder);
            this.deployments.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDeployments(int index, DeploymentConfig item) {
        if (this.deployments == null) {
            this.deployments = new ArrayList();
        }
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
        if (index < 0 || index >= this.deployments.size()) {
            this._visitables.get((Object)"deployments").add(builder);
            this.deployments.add(builder);
        } else {
            this._visitables.get((Object)"deployments").add(builder);
            this.deployments.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDeployments(DeploymentConfig ... items) {
        if (this.deployments == null) {
            this.deployments = new ArrayList();
        }
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.get((Object)"deployments").add(builder);
            this.deployments.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDeployments(Collection<DeploymentConfig> items) {
        if (this.deployments == null) {
            this.deployments = new ArrayList();
        }
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.get((Object)"deployments").add(builder);
            this.deployments.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDeployments(DeploymentConfig ... items) {
        if (this.deployments == null) {
            return (A)((Object)this);
        }
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.get((Object)"deployments").remove((Object)builder);
            this.deployments.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDeployments(Collection<DeploymentConfig> items) {
        if (this.deployments == null) {
            return (A)((Object)this);
        }
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.get((Object)"deployments").remove((Object)builder);
            this.deployments.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDeployments(Predicate<DeploymentConfigBuilder> predicate) {
        if (this.deployments == null) {
            return (A)((Object)this);
        }
        Iterator<DeploymentConfigBuilder> each = this.deployments.iterator();
        List visitables = this._visitables.get((Object)"deployments");
        while (each.hasNext()) {
            DeploymentConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DeploymentConfig> buildDeployments() {
        return this.deployments != null ? ConfigOverrideFluent.build(this.deployments) : null;
    }

    public DeploymentConfig buildDeployment(int index) {
        return this.deployments.get(index).build();
    }

    public DeploymentConfig buildFirstDeployment() {
        return this.deployments.get(0).build();
    }

    public DeploymentConfig buildLastDeployment() {
        return this.deployments.get(this.deployments.size() - 1).build();
    }

    public DeploymentConfig buildMatchingDeployment(Predicate<DeploymentConfigBuilder> predicate) {
        for (DeploymentConfigBuilder item : this.deployments) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDeployment(Predicate<DeploymentConfigBuilder> predicate) {
        for (DeploymentConfigBuilder item : this.deployments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDeployments(List<DeploymentConfig> deployments) {
        if (this.deployments != null) {
            this._visitables.get((Object)"deployments").clear();
        }
        if (deployments != null) {
            this.deployments = new ArrayList();
            for (DeploymentConfig item : deployments) {
                this.addToDeployments(item);
            }
        } else {
            this.deployments = null;
        }
        return (A)((Object)this);
    }

    public A withDeployments(DeploymentConfig ... deployments) {
        if (this.deployments != null) {
            this.deployments.clear();
            this._visitables.remove((Object)"deployments");
        }
        if (deployments != null) {
            for (DeploymentConfig item : deployments) {
                this.addToDeployments(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDeployments() {
        return this.deployments != null && !this.deployments.isEmpty();
    }

    public DeploymentsNested<A> addNewDeployment() {
        return new DeploymentsNested(-1, null);
    }

    public DeploymentsNested<A> addNewDeploymentLike(DeploymentConfig item) {
        return new DeploymentsNested(-1, item);
    }

    public DeploymentsNested<A> setNewDeploymentLike(int index, DeploymentConfig item) {
        return new DeploymentsNested(index, item);
    }

    public DeploymentsNested<A> editDeployment(int index) {
        if (this.deployments.size() <= index) {
            throw new RuntimeException("Can't edit deployments. Index exceeds size.");
        }
        return this.setNewDeploymentLike(index, this.buildDeployment(index));
    }

    public DeploymentsNested<A> editFirstDeployment() {
        if (this.deployments.size() == 0) {
            throw new RuntimeException("Can't edit first deployments. The list is empty.");
        }
        return this.setNewDeploymentLike(0, this.buildDeployment(0));
    }

    public DeploymentsNested<A> editLastDeployment() {
        int index = this.deployments.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last deployments. The list is empty.");
        }
        return this.setNewDeploymentLike(index, this.buildDeployment(index));
    }

    public DeploymentsNested<A> editMatchingDeployment(Predicate<DeploymentConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.deployments.size(); ++i) {
            if (!predicate.test(this.deployments.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching deployments. No match found.");
        }
        return this.setNewDeploymentLike(index, this.buildDeployment(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigOverrideFluent that = (ConfigOverrideFluent)((Object)o);
        if (!Objects.equals(this.deployments, that.deployments)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.deployments, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deployments != null && !this.deployments.isEmpty()) {
            sb.append("deployments:");
            sb.append(String.valueOf(this.deployments) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeploymentsNested<N>
    extends DeploymentConfigFluent<DeploymentsNested<N>>
    implements Nested<N> {
        DeploymentConfigBuilder builder;
        int index;

        DeploymentsNested(int index, DeploymentConfig item) {
            this.index = index;
            this.builder = new DeploymentConfigBuilder(this, item);
        }

        public N and() {
            return (N)ConfigOverrideFluent.this.setToDeployments(this.index, this.builder.build());
        }

        public N endDeployment() {
            return this.and();
        }
    }
}

