/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.ContainerConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.EnvConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.EnvConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.EnvConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ContainerConfigFluent<A extends ContainerConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EnvConfigBuilder> env = new ArrayList();
    private String name;
    private Map<String, Object> additionalProperties;

    public ContainerConfigFluent() {
    }

    public ContainerConfigFluent(ContainerConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerConfig instance) {
        ContainerConfig containerConfig = instance = instance != null ? instance : new ContainerConfig();
        if (instance != null) {
            this.withEnv(instance.getEnv());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEnv(int index, EnvConfig item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvConfigBuilder builder = new EnvConfigBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, EnvConfig item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvConfigBuilder builder = new EnvConfigBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(EnvConfig ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvConfig item : items) {
            EnvConfigBuilder builder = new EnvConfigBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<EnvConfig> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvConfig item : items) {
            EnvConfigBuilder builder = new EnvConfigBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvConfig ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvConfig item : items) {
            EnvConfigBuilder builder = new EnvConfigBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<EnvConfig> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvConfig item : items) {
            EnvConfigBuilder builder = new EnvConfigBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvConfigBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvConfigBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvConfig> buildEnv() {
        return this.env != null ? ContainerConfigFluent.build(this.env) : null;
    }

    public EnvConfig buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvConfig buildFirstEnv() {
        return this.env.get(0).build();
    }

    public EnvConfig buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public EnvConfig buildMatchingEnv(Predicate<EnvConfigBuilder> predicate) {
        for (EnvConfigBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvConfigBuilder> predicate) {
        for (EnvConfigBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvConfig> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvConfig item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvConfig ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvConfig item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public A addNewEnv(String name, String value) {
        return this.addToEnv(new EnvConfig(name, value));
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(EnvConfig item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvConfig item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerConfigFluent that = (ContainerConfigFluent)((Object)o);
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(String.valueOf(this.env) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EnvNested<N>
    extends EnvConfigFluent<EnvNested<N>>
    implements Nested<N> {
        EnvConfigBuilder builder;
        int index;

        EnvNested(int index, EnvConfig item) {
            this.index = index;
            this.builder = new EnvConfigBuilder(this, item);
        }

        public N and() {
            return (N)ContainerConfigFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }
}

