/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.ContainerConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.ContainerConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ContainerConfigFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.DeploymentConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentConfigFluent<A extends DeploymentConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ContainerConfigBuilder> containers = new ArrayList();
    private String name;
    private Map<String, Object> additionalProperties;

    public DeploymentConfigFluent() {
    }

    public DeploymentConfigFluent(DeploymentConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeploymentConfig instance) {
        DeploymentConfig deploymentConfig = instance = instance != null ? instance : new DeploymentConfig();
        if (instance != null) {
            this.withContainers(instance.getContainers());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToContainers(int index, ContainerConfig item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerConfigBuilder builder = new ContainerConfigBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainers(int index, ContainerConfig item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerConfigBuilder builder = new ContainerConfigBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainers(ContainerConfig ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (ContainerConfig item : items) {
            ContainerConfigBuilder builder = new ContainerConfigBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContainers(Collection<ContainerConfig> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (ContainerConfig item : items) {
            ContainerConfigBuilder builder = new ContainerConfigBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainers(ContainerConfig ... items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (ContainerConfig item : items) {
            ContainerConfigBuilder builder = new ContainerConfigBuilder(item);
            this._visitables.get((Object)"containers").remove((Object)builder);
            this.containers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainers(Collection<ContainerConfig> items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (ContainerConfig item : items) {
            ContainerConfigBuilder builder = new ContainerConfigBuilder(item);
            this._visitables.get((Object)"containers").remove((Object)builder);
            this.containers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContainers(Predicate<ContainerConfigBuilder> predicate) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerConfigBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContainerConfig> buildContainers() {
        return this.containers != null ? DeploymentConfigFluent.build(this.containers) : null;
    }

    public ContainerConfig buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public ContainerConfig buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public ContainerConfig buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public ContainerConfig buildMatchingContainer(Predicate<ContainerConfigBuilder> predicate) {
        for (ContainerConfigBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainerConfigBuilder> predicate) {
        for (ContainerConfigBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<ContainerConfig> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (ContainerConfig item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)((Object)this);
    }

    public A withContainers(ContainerConfig ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove((Object)"containers");
        }
        if (containers != null) {
            for (ContainerConfig item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(ContainerConfig item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, ContainerConfig item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainerConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigFluent that = (DeploymentConfigFluent)((Object)o);
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.containers, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(String.valueOf(this.containers) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ContainersNested<N>
    extends ContainerConfigFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainerConfigBuilder builder;
        int index;

        ContainersNested(int index, ContainerConfig item) {
            this.index = index;
            this.builder = new ContainerConfigBuilder(this, item);
        }

        public N and() {
            return (N)DeploymentConfigFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }
}

