/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.HostedClusterManagerConfiguration;
import io.fabric8.openclustermanagement.api.model.operator.v1.WebhookConfiguration;
import io.fabric8.openclustermanagement.api.model.operator.v1.WebhookConfigurationBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.WebhookConfigurationFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HostedClusterManagerConfigurationFluent<A extends HostedClusterManagerConfigurationFluent<A>>
extends BaseFluent<A> {
    private WebhookConfigurationBuilder registrationWebhookConfiguration;
    private WebhookConfigurationBuilder workWebhookConfiguration;
    private Map<String, Object> additionalProperties;

    public HostedClusterManagerConfigurationFluent() {
    }

    public HostedClusterManagerConfigurationFluent(HostedClusterManagerConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HostedClusterManagerConfiguration instance) {
        HostedClusterManagerConfiguration hostedClusterManagerConfiguration = instance = instance != null ? instance : new HostedClusterManagerConfiguration();
        if (instance != null) {
            this.withRegistrationWebhookConfiguration(instance.getRegistrationWebhookConfiguration());
            this.withWorkWebhookConfiguration(instance.getWorkWebhookConfiguration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public WebhookConfiguration buildRegistrationWebhookConfiguration() {
        return this.registrationWebhookConfiguration != null ? this.registrationWebhookConfiguration.build() : null;
    }

    public A withRegistrationWebhookConfiguration(WebhookConfiguration registrationWebhookConfiguration) {
        this._visitables.remove((Object)"registrationWebhookConfiguration");
        if (registrationWebhookConfiguration != null) {
            this.registrationWebhookConfiguration = new WebhookConfigurationBuilder(registrationWebhookConfiguration);
            this._visitables.get((Object)"registrationWebhookConfiguration").add(this.registrationWebhookConfiguration);
        } else {
            this.registrationWebhookConfiguration = null;
            this._visitables.get((Object)"registrationWebhookConfiguration").remove((Object)this.registrationWebhookConfiguration);
        }
        return (A)((Object)this);
    }

    public boolean hasRegistrationWebhookConfiguration() {
        return this.registrationWebhookConfiguration != null;
    }

    public A withNewRegistrationWebhookConfiguration(String address, Integer port) {
        return this.withRegistrationWebhookConfiguration(new WebhookConfiguration(address, port));
    }

    public RegistrationWebhookConfigurationNested<A> withNewRegistrationWebhookConfiguration() {
        return new RegistrationWebhookConfigurationNested(null);
    }

    public RegistrationWebhookConfigurationNested<A> withNewRegistrationWebhookConfigurationLike(WebhookConfiguration item) {
        return new RegistrationWebhookConfigurationNested(item);
    }

    public RegistrationWebhookConfigurationNested<A> editRegistrationWebhookConfiguration() {
        return this.withNewRegistrationWebhookConfigurationLike(Optional.ofNullable(this.buildRegistrationWebhookConfiguration()).orElse(null));
    }

    public RegistrationWebhookConfigurationNested<A> editOrNewRegistrationWebhookConfiguration() {
        return this.withNewRegistrationWebhookConfigurationLike(Optional.ofNullable(this.buildRegistrationWebhookConfiguration()).orElse(new WebhookConfigurationBuilder().build()));
    }

    public RegistrationWebhookConfigurationNested<A> editOrNewRegistrationWebhookConfigurationLike(WebhookConfiguration item) {
        return this.withNewRegistrationWebhookConfigurationLike(Optional.ofNullable(this.buildRegistrationWebhookConfiguration()).orElse(item));
    }

    public WebhookConfiguration buildWorkWebhookConfiguration() {
        return this.workWebhookConfiguration != null ? this.workWebhookConfiguration.build() : null;
    }

    public A withWorkWebhookConfiguration(WebhookConfiguration workWebhookConfiguration) {
        this._visitables.remove((Object)"workWebhookConfiguration");
        if (workWebhookConfiguration != null) {
            this.workWebhookConfiguration = new WebhookConfigurationBuilder(workWebhookConfiguration);
            this._visitables.get((Object)"workWebhookConfiguration").add(this.workWebhookConfiguration);
        } else {
            this.workWebhookConfiguration = null;
            this._visitables.get((Object)"workWebhookConfiguration").remove((Object)this.workWebhookConfiguration);
        }
        return (A)((Object)this);
    }

    public boolean hasWorkWebhookConfiguration() {
        return this.workWebhookConfiguration != null;
    }

    public A withNewWorkWebhookConfiguration(String address, Integer port) {
        return this.withWorkWebhookConfiguration(new WebhookConfiguration(address, port));
    }

    public WorkWebhookConfigurationNested<A> withNewWorkWebhookConfiguration() {
        return new WorkWebhookConfigurationNested(null);
    }

    public WorkWebhookConfigurationNested<A> withNewWorkWebhookConfigurationLike(WebhookConfiguration item) {
        return new WorkWebhookConfigurationNested(item);
    }

    public WorkWebhookConfigurationNested<A> editWorkWebhookConfiguration() {
        return this.withNewWorkWebhookConfigurationLike(Optional.ofNullable(this.buildWorkWebhookConfiguration()).orElse(null));
    }

    public WorkWebhookConfigurationNested<A> editOrNewWorkWebhookConfiguration() {
        return this.withNewWorkWebhookConfigurationLike(Optional.ofNullable(this.buildWorkWebhookConfiguration()).orElse(new WebhookConfigurationBuilder().build()));
    }

    public WorkWebhookConfigurationNested<A> editOrNewWorkWebhookConfigurationLike(WebhookConfiguration item) {
        return this.withNewWorkWebhookConfigurationLike(Optional.ofNullable(this.buildWorkWebhookConfiguration()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostedClusterManagerConfigurationFluent that = (HostedClusterManagerConfigurationFluent)((Object)o);
        if (!Objects.equals((Object)this.registrationWebhookConfiguration, (Object)that.registrationWebhookConfiguration)) {
            return false;
        }
        if (!Objects.equals((Object)this.workWebhookConfiguration, (Object)that.workWebhookConfiguration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.registrationWebhookConfiguration, this.workWebhookConfiguration, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.registrationWebhookConfiguration != null) {
            sb.append("registrationWebhookConfiguration:");
            sb.append(String.valueOf((Object)this.registrationWebhookConfiguration) + ",");
        }
        if (this.workWebhookConfiguration != null) {
            sb.append("workWebhookConfiguration:");
            sb.append(String.valueOf((Object)this.workWebhookConfiguration) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WorkWebhookConfigurationNested<N>
    extends WebhookConfigurationFluent<WorkWebhookConfigurationNested<N>>
    implements Nested<N> {
        WebhookConfigurationBuilder builder;

        WorkWebhookConfigurationNested(WebhookConfiguration item) {
            this.builder = new WebhookConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)HostedClusterManagerConfigurationFluent.this.withWorkWebhookConfiguration(this.builder.build());
        }

        public N endWorkWebhookConfiguration() {
            return this.and();
        }
    }

    public class RegistrationWebhookConfigurationNested<N>
    extends WebhookConfigurationFluent<RegistrationWebhookConfigurationNested<N>>
    implements Nested<N> {
        WebhookConfigurationBuilder builder;

        RegistrationWebhookConfigurationNested(WebhookConfiguration item) {
            this.builder = new WebhookConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)HostedClusterManagerConfigurationFluent.this.withRegistrationWebhookConfiguration(this.builder.build());
        }

        public N endRegistrationWebhookConfiguration() {
            return this.and();
        }
    }
}

