/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.IngressSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressSpecFluent<A extends IngressSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> sslCiphers = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public IngressSpecFluent() {
    }

    public IngressSpecFluent(IngressSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressSpec instance) {
        IngressSpec ingressSpec = instance = instance != null ? instance : new IngressSpec();
        if (instance != null) {
            this.withSslCiphers(instance.getSslCiphers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToSslCiphers(int index, String item) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        this.sslCiphers.add(index, item);
        return (A)((Object)this);
    }

    public A setToSslCiphers(int index, String item) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        this.sslCiphers.set(index, item);
        return (A)((Object)this);
    }

    public A addToSslCiphers(String ... items) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.sslCiphers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSslCiphers(Collection<String> items) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.sslCiphers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSslCiphers(String ... items) {
        if (this.sslCiphers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sslCiphers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSslCiphers(Collection<String> items) {
        if (this.sslCiphers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sslCiphers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSslCiphers() {
        return this.sslCiphers;
    }

    public String getSslCipher(int index) {
        return this.sslCiphers.get(index);
    }

    public String getFirstSslCipher() {
        return this.sslCiphers.get(0);
    }

    public String getLastSslCipher() {
        return this.sslCiphers.get(this.sslCiphers.size() - 1);
    }

    public String getMatchingSslCipher(Predicate<String> predicate) {
        for (String item : this.sslCiphers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSslCipher(Predicate<String> predicate) {
        for (String item : this.sslCiphers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSslCiphers(List<String> sslCiphers) {
        if (sslCiphers != null) {
            this.sslCiphers = new ArrayList<String>();
            for (String item : sslCiphers) {
                this.addToSslCiphers(item);
            }
        } else {
            this.sslCiphers = null;
        }
        return (A)((Object)this);
    }

    public A withSslCiphers(String ... sslCiphers) {
        if (this.sslCiphers != null) {
            this.sslCiphers.clear();
            this._visitables.remove((Object)"sslCiphers");
        }
        if (sslCiphers != null) {
            for (String item : sslCiphers) {
                this.addToSslCiphers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSslCiphers() {
        return this.sslCiphers != null && !this.sslCiphers.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecFluent that = (IngressSpecFluent)((Object)o);
        if (!Objects.equals(this.sslCiphers, that.sslCiphers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.sslCiphers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sslCiphers != null && !this.sslCiphers.isEmpty()) {
            sb.append("sslCiphers:");
            sb.append(String.valueOf(this.sslCiphers) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

