/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.KubeConfigSecret;
import io.fabric8.openclustermanagement.api.model.operator.v1.KubeConfigSecretBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.KubeConfigSecretFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.LocalSecretsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LocalSecretsConfigFluent<A extends LocalSecretsConfigFluent<A>>
extends BaseFluent<A> {
    private Integer hubConnectionTimeoutSeconds;
    private ArrayList<KubeConfigSecretBuilder> kubeConfigSecrets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public LocalSecretsConfigFluent() {
    }

    public LocalSecretsConfigFluent(LocalSecretsConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LocalSecretsConfig instance) {
        LocalSecretsConfig localSecretsConfig = instance = instance != null ? instance : new LocalSecretsConfig();
        if (instance != null) {
            this.withHubConnectionTimeoutSeconds(instance.getHubConnectionTimeoutSeconds());
            this.withKubeConfigSecrets(instance.getKubeConfigSecrets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getHubConnectionTimeoutSeconds() {
        return this.hubConnectionTimeoutSeconds;
    }

    public A withHubConnectionTimeoutSeconds(Integer hubConnectionTimeoutSeconds) {
        this.hubConnectionTimeoutSeconds = hubConnectionTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasHubConnectionTimeoutSeconds() {
        return this.hubConnectionTimeoutSeconds != null;
    }

    public A addToKubeConfigSecrets(int index, KubeConfigSecret item) {
        if (this.kubeConfigSecrets == null) {
            this.kubeConfigSecrets = new ArrayList();
        }
        KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
        if (index < 0 || index >= this.kubeConfigSecrets.size()) {
            this._visitables.get((Object)"kubeConfigSecrets").add(builder);
            this.kubeConfigSecrets.add(builder);
        } else {
            this._visitables.get((Object)"kubeConfigSecrets").add(builder);
            this.kubeConfigSecrets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToKubeConfigSecrets(int index, KubeConfigSecret item) {
        if (this.kubeConfigSecrets == null) {
            this.kubeConfigSecrets = new ArrayList();
        }
        KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
        if (index < 0 || index >= this.kubeConfigSecrets.size()) {
            this._visitables.get((Object)"kubeConfigSecrets").add(builder);
            this.kubeConfigSecrets.add(builder);
        } else {
            this._visitables.get((Object)"kubeConfigSecrets").add(builder);
            this.kubeConfigSecrets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToKubeConfigSecrets(KubeConfigSecret ... items) {
        if (this.kubeConfigSecrets == null) {
            this.kubeConfigSecrets = new ArrayList();
        }
        for (KubeConfigSecret item : items) {
            KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
            this._visitables.get((Object)"kubeConfigSecrets").add(builder);
            this.kubeConfigSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToKubeConfigSecrets(Collection<KubeConfigSecret> items) {
        if (this.kubeConfigSecrets == null) {
            this.kubeConfigSecrets = new ArrayList();
        }
        for (KubeConfigSecret item : items) {
            KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
            this._visitables.get((Object)"kubeConfigSecrets").add(builder);
            this.kubeConfigSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromKubeConfigSecrets(KubeConfigSecret ... items) {
        if (this.kubeConfigSecrets == null) {
            return (A)((Object)this);
        }
        for (KubeConfigSecret item : items) {
            KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
            this._visitables.get((Object)"kubeConfigSecrets").remove((Object)builder);
            this.kubeConfigSecrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKubeConfigSecrets(Collection<KubeConfigSecret> items) {
        if (this.kubeConfigSecrets == null) {
            return (A)((Object)this);
        }
        for (KubeConfigSecret item : items) {
            KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
            this._visitables.get((Object)"kubeConfigSecrets").remove((Object)builder);
            this.kubeConfigSecrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromKubeConfigSecrets(Predicate<KubeConfigSecretBuilder> predicate) {
        if (this.kubeConfigSecrets == null) {
            return (A)((Object)this);
        }
        Iterator<KubeConfigSecretBuilder> each = this.kubeConfigSecrets.iterator();
        List visitables = this._visitables.get((Object)"kubeConfigSecrets");
        while (each.hasNext()) {
            KubeConfigSecretBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KubeConfigSecret> buildKubeConfigSecrets() {
        return this.kubeConfigSecrets != null ? LocalSecretsConfigFluent.build(this.kubeConfigSecrets) : null;
    }

    public KubeConfigSecret buildKubeConfigSecret(int index) {
        return this.kubeConfigSecrets.get(index).build();
    }

    public KubeConfigSecret buildFirstKubeConfigSecret() {
        return this.kubeConfigSecrets.get(0).build();
    }

    public KubeConfigSecret buildLastKubeConfigSecret() {
        return this.kubeConfigSecrets.get(this.kubeConfigSecrets.size() - 1).build();
    }

    public KubeConfigSecret buildMatchingKubeConfigSecret(Predicate<KubeConfigSecretBuilder> predicate) {
        for (KubeConfigSecretBuilder item : this.kubeConfigSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingKubeConfigSecret(Predicate<KubeConfigSecretBuilder> predicate) {
        for (KubeConfigSecretBuilder item : this.kubeConfigSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKubeConfigSecrets(List<KubeConfigSecret> kubeConfigSecrets) {
        if (this.kubeConfigSecrets != null) {
            this._visitables.get((Object)"kubeConfigSecrets").clear();
        }
        if (kubeConfigSecrets != null) {
            this.kubeConfigSecrets = new ArrayList();
            for (KubeConfigSecret item : kubeConfigSecrets) {
                this.addToKubeConfigSecrets(item);
            }
        } else {
            this.kubeConfigSecrets = null;
        }
        return (A)((Object)this);
    }

    public A withKubeConfigSecrets(KubeConfigSecret ... kubeConfigSecrets) {
        if (this.kubeConfigSecrets != null) {
            this.kubeConfigSecrets.clear();
            this._visitables.remove((Object)"kubeConfigSecrets");
        }
        if (kubeConfigSecrets != null) {
            for (KubeConfigSecret item : kubeConfigSecrets) {
                this.addToKubeConfigSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasKubeConfigSecrets() {
        return this.kubeConfigSecrets != null && !this.kubeConfigSecrets.isEmpty();
    }

    public A addNewKubeConfigSecret(String name) {
        return this.addToKubeConfigSecrets(new KubeConfigSecret(name));
    }

    public KubeConfigSecretsNested<A> addNewKubeConfigSecret() {
        return new KubeConfigSecretsNested(-1, null);
    }

    public KubeConfigSecretsNested<A> addNewKubeConfigSecretLike(KubeConfigSecret item) {
        return new KubeConfigSecretsNested(-1, item);
    }

    public KubeConfigSecretsNested<A> setNewKubeConfigSecretLike(int index, KubeConfigSecret item) {
        return new KubeConfigSecretsNested(index, item);
    }

    public KubeConfigSecretsNested<A> editKubeConfigSecret(int index) {
        if (this.kubeConfigSecrets.size() <= index) {
            throw new RuntimeException("Can't edit kubeConfigSecrets. Index exceeds size.");
        }
        return this.setNewKubeConfigSecretLike(index, this.buildKubeConfigSecret(index));
    }

    public KubeConfigSecretsNested<A> editFirstKubeConfigSecret() {
        if (this.kubeConfigSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first kubeConfigSecrets. The list is empty.");
        }
        return this.setNewKubeConfigSecretLike(0, this.buildKubeConfigSecret(0));
    }

    public KubeConfigSecretsNested<A> editLastKubeConfigSecret() {
        int index = this.kubeConfigSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last kubeConfigSecrets. The list is empty.");
        }
        return this.setNewKubeConfigSecretLike(index, this.buildKubeConfigSecret(index));
    }

    public KubeConfigSecretsNested<A> editMatchingKubeConfigSecret(Predicate<KubeConfigSecretBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.kubeConfigSecrets.size(); ++i) {
            if (!predicate.test(this.kubeConfigSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching kubeConfigSecrets. No match found.");
        }
        return this.setNewKubeConfigSecretLike(index, this.buildKubeConfigSecret(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalSecretsConfigFluent that = (LocalSecretsConfigFluent)((Object)o);
        if (!Objects.equals(this.hubConnectionTimeoutSeconds, that.hubConnectionTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.kubeConfigSecrets, that.kubeConfigSecrets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hubConnectionTimeoutSeconds, this.kubeConfigSecrets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hubConnectionTimeoutSeconds != null) {
            sb.append("hubConnectionTimeoutSeconds:");
            sb.append(this.hubConnectionTimeoutSeconds + ",");
        }
        if (this.kubeConfigSecrets != null && !this.kubeConfigSecrets.isEmpty()) {
            sb.append("kubeConfigSecrets:");
            sb.append(String.valueOf(this.kubeConfigSecrets) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KubeConfigSecretsNested<N>
    extends KubeConfigSecretFluent<KubeConfigSecretsNested<N>>
    implements Nested<N> {
        KubeConfigSecretBuilder builder;
        int index;

        KubeConfigSecretsNested(int index, KubeConfigSecret item) {
            this.index = index;
            this.builder = new KubeConfigSecretBuilder(this, item);
        }

        public N and() {
            return (N)LocalSecretsConfigFluent.this.setToKubeConfigSecrets(this.index, this.builder.build());
        }

        public N endKubeConfigSecret() {
            return this.and();
        }
    }
}

