/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.openclustermanagement.api.model.operator.v1.HiveConfigSpec;
import io.fabric8.openclustermanagement.api.model.operator.v1.HiveConfigSpecBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.HiveConfigSpecFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.IngressSpec;
import io.fabric8.openclustermanagement.api.model.operator.v1.IngressSpecBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.IngressSpecFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.MultiClusterHubSpec;
import io.fabric8.openclustermanagement.api.model.operator.v1.Overrides;
import io.fabric8.openclustermanagement.api.model.operator.v1.OverridesBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.OverridesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MultiClusterHubSpecFluent<A extends MultiClusterHubSpecFluent<A>>
extends BaseFluent<A> {
    private String availabilityConfig;
    private String customCAConfigmap;
    private Boolean disableHubSelfManagement;
    private Boolean disableUpdateClusterImageSets;
    private Boolean enableClusterBackup;
    private Boolean enableClusterProxyAddon;
    private HiveConfigSpecBuilder hive;
    private String imagePullSecret;
    private IngressSpecBuilder ingress;
    private String localClusterName;
    private Map<String, String> nodeSelector;
    private OverridesBuilder overrides;
    private Boolean separateCertificateManagement;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public MultiClusterHubSpecFluent() {
    }

    public MultiClusterHubSpecFluent(MultiClusterHubSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MultiClusterHubSpec instance) {
        MultiClusterHubSpec multiClusterHubSpec = instance = instance != null ? instance : new MultiClusterHubSpec();
        if (instance != null) {
            this.withAvailabilityConfig(instance.getAvailabilityConfig());
            this.withCustomCAConfigmap(instance.getCustomCAConfigmap());
            this.withDisableHubSelfManagement(instance.getDisableHubSelfManagement());
            this.withDisableUpdateClusterImageSets(instance.getDisableUpdateClusterImageSets());
            this.withEnableClusterBackup(instance.getEnableClusterBackup());
            this.withEnableClusterProxyAddon(instance.getEnableClusterProxyAddon());
            this.withHive(instance.getHive());
            this.withImagePullSecret(instance.getImagePullSecret());
            this.withIngress(instance.getIngress());
            this.withLocalClusterName(instance.getLocalClusterName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOverrides(instance.getOverrides());
            this.withSeparateCertificateManagement(instance.getSeparateCertificateManagement());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAvailabilityConfig() {
        return this.availabilityConfig;
    }

    public A withAvailabilityConfig(String availabilityConfig) {
        this.availabilityConfig = availabilityConfig;
        return (A)((Object)this);
    }

    public boolean hasAvailabilityConfig() {
        return this.availabilityConfig != null;
    }

    public String getCustomCAConfigmap() {
        return this.customCAConfigmap;
    }

    public A withCustomCAConfigmap(String customCAConfigmap) {
        this.customCAConfigmap = customCAConfigmap;
        return (A)((Object)this);
    }

    public boolean hasCustomCAConfigmap() {
        return this.customCAConfigmap != null;
    }

    public Boolean getDisableHubSelfManagement() {
        return this.disableHubSelfManagement;
    }

    public A withDisableHubSelfManagement(Boolean disableHubSelfManagement) {
        this.disableHubSelfManagement = disableHubSelfManagement;
        return (A)((Object)this);
    }

    public boolean hasDisableHubSelfManagement() {
        return this.disableHubSelfManagement != null;
    }

    public Boolean getDisableUpdateClusterImageSets() {
        return this.disableUpdateClusterImageSets;
    }

    public A withDisableUpdateClusterImageSets(Boolean disableUpdateClusterImageSets) {
        this.disableUpdateClusterImageSets = disableUpdateClusterImageSets;
        return (A)((Object)this);
    }

    public boolean hasDisableUpdateClusterImageSets() {
        return this.disableUpdateClusterImageSets != null;
    }

    public Boolean getEnableClusterBackup() {
        return this.enableClusterBackup;
    }

    public A withEnableClusterBackup(Boolean enableClusterBackup) {
        this.enableClusterBackup = enableClusterBackup;
        return (A)((Object)this);
    }

    public boolean hasEnableClusterBackup() {
        return this.enableClusterBackup != null;
    }

    public Boolean getEnableClusterProxyAddon() {
        return this.enableClusterProxyAddon;
    }

    public A withEnableClusterProxyAddon(Boolean enableClusterProxyAddon) {
        this.enableClusterProxyAddon = enableClusterProxyAddon;
        return (A)((Object)this);
    }

    public boolean hasEnableClusterProxyAddon() {
        return this.enableClusterProxyAddon != null;
    }

    public HiveConfigSpec buildHive() {
        return this.hive != null ? this.hive.build() : null;
    }

    public A withHive(HiveConfigSpec hive) {
        this._visitables.remove((Object)"hive");
        if (hive != null) {
            this.hive = new HiveConfigSpecBuilder(hive);
            this._visitables.get((Object)"hive").add(this.hive);
        } else {
            this.hive = null;
            this._visitables.get((Object)"hive").remove((Object)this.hive);
        }
        return (A)((Object)this);
    }

    public boolean hasHive() {
        return this.hive != null;
    }

    public HiveNested<A> withNewHive() {
        return new HiveNested(null);
    }

    public HiveNested<A> withNewHiveLike(HiveConfigSpec item) {
        return new HiveNested(item);
    }

    public HiveNested<A> editHive() {
        return this.withNewHiveLike(Optional.ofNullable(this.buildHive()).orElse(null));
    }

    public HiveNested<A> editOrNewHive() {
        return this.withNewHiveLike(Optional.ofNullable(this.buildHive()).orElse(new HiveConfigSpecBuilder().build()));
    }

    public HiveNested<A> editOrNewHiveLike(HiveConfigSpec item) {
        return this.withNewHiveLike(Optional.ofNullable(this.buildHive()).orElse(item));
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public A withImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
        return (A)((Object)this);
    }

    public boolean hasImagePullSecret() {
        return this.imagePullSecret != null;
    }

    public IngressSpec buildIngress() {
        return this.ingress != null ? this.ingress.build() : null;
    }

    public A withIngress(IngressSpec ingress) {
        this._visitables.remove((Object)"ingress");
        if (ingress != null) {
            this.ingress = new IngressSpecBuilder(ingress);
            this._visitables.get((Object)"ingress").add(this.ingress);
        } else {
            this.ingress = null;
            this._visitables.get((Object)"ingress").remove((Object)this.ingress);
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null;
    }

    public IngressNested<A> withNewIngress() {
        return new IngressNested(null);
    }

    public IngressNested<A> withNewIngressLike(IngressSpec item) {
        return new IngressNested(item);
    }

    public IngressNested<A> editIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(null));
    }

    public IngressNested<A> editOrNewIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(new IngressSpecBuilder().build()));
    }

    public IngressNested<A> editOrNewIngressLike(IngressSpec item) {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(item));
    }

    public String getLocalClusterName() {
        return this.localClusterName;
    }

    public A withLocalClusterName(String localClusterName) {
        this.localClusterName = localClusterName;
        return (A)((Object)this);
    }

    public boolean hasLocalClusterName() {
        return this.localClusterName != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public Overrides buildOverrides() {
        return this.overrides != null ? this.overrides.build() : null;
    }

    public A withOverrides(Overrides overrides) {
        this._visitables.remove((Object)"overrides");
        if (overrides != null) {
            this.overrides = new OverridesBuilder(overrides);
            this._visitables.get((Object)"overrides").add(this.overrides);
        } else {
            this.overrides = null;
            this._visitables.get((Object)"overrides").remove((Object)this.overrides);
        }
        return (A)((Object)this);
    }

    public boolean hasOverrides() {
        return this.overrides != null;
    }

    public OverridesNested<A> withNewOverrides() {
        return new OverridesNested(null);
    }

    public OverridesNested<A> withNewOverridesLike(Overrides item) {
        return new OverridesNested(item);
    }

    public OverridesNested<A> editOverrides() {
        return this.withNewOverridesLike(Optional.ofNullable(this.buildOverrides()).orElse(null));
    }

    public OverridesNested<A> editOrNewOverrides() {
        return this.withNewOverridesLike(Optional.ofNullable(this.buildOverrides()).orElse(new OverridesBuilder().build()));
    }

    public OverridesNested<A> editOrNewOverridesLike(Overrides item) {
        return this.withNewOverridesLike(Optional.ofNullable(this.buildOverrides()).orElse(item));
    }

    public Boolean getSeparateCertificateManagement() {
        return this.separateCertificateManagement;
    }

    public A withSeparateCertificateManagement(Boolean separateCertificateManagement) {
        this.separateCertificateManagement = separateCertificateManagement;
        return (A)((Object)this);
    }

    public boolean hasSeparateCertificateManagement() {
        return this.separateCertificateManagement != null;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiClusterHubSpecFluent that = (MultiClusterHubSpecFluent)((Object)o);
        if (!Objects.equals(this.availabilityConfig, that.availabilityConfig)) {
            return false;
        }
        if (!Objects.equals(this.customCAConfigmap, that.customCAConfigmap)) {
            return false;
        }
        if (!Objects.equals(this.disableHubSelfManagement, that.disableHubSelfManagement)) {
            return false;
        }
        if (!Objects.equals(this.disableUpdateClusterImageSets, that.disableUpdateClusterImageSets)) {
            return false;
        }
        if (!Objects.equals(this.enableClusterBackup, that.enableClusterBackup)) {
            return false;
        }
        if (!Objects.equals(this.enableClusterProxyAddon, that.enableClusterProxyAddon)) {
            return false;
        }
        if (!Objects.equals((Object)this.hive, (Object)that.hive)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecret, that.imagePullSecret)) {
            return false;
        }
        if (!Objects.equals((Object)this.ingress, (Object)that.ingress)) {
            return false;
        }
        if (!Objects.equals(this.localClusterName, that.localClusterName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.overrides, (Object)that.overrides)) {
            return false;
        }
        if (!Objects.equals(this.separateCertificateManagement, that.separateCertificateManagement)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.availabilityConfig, this.customCAConfigmap, this.disableHubSelfManagement, this.disableUpdateClusterImageSets, this.enableClusterBackup, this.enableClusterProxyAddon, this.hive, this.imagePullSecret, this.ingress, this.localClusterName, this.nodeSelector, this.overrides, this.separateCertificateManagement, this.tolerations, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityConfig != null) {
            sb.append("availabilityConfig:");
            sb.append(this.availabilityConfig + ",");
        }
        if (this.customCAConfigmap != null) {
            sb.append("customCAConfigmap:");
            sb.append(this.customCAConfigmap + ",");
        }
        if (this.disableHubSelfManagement != null) {
            sb.append("disableHubSelfManagement:");
            sb.append(this.disableHubSelfManagement + ",");
        }
        if (this.disableUpdateClusterImageSets != null) {
            sb.append("disableUpdateClusterImageSets:");
            sb.append(this.disableUpdateClusterImageSets + ",");
        }
        if (this.enableClusterBackup != null) {
            sb.append("enableClusterBackup:");
            sb.append(this.enableClusterBackup + ",");
        }
        if (this.enableClusterProxyAddon != null) {
            sb.append("enableClusterProxyAddon:");
            sb.append(this.enableClusterProxyAddon + ",");
        }
        if (this.hive != null) {
            sb.append("hive:");
            sb.append(String.valueOf((Object)this.hive) + ",");
        }
        if (this.imagePullSecret != null) {
            sb.append("imagePullSecret:");
            sb.append(this.imagePullSecret + ",");
        }
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append(String.valueOf((Object)this.ingress) + ",");
        }
        if (this.localClusterName != null) {
            sb.append("localClusterName:");
            sb.append(this.localClusterName + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(String.valueOf(this.nodeSelector) + ",");
        }
        if (this.overrides != null) {
            sb.append("overrides:");
            sb.append(String.valueOf((Object)this.overrides) + ",");
        }
        if (this.separateCertificateManagement != null) {
            sb.append("separateCertificateManagement:");
            sb.append(this.separateCertificateManagement + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(String.valueOf(this.tolerations) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisableHubSelfManagement() {
        return this.withDisableHubSelfManagement(true);
    }

    public A withDisableUpdateClusterImageSets() {
        return this.withDisableUpdateClusterImageSets(true);
    }

    public A withEnableClusterBackup() {
        return this.withEnableClusterBackup(true);
    }

    public A withEnableClusterProxyAddon() {
        return this.withEnableClusterProxyAddon(true);
    }

    public A withSeparateCertificateManagement() {
        return this.withSeparateCertificateManagement(true);
    }

    public class OverridesNested<N>
    extends OverridesFluent<OverridesNested<N>>
    implements Nested<N> {
        OverridesBuilder builder;

        OverridesNested(Overrides item) {
            this.builder = new OverridesBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterHubSpecFluent.this.withOverrides(this.builder.build());
        }

        public N endOverrides() {
            return this.and();
        }
    }

    public class IngressNested<N>
    extends IngressSpecFluent<IngressNested<N>>
    implements Nested<N> {
        IngressSpecBuilder builder;

        IngressNested(IngressSpec item) {
            this.builder = new IngressSpecBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterHubSpecFluent.this.withIngress(this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }

    public class HiveNested<N>
    extends HiveConfigSpecFluent<HiveNested<N>>
    implements Nested<N> {
        HiveConfigSpecBuilder builder;

        HiveNested(HiveConfigSpec item) {
            this.builder = new HiveConfigSpecBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterHubSpecFluent.this.withHive(this.builder.build());
        }

        public N endHive() {
            return this.and();
        }
    }
}

