/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.BootstrapKubeConfigs;
import io.fabric8.openclustermanagement.api.model.operator.v1.BootstrapKubeConfigsBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.BootstrapKubeConfigsFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGateBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGateFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationConfiguration;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriver;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriverBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriverFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RegistrationConfigurationFluent<A extends RegistrationConfigurationFluent<A>>
extends BaseFluent<A> {
    private BootstrapKubeConfigsBuilder bootstrapKubeConfigs;
    private Integer clientCertExpirationSeconds;
    private Map<String, String> clusterAnnotations;
    private ArrayList<FeatureGateBuilder> featureGates = new ArrayList();
    private Integer kubeAPIBurst;
    private Integer kubeAPIQPS;
    private RegistrationDriverBuilder registrationDriver;
    private Map<String, Object> additionalProperties;

    public RegistrationConfigurationFluent() {
    }

    public RegistrationConfigurationFluent(RegistrationConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RegistrationConfiguration instance) {
        RegistrationConfiguration registrationConfiguration = instance = instance != null ? instance : new RegistrationConfiguration();
        if (instance != null) {
            this.withBootstrapKubeConfigs(instance.getBootstrapKubeConfigs());
            this.withClientCertExpirationSeconds(instance.getClientCertExpirationSeconds());
            this.withClusterAnnotations(instance.getClusterAnnotations());
            this.withFeatureGates(instance.getFeatureGates());
            this.withKubeAPIBurst(instance.getKubeAPIBurst());
            this.withKubeAPIQPS(instance.getKubeAPIQPS());
            this.withRegistrationDriver(instance.getRegistrationDriver());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BootstrapKubeConfigs buildBootstrapKubeConfigs() {
        return this.bootstrapKubeConfigs != null ? this.bootstrapKubeConfigs.build() : null;
    }

    public A withBootstrapKubeConfigs(BootstrapKubeConfigs bootstrapKubeConfigs) {
        this._visitables.remove((Object)"bootstrapKubeConfigs");
        if (bootstrapKubeConfigs != null) {
            this.bootstrapKubeConfigs = new BootstrapKubeConfigsBuilder(bootstrapKubeConfigs);
            this._visitables.get((Object)"bootstrapKubeConfigs").add(this.bootstrapKubeConfigs);
        } else {
            this.bootstrapKubeConfigs = null;
            this._visitables.get((Object)"bootstrapKubeConfigs").remove((Object)this.bootstrapKubeConfigs);
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrapKubeConfigs() {
        return this.bootstrapKubeConfigs != null;
    }

    public BootstrapKubeConfigsNested<A> withNewBootstrapKubeConfigs() {
        return new BootstrapKubeConfigsNested(null);
    }

    public BootstrapKubeConfigsNested<A> withNewBootstrapKubeConfigsLike(BootstrapKubeConfigs item) {
        return new BootstrapKubeConfigsNested(item);
    }

    public BootstrapKubeConfigsNested<A> editBootstrapKubeConfigs() {
        return this.withNewBootstrapKubeConfigsLike(Optional.ofNullable(this.buildBootstrapKubeConfigs()).orElse(null));
    }

    public BootstrapKubeConfigsNested<A> editOrNewBootstrapKubeConfigs() {
        return this.withNewBootstrapKubeConfigsLike(Optional.ofNullable(this.buildBootstrapKubeConfigs()).orElse(new BootstrapKubeConfigsBuilder().build()));
    }

    public BootstrapKubeConfigsNested<A> editOrNewBootstrapKubeConfigsLike(BootstrapKubeConfigs item) {
        return this.withNewBootstrapKubeConfigsLike(Optional.ofNullable(this.buildBootstrapKubeConfigs()).orElse(item));
    }

    public Integer getClientCertExpirationSeconds() {
        return this.clientCertExpirationSeconds;
    }

    public A withClientCertExpirationSeconds(Integer clientCertExpirationSeconds) {
        this.clientCertExpirationSeconds = clientCertExpirationSeconds;
        return (A)((Object)this);
    }

    public boolean hasClientCertExpirationSeconds() {
        return this.clientCertExpirationSeconds != null;
    }

    public A addToClusterAnnotations(String key, String value) {
        if (this.clusterAnnotations == null && key != null && value != null) {
            this.clusterAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.clusterAnnotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToClusterAnnotations(Map<String, String> map) {
        if (this.clusterAnnotations == null && map != null) {
            this.clusterAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.clusterAnnotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterAnnotations(String key) {
        if (this.clusterAnnotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.clusterAnnotations != null) {
            this.clusterAnnotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterAnnotations(Map<String, String> map) {
        if (this.clusterAnnotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.clusterAnnotations == null) continue;
                this.clusterAnnotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getClusterAnnotations() {
        return this.clusterAnnotations;
    }

    public <K, V> A withClusterAnnotations(Map<String, String> clusterAnnotations) {
        this.clusterAnnotations = clusterAnnotations == null ? null : new LinkedHashMap<String, String>(clusterAnnotations);
        return (A)((Object)this);
    }

    public boolean hasClusterAnnotations() {
        return this.clusterAnnotations != null;
    }

    public A addToFeatureGates(int index, FeatureGate item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateBuilder builder = new FeatureGateBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFeatureGates(int index, FeatureGate item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateBuilder builder = new FeatureGateBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFeatureGates(FeatureGate ... items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFeatureGates(Collection<FeatureGate> items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFeatureGates(FeatureGate ... items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFeatureGates(Collection<FeatureGate> items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFeatureGates(Predicate<FeatureGateBuilder> predicate) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        Iterator<FeatureGateBuilder> each = this.featureGates.iterator();
        List visitables = this._visitables.get((Object)"featureGates");
        while (each.hasNext()) {
            FeatureGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<FeatureGate> buildFeatureGates() {
        return this.featureGates != null ? RegistrationConfigurationFluent.build(this.featureGates) : null;
    }

    public FeatureGate buildFeatureGate(int index) {
        return this.featureGates.get(index).build();
    }

    public FeatureGate buildFirstFeatureGate() {
        return this.featureGates.get(0).build();
    }

    public FeatureGate buildLastFeatureGate() {
        return this.featureGates.get(this.featureGates.size() - 1).build();
    }

    public FeatureGate buildMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        for (FeatureGateBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        for (FeatureGateBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFeatureGates(List<FeatureGate> featureGates) {
        if (this.featureGates != null) {
            this._visitables.get((Object)"featureGates").clear();
        }
        if (featureGates != null) {
            this.featureGates = new ArrayList();
            for (FeatureGate item : featureGates) {
                this.addToFeatureGates(item);
            }
        } else {
            this.featureGates = null;
        }
        return (A)((Object)this);
    }

    public A withFeatureGates(FeatureGate ... featureGates) {
        if (this.featureGates != null) {
            this.featureGates.clear();
            this._visitables.remove((Object)"featureGates");
        }
        if (featureGates != null) {
            for (FeatureGate item : featureGates) {
                this.addToFeatureGates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFeatureGates() {
        return this.featureGates != null && !this.featureGates.isEmpty();
    }

    public A addNewFeatureGate(String feature, String mode) {
        return this.addToFeatureGates(new FeatureGate(feature, mode));
    }

    public FeatureGatesNested<A> addNewFeatureGate() {
        return new FeatureGatesNested(-1, null);
    }

    public FeatureGatesNested<A> addNewFeatureGateLike(FeatureGate item) {
        return new FeatureGatesNested(-1, item);
    }

    public FeatureGatesNested<A> setNewFeatureGateLike(int index, FeatureGate item) {
        return new FeatureGatesNested(index, item);
    }

    public FeatureGatesNested<A> editFeatureGate(int index) {
        if (this.featureGates.size() <= index) {
            throw new RuntimeException("Can't edit featureGates. Index exceeds size.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editFirstFeatureGate() {
        if (this.featureGates.size() == 0) {
            throw new RuntimeException("Can't edit first featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(0, this.buildFeatureGate(0));
    }

    public FeatureGatesNested<A> editLastFeatureGate() {
        int index = this.featureGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.featureGates.size(); ++i) {
            if (!predicate.test(this.featureGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching featureGates. No match found.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public Integer getKubeAPIBurst() {
        return this.kubeAPIBurst;
    }

    public A withKubeAPIBurst(Integer kubeAPIBurst) {
        this.kubeAPIBurst = kubeAPIBurst;
        return (A)((Object)this);
    }

    public boolean hasKubeAPIBurst() {
        return this.kubeAPIBurst != null;
    }

    public Integer getKubeAPIQPS() {
        return this.kubeAPIQPS;
    }

    public A withKubeAPIQPS(Integer kubeAPIQPS) {
        this.kubeAPIQPS = kubeAPIQPS;
        return (A)((Object)this);
    }

    public boolean hasKubeAPIQPS() {
        return this.kubeAPIQPS != null;
    }

    public RegistrationDriver buildRegistrationDriver() {
        return this.registrationDriver != null ? this.registrationDriver.build() : null;
    }

    public A withRegistrationDriver(RegistrationDriver registrationDriver) {
        this._visitables.remove((Object)"registrationDriver");
        if (registrationDriver != null) {
            this.registrationDriver = new RegistrationDriverBuilder(registrationDriver);
            this._visitables.get((Object)"registrationDriver").add(this.registrationDriver);
        } else {
            this.registrationDriver = null;
            this._visitables.get((Object)"registrationDriver").remove((Object)this.registrationDriver);
        }
        return (A)((Object)this);
    }

    public boolean hasRegistrationDriver() {
        return this.registrationDriver != null;
    }

    public RegistrationDriverNested<A> withNewRegistrationDriver() {
        return new RegistrationDriverNested(null);
    }

    public RegistrationDriverNested<A> withNewRegistrationDriverLike(RegistrationDriver item) {
        return new RegistrationDriverNested(item);
    }

    public RegistrationDriverNested<A> editRegistrationDriver() {
        return this.withNewRegistrationDriverLike(Optional.ofNullable(this.buildRegistrationDriver()).orElse(null));
    }

    public RegistrationDriverNested<A> editOrNewRegistrationDriver() {
        return this.withNewRegistrationDriverLike(Optional.ofNullable(this.buildRegistrationDriver()).orElse(new RegistrationDriverBuilder().build()));
    }

    public RegistrationDriverNested<A> editOrNewRegistrationDriverLike(RegistrationDriver item) {
        return this.withNewRegistrationDriverLike(Optional.ofNullable(this.buildRegistrationDriver()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationConfigurationFluent that = (RegistrationConfigurationFluent)((Object)o);
        if (!Objects.equals((Object)this.bootstrapKubeConfigs, (Object)that.bootstrapKubeConfigs)) {
            return false;
        }
        if (!Objects.equals(this.clientCertExpirationSeconds, that.clientCertExpirationSeconds)) {
            return false;
        }
        if (!Objects.equals(this.clusterAnnotations, that.clusterAnnotations)) {
            return false;
        }
        if (!Objects.equals(this.featureGates, that.featureGates)) {
            return false;
        }
        if (!Objects.equals(this.kubeAPIBurst, that.kubeAPIBurst)) {
            return false;
        }
        if (!Objects.equals(this.kubeAPIQPS, that.kubeAPIQPS)) {
            return false;
        }
        if (!Objects.equals((Object)this.registrationDriver, (Object)that.registrationDriver)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootstrapKubeConfigs, this.clientCertExpirationSeconds, this.clusterAnnotations, this.featureGates, this.kubeAPIBurst, this.kubeAPIQPS, this.registrationDriver, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrapKubeConfigs != null) {
            sb.append("bootstrapKubeConfigs:");
            sb.append(String.valueOf((Object)this.bootstrapKubeConfigs) + ",");
        }
        if (this.clientCertExpirationSeconds != null) {
            sb.append("clientCertExpirationSeconds:");
            sb.append(this.clientCertExpirationSeconds + ",");
        }
        if (this.clusterAnnotations != null && !this.clusterAnnotations.isEmpty()) {
            sb.append("clusterAnnotations:");
            sb.append(String.valueOf(this.clusterAnnotations) + ",");
        }
        if (this.featureGates != null && !this.featureGates.isEmpty()) {
            sb.append("featureGates:");
            sb.append(String.valueOf(this.featureGates) + ",");
        }
        if (this.kubeAPIBurst != null) {
            sb.append("kubeAPIBurst:");
            sb.append(this.kubeAPIBurst + ",");
        }
        if (this.kubeAPIQPS != null) {
            sb.append("kubeAPIQPS:");
            sb.append(this.kubeAPIQPS + ",");
        }
        if (this.registrationDriver != null) {
            sb.append("registrationDriver:");
            sb.append(String.valueOf((Object)this.registrationDriver) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RegistrationDriverNested<N>
    extends RegistrationDriverFluent<RegistrationDriverNested<N>>
    implements Nested<N> {
        RegistrationDriverBuilder builder;

        RegistrationDriverNested(RegistrationDriver item) {
            this.builder = new RegistrationDriverBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationConfigurationFluent.this.withRegistrationDriver(this.builder.build());
        }

        public N endRegistrationDriver() {
            return this.and();
        }
    }

    public class FeatureGatesNested<N>
    extends FeatureGateFluent<FeatureGatesNested<N>>
    implements Nested<N> {
        FeatureGateBuilder builder;
        int index;

        FeatureGatesNested(int index, FeatureGate item) {
            this.index = index;
            this.builder = new FeatureGateBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationConfigurationFluent.this.setToFeatureGates(this.index, this.builder.build());
        }

        public N endFeatureGate() {
            return this.and();
        }
    }

    public class BootstrapKubeConfigsNested<N>
    extends BootstrapKubeConfigsFluent<BootstrapKubeConfigsNested<N>>
    implements Nested<N> {
        BootstrapKubeConfigsBuilder builder;

        BootstrapKubeConfigsNested(BootstrapKubeConfigs item) {
            this.builder = new BootstrapKubeConfigsBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationConfigurationFluent.this.withBootstrapKubeConfigs(this.builder.build());
        }

        public N endBootstrapKubeConfigs() {
            return this.and();
        }
    }
}

