/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.AwsIrsaConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.AwsIrsaConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.AwsIrsaConfigFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.CSRConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.CSRConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.CSRConfigFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriverHub;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RegistrationDriverHubFluent<A extends RegistrationDriverHubFluent<A>>
extends BaseFluent<A> {
    private String authType;
    private AwsIrsaConfigBuilder awsisra;
    private CSRConfigBuilder csr;
    private Map<String, Object> additionalProperties;

    public RegistrationDriverHubFluent() {
    }

    public RegistrationDriverHubFluent(RegistrationDriverHub instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RegistrationDriverHub instance) {
        RegistrationDriverHub registrationDriverHub = instance = instance != null ? instance : new RegistrationDriverHub();
        if (instance != null) {
            this.withAuthType(instance.getAuthType());
            this.withAwsisra(instance.getAwsisra());
            this.withCsr(instance.getCsr());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public A withAuthType(String authType) {
        this.authType = authType;
        return (A)((Object)this);
    }

    public boolean hasAuthType() {
        return this.authType != null;
    }

    public AwsIrsaConfig buildAwsisra() {
        return this.awsisra != null ? this.awsisra.build() : null;
    }

    public A withAwsisra(AwsIrsaConfig awsisra) {
        this._visitables.remove((Object)"awsisra");
        if (awsisra != null) {
            this.awsisra = new AwsIrsaConfigBuilder(awsisra);
            this._visitables.get((Object)"awsisra").add(this.awsisra);
        } else {
            this.awsisra = null;
            this._visitables.get((Object)"awsisra").remove((Object)this.awsisra);
        }
        return (A)((Object)this);
    }

    public boolean hasAwsisra() {
        return this.awsisra != null;
    }

    public AwsisraNested<A> withNewAwsisra() {
        return new AwsisraNested(null);
    }

    public AwsisraNested<A> withNewAwsisraLike(AwsIrsaConfig item) {
        return new AwsisraNested(item);
    }

    public AwsisraNested<A> editAwsisra() {
        return this.withNewAwsisraLike(Optional.ofNullable(this.buildAwsisra()).orElse(null));
    }

    public AwsisraNested<A> editOrNewAwsisra() {
        return this.withNewAwsisraLike(Optional.ofNullable(this.buildAwsisra()).orElse(new AwsIrsaConfigBuilder().build()));
    }

    public AwsisraNested<A> editOrNewAwsisraLike(AwsIrsaConfig item) {
        return this.withNewAwsisraLike(Optional.ofNullable(this.buildAwsisra()).orElse(item));
    }

    public CSRConfig buildCsr() {
        return this.csr != null ? this.csr.build() : null;
    }

    public A withCsr(CSRConfig csr) {
        this._visitables.remove((Object)"csr");
        if (csr != null) {
            this.csr = new CSRConfigBuilder(csr);
            this._visitables.get((Object)"csr").add(this.csr);
        } else {
            this.csr = null;
            this._visitables.get((Object)"csr").remove((Object)this.csr);
        }
        return (A)((Object)this);
    }

    public boolean hasCsr() {
        return this.csr != null;
    }

    public CsrNested<A> withNewCsr() {
        return new CsrNested(null);
    }

    public CsrNested<A> withNewCsrLike(CSRConfig item) {
        return new CsrNested(item);
    }

    public CsrNested<A> editCsr() {
        return this.withNewCsrLike(Optional.ofNullable(this.buildCsr()).orElse(null));
    }

    public CsrNested<A> editOrNewCsr() {
        return this.withNewCsrLike(Optional.ofNullable(this.buildCsr()).orElse(new CSRConfigBuilder().build()));
    }

    public CsrNested<A> editOrNewCsrLike(CSRConfig item) {
        return this.withNewCsrLike(Optional.ofNullable(this.buildCsr()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationDriverHubFluent that = (RegistrationDriverHubFluent)((Object)o);
        if (!Objects.equals(this.authType, that.authType)) {
            return false;
        }
        if (!Objects.equals((Object)this.awsisra, (Object)that.awsisra)) {
            return false;
        }
        if (!Objects.equals((Object)this.csr, (Object)that.csr)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authType, this.awsisra, this.csr, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authType != null) {
            sb.append("authType:");
            sb.append(this.authType + ",");
        }
        if (this.awsisra != null) {
            sb.append("awsisra:");
            sb.append(String.valueOf((Object)this.awsisra) + ",");
        }
        if (this.csr != null) {
            sb.append("csr:");
            sb.append(String.valueOf((Object)this.csr) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CsrNested<N>
    extends CSRConfigFluent<CsrNested<N>>
    implements Nested<N> {
        CSRConfigBuilder builder;

        CsrNested(CSRConfig item) {
            this.builder = new CSRConfigBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationDriverHubFluent.this.withCsr(this.builder.build());
        }

        public N endCsr() {
            return this.and();
        }
    }

    public class AwsisraNested<N>
    extends AwsIrsaConfigFluent<AwsisraNested<N>>
    implements Nested<N> {
        AwsIrsaConfigBuilder builder;

        AwsisraNested(AwsIrsaConfig item) {
            this.builder = new AwsIrsaConfigBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationDriverHubFluent.this.withAwsisra(this.builder.build());
        }

        public N endAwsisra() {
            return this.and();
        }
    }
}

