/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGateBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGateFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriverHub;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriverHubBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationDriverHubFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.RegistrationHubConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RegistrationHubConfigurationFluent<A extends RegistrationHubConfigurationFluent<A>>
extends BaseFluent<A> {
    private List<String> autoApproveUsers = new ArrayList<String>();
    private ArrayList<FeatureGateBuilder> featureGates = new ArrayList();
    private ArrayList<RegistrationDriverHubBuilder> registrationDrivers = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RegistrationHubConfigurationFluent() {
    }

    public RegistrationHubConfigurationFluent(RegistrationHubConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RegistrationHubConfiguration instance) {
        RegistrationHubConfiguration registrationHubConfiguration = instance = instance != null ? instance : new RegistrationHubConfiguration();
        if (instance != null) {
            this.withAutoApproveUsers(instance.getAutoApproveUsers());
            this.withFeatureGates(instance.getFeatureGates());
            this.withRegistrationDrivers(instance.getRegistrationDrivers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAutoApproveUsers(int index, String item) {
        if (this.autoApproveUsers == null) {
            this.autoApproveUsers = new ArrayList<String>();
        }
        this.autoApproveUsers.add(index, item);
        return (A)((Object)this);
    }

    public A setToAutoApproveUsers(int index, String item) {
        if (this.autoApproveUsers == null) {
            this.autoApproveUsers = new ArrayList<String>();
        }
        this.autoApproveUsers.set(index, item);
        return (A)((Object)this);
    }

    public A addToAutoApproveUsers(String ... items) {
        if (this.autoApproveUsers == null) {
            this.autoApproveUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoApproveUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAutoApproveUsers(Collection<String> items) {
        if (this.autoApproveUsers == null) {
            this.autoApproveUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoApproveUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAutoApproveUsers(String ... items) {
        if (this.autoApproveUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoApproveUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAutoApproveUsers(Collection<String> items) {
        if (this.autoApproveUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoApproveUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAutoApproveUsers() {
        return this.autoApproveUsers;
    }

    public String getAutoApproveUser(int index) {
        return this.autoApproveUsers.get(index);
    }

    public String getFirstAutoApproveUser() {
        return this.autoApproveUsers.get(0);
    }

    public String getLastAutoApproveUser() {
        return this.autoApproveUsers.get(this.autoApproveUsers.size() - 1);
    }

    public String getMatchingAutoApproveUser(Predicate<String> predicate) {
        for (String item : this.autoApproveUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAutoApproveUser(Predicate<String> predicate) {
        for (String item : this.autoApproveUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAutoApproveUsers(List<String> autoApproveUsers) {
        if (autoApproveUsers != null) {
            this.autoApproveUsers = new ArrayList<String>();
            for (String item : autoApproveUsers) {
                this.addToAutoApproveUsers(item);
            }
        } else {
            this.autoApproveUsers = null;
        }
        return (A)((Object)this);
    }

    public A withAutoApproveUsers(String ... autoApproveUsers) {
        if (this.autoApproveUsers != null) {
            this.autoApproveUsers.clear();
            this._visitables.remove((Object)"autoApproveUsers");
        }
        if (autoApproveUsers != null) {
            for (String item : autoApproveUsers) {
                this.addToAutoApproveUsers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAutoApproveUsers() {
        return this.autoApproveUsers != null && !this.autoApproveUsers.isEmpty();
    }

    public A addToFeatureGates(int index, FeatureGate item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateBuilder builder = new FeatureGateBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFeatureGates(int index, FeatureGate item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateBuilder builder = new FeatureGateBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFeatureGates(FeatureGate ... items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFeatureGates(Collection<FeatureGate> items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFeatureGates(FeatureGate ... items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFeatureGates(Collection<FeatureGate> items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFeatureGates(Predicate<FeatureGateBuilder> predicate) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        Iterator<FeatureGateBuilder> each = this.featureGates.iterator();
        List visitables = this._visitables.get((Object)"featureGates");
        while (each.hasNext()) {
            FeatureGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<FeatureGate> buildFeatureGates() {
        return this.featureGates != null ? RegistrationHubConfigurationFluent.build(this.featureGates) : null;
    }

    public FeatureGate buildFeatureGate(int index) {
        return this.featureGates.get(index).build();
    }

    public FeatureGate buildFirstFeatureGate() {
        return this.featureGates.get(0).build();
    }

    public FeatureGate buildLastFeatureGate() {
        return this.featureGates.get(this.featureGates.size() - 1).build();
    }

    public FeatureGate buildMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        for (FeatureGateBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        for (FeatureGateBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFeatureGates(List<FeatureGate> featureGates) {
        if (this.featureGates != null) {
            this._visitables.get((Object)"featureGates").clear();
        }
        if (featureGates != null) {
            this.featureGates = new ArrayList();
            for (FeatureGate item : featureGates) {
                this.addToFeatureGates(item);
            }
        } else {
            this.featureGates = null;
        }
        return (A)((Object)this);
    }

    public A withFeatureGates(FeatureGate ... featureGates) {
        if (this.featureGates != null) {
            this.featureGates.clear();
            this._visitables.remove((Object)"featureGates");
        }
        if (featureGates != null) {
            for (FeatureGate item : featureGates) {
                this.addToFeatureGates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFeatureGates() {
        return this.featureGates != null && !this.featureGates.isEmpty();
    }

    public A addNewFeatureGate(String feature, String mode) {
        return this.addToFeatureGates(new FeatureGate(feature, mode));
    }

    public FeatureGatesNested<A> addNewFeatureGate() {
        return new FeatureGatesNested(-1, null);
    }

    public FeatureGatesNested<A> addNewFeatureGateLike(FeatureGate item) {
        return new FeatureGatesNested(-1, item);
    }

    public FeatureGatesNested<A> setNewFeatureGateLike(int index, FeatureGate item) {
        return new FeatureGatesNested(index, item);
    }

    public FeatureGatesNested<A> editFeatureGate(int index) {
        if (this.featureGates.size() <= index) {
            throw new RuntimeException("Can't edit featureGates. Index exceeds size.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editFirstFeatureGate() {
        if (this.featureGates.size() == 0) {
            throw new RuntimeException("Can't edit first featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(0, this.buildFeatureGate(0));
    }

    public FeatureGatesNested<A> editLastFeatureGate() {
        int index = this.featureGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.featureGates.size(); ++i) {
            if (!predicate.test(this.featureGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching featureGates. No match found.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public A addToRegistrationDrivers(int index, RegistrationDriverHub item) {
        if (this.registrationDrivers == null) {
            this.registrationDrivers = new ArrayList();
        }
        RegistrationDriverHubBuilder builder = new RegistrationDriverHubBuilder(item);
        if (index < 0 || index >= this.registrationDrivers.size()) {
            this._visitables.get((Object)"registrationDrivers").add(builder);
            this.registrationDrivers.add(builder);
        } else {
            this._visitables.get((Object)"registrationDrivers").add(builder);
            this.registrationDrivers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRegistrationDrivers(int index, RegistrationDriverHub item) {
        if (this.registrationDrivers == null) {
            this.registrationDrivers = new ArrayList();
        }
        RegistrationDriverHubBuilder builder = new RegistrationDriverHubBuilder(item);
        if (index < 0 || index >= this.registrationDrivers.size()) {
            this._visitables.get((Object)"registrationDrivers").add(builder);
            this.registrationDrivers.add(builder);
        } else {
            this._visitables.get((Object)"registrationDrivers").add(builder);
            this.registrationDrivers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRegistrationDrivers(RegistrationDriverHub ... items) {
        if (this.registrationDrivers == null) {
            this.registrationDrivers = new ArrayList();
        }
        for (RegistrationDriverHub item : items) {
            RegistrationDriverHubBuilder builder = new RegistrationDriverHubBuilder(item);
            this._visitables.get((Object)"registrationDrivers").add(builder);
            this.registrationDrivers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRegistrationDrivers(Collection<RegistrationDriverHub> items) {
        if (this.registrationDrivers == null) {
            this.registrationDrivers = new ArrayList();
        }
        for (RegistrationDriverHub item : items) {
            RegistrationDriverHubBuilder builder = new RegistrationDriverHubBuilder(item);
            this._visitables.get((Object)"registrationDrivers").add(builder);
            this.registrationDrivers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRegistrationDrivers(RegistrationDriverHub ... items) {
        if (this.registrationDrivers == null) {
            return (A)((Object)this);
        }
        for (RegistrationDriverHub item : items) {
            RegistrationDriverHubBuilder builder = new RegistrationDriverHubBuilder(item);
            this._visitables.get((Object)"registrationDrivers").remove((Object)builder);
            this.registrationDrivers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRegistrationDrivers(Collection<RegistrationDriverHub> items) {
        if (this.registrationDrivers == null) {
            return (A)((Object)this);
        }
        for (RegistrationDriverHub item : items) {
            RegistrationDriverHubBuilder builder = new RegistrationDriverHubBuilder(item);
            this._visitables.get((Object)"registrationDrivers").remove((Object)builder);
            this.registrationDrivers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRegistrationDrivers(Predicate<RegistrationDriverHubBuilder> predicate) {
        if (this.registrationDrivers == null) {
            return (A)((Object)this);
        }
        Iterator<RegistrationDriverHubBuilder> each = this.registrationDrivers.iterator();
        List visitables = this._visitables.get((Object)"registrationDrivers");
        while (each.hasNext()) {
            RegistrationDriverHubBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RegistrationDriverHub> buildRegistrationDrivers() {
        return this.registrationDrivers != null ? RegistrationHubConfigurationFluent.build(this.registrationDrivers) : null;
    }

    public RegistrationDriverHub buildRegistrationDriver(int index) {
        return this.registrationDrivers.get(index).build();
    }

    public RegistrationDriverHub buildFirstRegistrationDriver() {
        return this.registrationDrivers.get(0).build();
    }

    public RegistrationDriverHub buildLastRegistrationDriver() {
        return this.registrationDrivers.get(this.registrationDrivers.size() - 1).build();
    }

    public RegistrationDriverHub buildMatchingRegistrationDriver(Predicate<RegistrationDriverHubBuilder> predicate) {
        for (RegistrationDriverHubBuilder item : this.registrationDrivers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRegistrationDriver(Predicate<RegistrationDriverHubBuilder> predicate) {
        for (RegistrationDriverHubBuilder item : this.registrationDrivers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRegistrationDrivers(List<RegistrationDriverHub> registrationDrivers) {
        if (this.registrationDrivers != null) {
            this._visitables.get((Object)"registrationDrivers").clear();
        }
        if (registrationDrivers != null) {
            this.registrationDrivers = new ArrayList();
            for (RegistrationDriverHub item : registrationDrivers) {
                this.addToRegistrationDrivers(item);
            }
        } else {
            this.registrationDrivers = null;
        }
        return (A)((Object)this);
    }

    public A withRegistrationDrivers(RegistrationDriverHub ... registrationDrivers) {
        if (this.registrationDrivers != null) {
            this.registrationDrivers.clear();
            this._visitables.remove((Object)"registrationDrivers");
        }
        if (registrationDrivers != null) {
            for (RegistrationDriverHub item : registrationDrivers) {
                this.addToRegistrationDrivers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRegistrationDrivers() {
        return this.registrationDrivers != null && !this.registrationDrivers.isEmpty();
    }

    public RegistrationDriversNested<A> addNewRegistrationDriver() {
        return new RegistrationDriversNested(-1, null);
    }

    public RegistrationDriversNested<A> addNewRegistrationDriverLike(RegistrationDriverHub item) {
        return new RegistrationDriversNested(-1, item);
    }

    public RegistrationDriversNested<A> setNewRegistrationDriverLike(int index, RegistrationDriverHub item) {
        return new RegistrationDriversNested(index, item);
    }

    public RegistrationDriversNested<A> editRegistrationDriver(int index) {
        if (this.registrationDrivers.size() <= index) {
            throw new RuntimeException("Can't edit registrationDrivers. Index exceeds size.");
        }
        return this.setNewRegistrationDriverLike(index, this.buildRegistrationDriver(index));
    }

    public RegistrationDriversNested<A> editFirstRegistrationDriver() {
        if (this.registrationDrivers.size() == 0) {
            throw new RuntimeException("Can't edit first registrationDrivers. The list is empty.");
        }
        return this.setNewRegistrationDriverLike(0, this.buildRegistrationDriver(0));
    }

    public RegistrationDriversNested<A> editLastRegistrationDriver() {
        int index = this.registrationDrivers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last registrationDrivers. The list is empty.");
        }
        return this.setNewRegistrationDriverLike(index, this.buildRegistrationDriver(index));
    }

    public RegistrationDriversNested<A> editMatchingRegistrationDriver(Predicate<RegistrationDriverHubBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.registrationDrivers.size(); ++i) {
            if (!predicate.test(this.registrationDrivers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching registrationDrivers. No match found.");
        }
        return this.setNewRegistrationDriverLike(index, this.buildRegistrationDriver(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationHubConfigurationFluent that = (RegistrationHubConfigurationFluent)((Object)o);
        if (!Objects.equals(this.autoApproveUsers, that.autoApproveUsers)) {
            return false;
        }
        if (!Objects.equals(this.featureGates, that.featureGates)) {
            return false;
        }
        if (!Objects.equals(this.registrationDrivers, that.registrationDrivers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.autoApproveUsers, this.featureGates, this.registrationDrivers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoApproveUsers != null && !this.autoApproveUsers.isEmpty()) {
            sb.append("autoApproveUsers:");
            sb.append(String.valueOf(this.autoApproveUsers) + ",");
        }
        if (this.featureGates != null && !this.featureGates.isEmpty()) {
            sb.append("featureGates:");
            sb.append(String.valueOf(this.featureGates) + ",");
        }
        if (this.registrationDrivers != null && !this.registrationDrivers.isEmpty()) {
            sb.append("registrationDrivers:");
            sb.append(String.valueOf(this.registrationDrivers) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RegistrationDriversNested<N>
    extends RegistrationDriverHubFluent<RegistrationDriversNested<N>>
    implements Nested<N> {
        RegistrationDriverHubBuilder builder;
        int index;

        RegistrationDriversNested(int index, RegistrationDriverHub item) {
            this.index = index;
            this.builder = new RegistrationDriverHubBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationHubConfigurationFluent.this.setToRegistrationDrivers(this.index, this.builder.build());
        }

        public N endRegistrationDriver() {
            return this.and();
        }
    }

    public class FeatureGatesNested<N>
    extends FeatureGateFluent<FeatureGatesNested<N>>
    implements Nested<N> {
        FeatureGateBuilder builder;
        int index;

        FeatureGatesNested(int index, FeatureGate item) {
            this.index = index;
            this.builder = new FeatureGateBuilder(this, item);
        }

        public N and() {
            return (N)RegistrationHubConfigurationFluent.this.setToFeatureGates(this.index, this.builder.build());
        }

        public N endFeatureGate() {
            return this.and();
        }
    }
}

