/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGateBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGateFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.WorkConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class WorkConfigurationFluent<A extends WorkConfigurationFluent<A>>
extends BaseFluent<A> {
    private ArrayList<FeatureGateBuilder> featureGates = new ArrayList();
    private String workDriver;
    private Map<String, Object> additionalProperties;

    public WorkConfigurationFluent() {
    }

    public WorkConfigurationFluent(WorkConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WorkConfiguration instance) {
        WorkConfiguration workConfiguration = instance = instance != null ? instance : new WorkConfiguration();
        if (instance != null) {
            this.withFeatureGates(instance.getFeatureGates());
            this.withWorkDriver(instance.getWorkDriver());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFeatureGates(int index, FeatureGate item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateBuilder builder = new FeatureGateBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFeatureGates(int index, FeatureGate item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateBuilder builder = new FeatureGateBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFeatureGates(FeatureGate ... items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFeatureGates(Collection<FeatureGate> items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFeatureGates(FeatureGate ... items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFeatureGates(Collection<FeatureGate> items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGate item : items) {
            FeatureGateBuilder builder = new FeatureGateBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFeatureGates(Predicate<FeatureGateBuilder> predicate) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        Iterator<FeatureGateBuilder> each = this.featureGates.iterator();
        List visitables = this._visitables.get((Object)"featureGates");
        while (each.hasNext()) {
            FeatureGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<FeatureGate> buildFeatureGates() {
        return this.featureGates != null ? WorkConfigurationFluent.build(this.featureGates) : null;
    }

    public FeatureGate buildFeatureGate(int index) {
        return this.featureGates.get(index).build();
    }

    public FeatureGate buildFirstFeatureGate() {
        return this.featureGates.get(0).build();
    }

    public FeatureGate buildLastFeatureGate() {
        return this.featureGates.get(this.featureGates.size() - 1).build();
    }

    public FeatureGate buildMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        for (FeatureGateBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        for (FeatureGateBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFeatureGates(List<FeatureGate> featureGates) {
        if (this.featureGates != null) {
            this._visitables.get((Object)"featureGates").clear();
        }
        if (featureGates != null) {
            this.featureGates = new ArrayList();
            for (FeatureGate item : featureGates) {
                this.addToFeatureGates(item);
            }
        } else {
            this.featureGates = null;
        }
        return (A)((Object)this);
    }

    public A withFeatureGates(FeatureGate ... featureGates) {
        if (this.featureGates != null) {
            this.featureGates.clear();
            this._visitables.remove((Object)"featureGates");
        }
        if (featureGates != null) {
            for (FeatureGate item : featureGates) {
                this.addToFeatureGates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFeatureGates() {
        return this.featureGates != null && !this.featureGates.isEmpty();
    }

    public A addNewFeatureGate(String feature, String mode) {
        return this.addToFeatureGates(new FeatureGate(feature, mode));
    }

    public FeatureGatesNested<A> addNewFeatureGate() {
        return new FeatureGatesNested(-1, null);
    }

    public FeatureGatesNested<A> addNewFeatureGateLike(FeatureGate item) {
        return new FeatureGatesNested(-1, item);
    }

    public FeatureGatesNested<A> setNewFeatureGateLike(int index, FeatureGate item) {
        return new FeatureGatesNested(index, item);
    }

    public FeatureGatesNested<A> editFeatureGate(int index) {
        if (this.featureGates.size() <= index) {
            throw new RuntimeException("Can't edit featureGates. Index exceeds size.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editFirstFeatureGate() {
        if (this.featureGates.size() == 0) {
            throw new RuntimeException("Can't edit first featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(0, this.buildFeatureGate(0));
    }

    public FeatureGatesNested<A> editLastFeatureGate() {
        int index = this.featureGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.featureGates.size(); ++i) {
            if (!predicate.test(this.featureGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching featureGates. No match found.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public String getWorkDriver() {
        return this.workDriver;
    }

    public A withWorkDriver(String workDriver) {
        this.workDriver = workDriver;
        return (A)((Object)this);
    }

    public boolean hasWorkDriver() {
        return this.workDriver != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorkConfigurationFluent that = (WorkConfigurationFluent)((Object)o);
        if (!Objects.equals(this.featureGates, that.featureGates)) {
            return false;
        }
        if (!Objects.equals(this.workDriver, that.workDriver)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.featureGates, this.workDriver, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.featureGates != null && !this.featureGates.isEmpty()) {
            sb.append("featureGates:");
            sb.append(String.valueOf(this.featureGates) + ",");
        }
        if (this.workDriver != null) {
            sb.append("workDriver:");
            sb.append(this.workDriver + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FeatureGatesNested<N>
    extends FeatureGateFluent<FeatureGatesNested<N>>
    implements Nested<N> {
        FeatureGateBuilder builder;
        int index;

        FeatureGatesNested(int index, FeatureGate item) {
            this.index = index;
            this.builder = new FeatureGateBuilder(this, item);
        }

        public N and() {
            return (N)WorkConfigurationFluent.this.setToFeatureGates(this.index, this.builder.build());
        }

        public N endFeatureGate() {
            return this.and();
        }
    }
}

