/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.PolicySetStatus;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.PolicySetStatusPlacement;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.PolicySetStatusPlacementBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.PolicySetStatusPlacementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicySetStatusFluent<A extends PolicySetStatusFluent<A>>
extends BaseFluent<A> {
    private String compliant;
    private ArrayList<PolicySetStatusPlacementBuilder> placement = new ArrayList();
    private String statusMessage;
    private Map<String, Object> additionalProperties;

    public PolicySetStatusFluent() {
    }

    public PolicySetStatusFluent(PolicySetStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PolicySetStatus instance) {
        PolicySetStatus policySetStatus = instance = instance != null ? instance : new PolicySetStatus();
        if (instance != null) {
            this.withCompliant(instance.getCompliant());
            this.withPlacement(instance.getPlacement());
            this.withStatusMessage(instance.getStatusMessage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCompliant() {
        return this.compliant;
    }

    public A withCompliant(String compliant) {
        this.compliant = compliant;
        return (A)((Object)this);
    }

    public boolean hasCompliant() {
        return this.compliant != null;
    }

    public A addToPlacement(int index, PolicySetStatusPlacement item) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        PolicySetStatusPlacementBuilder builder = new PolicySetStatusPlacementBuilder(item);
        if (index < 0 || index >= this.placement.size()) {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        } else {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPlacement(int index, PolicySetStatusPlacement item) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        PolicySetStatusPlacementBuilder builder = new PolicySetStatusPlacementBuilder(item);
        if (index < 0 || index >= this.placement.size()) {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        } else {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPlacement(PolicySetStatusPlacement ... items) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        for (PolicySetStatusPlacement item : items) {
            PolicySetStatusPlacementBuilder builder = new PolicySetStatusPlacementBuilder(item);
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPlacement(Collection<PolicySetStatusPlacement> items) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        for (PolicySetStatusPlacement item : items) {
            PolicySetStatusPlacementBuilder builder = new PolicySetStatusPlacementBuilder(item);
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPlacement(PolicySetStatusPlacement ... items) {
        if (this.placement == null) {
            return (A)((Object)this);
        }
        for (PolicySetStatusPlacement item : items) {
            PolicySetStatusPlacementBuilder builder = new PolicySetStatusPlacementBuilder(item);
            this._visitables.get((Object)"placement").remove((Object)builder);
            this.placement.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPlacement(Collection<PolicySetStatusPlacement> items) {
        if (this.placement == null) {
            return (A)((Object)this);
        }
        for (PolicySetStatusPlacement item : items) {
            PolicySetStatusPlacementBuilder builder = new PolicySetStatusPlacementBuilder(item);
            this._visitables.get((Object)"placement").remove((Object)builder);
            this.placement.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPlacement(Predicate<PolicySetStatusPlacementBuilder> predicate) {
        if (this.placement == null) {
            return (A)((Object)this);
        }
        Iterator<PolicySetStatusPlacementBuilder> each = this.placement.iterator();
        List visitables = this._visitables.get((Object)"placement");
        while (each.hasNext()) {
            PolicySetStatusPlacementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PolicySetStatusPlacement> buildPlacement() {
        return this.placement != null ? PolicySetStatusFluent.build(this.placement) : null;
    }

    public PolicySetStatusPlacement buildPlacement(int index) {
        return this.placement.get(index).build();
    }

    public PolicySetStatusPlacement buildFirstPlacement() {
        return this.placement.get(0).build();
    }

    public PolicySetStatusPlacement buildLastPlacement() {
        return this.placement.get(this.placement.size() - 1).build();
    }

    public PolicySetStatusPlacement buildMatchingPlacement(Predicate<PolicySetStatusPlacementBuilder> predicate) {
        for (PolicySetStatusPlacementBuilder item : this.placement) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPlacement(Predicate<PolicySetStatusPlacementBuilder> predicate) {
        for (PolicySetStatusPlacementBuilder item : this.placement) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlacement(List<PolicySetStatusPlacement> placement) {
        if (this.placement != null) {
            this._visitables.get((Object)"placement").clear();
        }
        if (placement != null) {
            this.placement = new ArrayList();
            for (PolicySetStatusPlacement item : placement) {
                this.addToPlacement(item);
            }
        } else {
            this.placement = null;
        }
        return (A)((Object)this);
    }

    public A withPlacement(PolicySetStatusPlacement ... placement) {
        if (this.placement != null) {
            this.placement.clear();
            this._visitables.remove((Object)"placement");
        }
        if (placement != null) {
            for (PolicySetStatusPlacement item : placement) {
                this.addToPlacement(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPlacement() {
        return this.placement != null && !this.placement.isEmpty();
    }

    public A addNewPlacement(String placement, String placementBinding, String placementRule) {
        return this.addToPlacement(new PolicySetStatusPlacement(placement, placementBinding, placementRule));
    }

    public PlacementNested<A> addNewPlacement() {
        return new PlacementNested(-1, null);
    }

    public PlacementNested<A> addNewPlacementLike(PolicySetStatusPlacement item) {
        return new PlacementNested(-1, item);
    }

    public PlacementNested<A> setNewPlacementLike(int index, PolicySetStatusPlacement item) {
        return new PlacementNested(index, item);
    }

    public PlacementNested<A> editPlacement(int index) {
        if (this.placement.size() <= index) {
            throw new RuntimeException("Can't edit placement. Index exceeds size.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public PlacementNested<A> editFirstPlacement() {
        if (this.placement.size() == 0) {
            throw new RuntimeException("Can't edit first placement. The list is empty.");
        }
        return this.setNewPlacementLike(0, this.buildPlacement(0));
    }

    public PlacementNested<A> editLastPlacement() {
        int index = this.placement.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last placement. The list is empty.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public PlacementNested<A> editMatchingPlacement(Predicate<PolicySetStatusPlacementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.placement.size(); ++i) {
            if (!predicate.test(this.placement.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching placement. No match found.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public A withStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return (A)((Object)this);
    }

    public boolean hasStatusMessage() {
        return this.statusMessage != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicySetStatusFluent that = (PolicySetStatusFluent)((Object)o);
        if (!Objects.equals(this.compliant, that.compliant)) {
            return false;
        }
        if (!Objects.equals(this.placement, that.placement)) {
            return false;
        }
        if (!Objects.equals(this.statusMessage, that.statusMessage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compliant, this.placement, this.statusMessage, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliant != null) {
            sb.append("compliant:");
            sb.append(this.compliant + ",");
        }
        if (this.placement != null && !this.placement.isEmpty()) {
            sb.append("placement:");
            sb.append(String.valueOf(this.placement) + ",");
        }
        if (this.statusMessage != null) {
            sb.append("statusMessage:");
            sb.append(this.statusMessage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlacementNested<N>
    extends PolicySetStatusPlacementFluent<PlacementNested<N>>
    implements Nested<N> {
        PolicySetStatusPlacementBuilder builder;
        int index;

        PlacementNested(int index, PolicySetStatusPlacement item) {
            this.index = index;
            this.builder = new PolicySetStatusPlacementBuilder(this, item);
        }

        public N and() {
            return (N)PolicySetStatusFluent.this.setToPlacement(this.index, this.builder.build());
        }

        public N endPlacement() {
            return this.and();
        }
    }
}

