/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpec;
import io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpecFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpecFluentImpl;
import java.util.Objects;

public class ClusterManagerSpecBuilder
extends ClusterManagerSpecFluentImpl<ClusterManagerSpecBuilder>
implements VisitableBuilder<ClusterManagerSpec, ClusterManagerSpecBuilder> {
    ClusterManagerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterManagerSpecBuilder() {
        this(false);
    }

    public ClusterManagerSpecBuilder(Boolean validationEnabled) {
        this(new ClusterManagerSpec(), validationEnabled);
    }

    public ClusterManagerSpecBuilder(ClusterManagerSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterManagerSpecBuilder(ClusterManagerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterManagerSpec(), validationEnabled);
    }

    public ClusterManagerSpecBuilder(ClusterManagerSpecFluent<?> fluent, ClusterManagerSpec instance) {
        this(fluent, instance, false);
    }

    public ClusterManagerSpecBuilder(ClusterManagerSpecFluent<?> fluent, ClusterManagerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodePlacement(instance.getNodePlacement());
        fluent.withPlacementImagePullSpec(instance.getPlacementImagePullSpec());
        fluent.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
        fluent.withWorkImagePullSpec(instance.getWorkImagePullSpec());
        this.validationEnabled = validationEnabled;
    }

    public ClusterManagerSpecBuilder(ClusterManagerSpec instance) {
        this(instance, (Boolean)false);
    }

    public ClusterManagerSpecBuilder(ClusterManagerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodePlacement(instance.getNodePlacement());
        this.withPlacementImagePullSpec(instance.getPlacementImagePullSpec());
        this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
        this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
        this.validationEnabled = validationEnabled;
    }

    public ClusterManagerSpec build() {
        ClusterManagerSpec buildable = new ClusterManagerSpec(this.fluent.getNodePlacement(), this.fluent.getPlacementImagePullSpec(), this.fluent.getRegistrationImagePullSpec(), this.fluent.getWorkImagePullSpec());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterManagerSpecBuilder that = (ClusterManagerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

