/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.ArgoServerSpec;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.ArgoServerSpecBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.ArgoServerSpecFluent;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.GitOpsClusterSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GitOpsClusterSpecFluent<A extends GitOpsClusterSpecFluent<A>>
extends BaseFluent<A> {
    private ArgoServerSpecBuilder argoServer;
    private ObjectReferenceBuilder placementRef;
    private Map<String, Object> additionalProperties;

    public GitOpsClusterSpecFluent() {
    }

    public GitOpsClusterSpecFluent(GitOpsClusterSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GitOpsClusterSpec instance) {
        GitOpsClusterSpec gitOpsClusterSpec = instance = instance != null ? instance : new GitOpsClusterSpec();
        if (instance != null) {
            this.withArgoServer(instance.getArgoServer());
            this.withPlacementRef(instance.getPlacementRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ArgoServerSpec buildArgoServer() {
        return this.argoServer != null ? this.argoServer.build() : null;
    }

    public A withArgoServer(ArgoServerSpec argoServer) {
        this._visitables.remove((Object)"argoServer");
        if (argoServer != null) {
            this.argoServer = new ArgoServerSpecBuilder(argoServer);
            this._visitables.get((Object)"argoServer").add(this.argoServer);
        } else {
            this.argoServer = null;
            this._visitables.get((Object)"argoServer").remove((Object)this.argoServer);
        }
        return (A)((Object)this);
    }

    public boolean hasArgoServer() {
        return this.argoServer != null;
    }

    public A withNewArgoServer(String argoNamespace, String cluster) {
        return this.withArgoServer(new ArgoServerSpec(argoNamespace, cluster));
    }

    public ArgoServerNested<A> withNewArgoServer() {
        return new ArgoServerNested(null);
    }

    public ArgoServerNested<A> withNewArgoServerLike(ArgoServerSpec item) {
        return new ArgoServerNested(item);
    }

    public ArgoServerNested<A> editArgoServer() {
        return this.withNewArgoServerLike(Optional.ofNullable(this.buildArgoServer()).orElse(null));
    }

    public ArgoServerNested<A> editOrNewArgoServer() {
        return this.withNewArgoServerLike(Optional.ofNullable(this.buildArgoServer()).orElse(new ArgoServerSpecBuilder().build()));
    }

    public ArgoServerNested<A> editOrNewArgoServerLike(ArgoServerSpec item) {
        return this.withNewArgoServerLike(Optional.ofNullable(this.buildArgoServer()).orElse(item));
    }

    public ObjectReference buildPlacementRef() {
        return this.placementRef != null ? this.placementRef.build() : null;
    }

    public A withPlacementRef(ObjectReference placementRef) {
        this._visitables.remove((Object)"placementRef");
        if (placementRef != null) {
            this.placementRef = new ObjectReferenceBuilder(placementRef);
            this._visitables.get((Object)"placementRef").add(this.placementRef);
        } else {
            this.placementRef = null;
            this._visitables.get((Object)"placementRef").remove(this.placementRef);
        }
        return (A)((Object)this);
    }

    public boolean hasPlacementRef() {
        return this.placementRef != null;
    }

    public PlacementRefNested<A> withNewPlacementRef() {
        return new PlacementRefNested(null);
    }

    public PlacementRefNested<A> withNewPlacementRefLike(ObjectReference item) {
        return new PlacementRefNested(item);
    }

    public PlacementRefNested<A> editPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(null));
    }

    public PlacementRefNested<A> editOrNewPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public PlacementRefNested<A> editOrNewPlacementRefLike(ObjectReference item) {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitOpsClusterSpecFluent that = (GitOpsClusterSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.argoServer, (Object)that.argoServer)) {
            return false;
        }
        if (!Objects.equals(this.placementRef, that.placementRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.argoServer, this.placementRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.argoServer != null) {
            sb.append("argoServer:");
            sb.append((Object)((Object)this.argoServer) + ",");
        }
        if (this.placementRef != null) {
            sb.append("placementRef:");
            sb.append(this.placementRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlacementRefNested<N>
    extends ObjectReferenceFluent<PlacementRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        PlacementRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)GitOpsClusterSpecFluent.this.withPlacementRef(this.builder.build());
        }

        public N endPlacementRef() {
            return this.and();
        }
    }

    public class ArgoServerNested<N>
    extends ArgoServerSpecFluent<ArgoServerNested<N>>
    implements Nested<N> {
        ArgoServerSpecBuilder builder;

        ArgoServerNested(ArgoServerSpec item) {
            this.builder = new ArgoServerSpecBuilder(this, item);
        }

        public N and() {
            return (N)GitOpsClusterSpecFluent.this.withArgoServer(this.builder.build());
        }

        public N endArgoServer() {
            return this.and();
        }
    }
}

