/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistoryBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistoryFluent;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DetailsPerTemplateFluent<A extends DetailsPerTemplateFluent<A>>
extends BaseFluent<A> {
    private String compliant;
    private ArrayList<ComplianceHistoryBuilder> history = new ArrayList();
    private ObjectMetaBuilder templateMeta;
    private Map<String, Object> additionalProperties;

    public DetailsPerTemplateFluent() {
    }

    public DetailsPerTemplateFluent(DetailsPerTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DetailsPerTemplate instance) {
        DetailsPerTemplate detailsPerTemplate = instance = instance != null ? instance : new DetailsPerTemplate();
        if (instance != null) {
            this.withCompliant(instance.getCompliant());
            this.withHistory(instance.getHistory());
            this.withTemplateMeta(instance.getTemplateMeta());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCompliant() {
        return this.compliant;
    }

    public A withCompliant(String compliant) {
        this.compliant = compliant;
        return (A)((Object)this);
    }

    public boolean hasCompliant() {
        return this.compliant != null;
    }

    public A addToHistory(int index, ComplianceHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
        if (index < 0 || index >= this.history.size()) {
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        } else {
            this._visitables.get((Object)"history").add(index, builder);
            this.history.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHistory(int index, ComplianceHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
        if (index < 0 || index >= this.history.size()) {
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        } else {
            this._visitables.get((Object)"history").set(index, builder);
            this.history.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHistory(ComplianceHistory ... items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHistory(Collection<ComplianceHistory> items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHistory(ComplianceHistory ... items) {
        if (this.history == null) {
            return (A)((Object)this);
        }
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").remove((Object)builder);
            this.history.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHistory(Collection<ComplianceHistory> items) {
        if (this.history == null) {
            return (A)((Object)this);
        }
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").remove((Object)builder);
            this.history.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        if (this.history == null) {
            return (A)((Object)this);
        }
        Iterator<ComplianceHistoryBuilder> each = this.history.iterator();
        List visitables = this._visitables.get((Object)"history");
        while (each.hasNext()) {
            ComplianceHistoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ComplianceHistory> buildHistory() {
        return this.history != null ? DetailsPerTemplateFluent.build(this.history) : null;
    }

    public ComplianceHistory buildHistory(int index) {
        return this.history.get(index).build();
    }

    public ComplianceHistory buildFirstHistory() {
        return this.history.get(0).build();
    }

    public ComplianceHistory buildLastHistory() {
        return this.history.get(this.history.size() - 1).build();
    }

    public ComplianceHistory buildMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        for (ComplianceHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        for (ComplianceHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHistory(List<ComplianceHistory> history) {
        if (this.history != null) {
            this._visitables.get((Object)"history").clear();
        }
        if (history != null) {
            this.history = new ArrayList();
            for (ComplianceHistory item : history) {
                this.addToHistory(item);
            }
        } else {
            this.history = null;
        }
        return (A)((Object)this);
    }

    public A withHistory(ComplianceHistory ... history) {
        if (this.history != null) {
            this.history.clear();
            this._visitables.remove((Object)"history");
        }
        if (history != null) {
            for (ComplianceHistory item : history) {
                this.addToHistory(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHistory() {
        return this.history != null && !this.history.isEmpty();
    }

    public A addNewHistory(String eventName, String lastTimestamp, String message) {
        return this.addToHistory(new ComplianceHistory(eventName, lastTimestamp, message));
    }

    public HistoryNested<A> addNewHistory() {
        return new HistoryNested(-1, null);
    }

    public HistoryNested<A> addNewHistoryLike(ComplianceHistory item) {
        return new HistoryNested(-1, item);
    }

    public HistoryNested<A> setNewHistoryLike(int index, ComplianceHistory item) {
        return new HistoryNested(index, item);
    }

    public HistoryNested<A> editHistory(int index) {
        if (this.history.size() <= index) {
            throw new RuntimeException("Can't edit history. Index exceeds size.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public HistoryNested<A> editFirstHistory() {
        if (this.history.size() == 0) {
            throw new RuntimeException("Can't edit first history. The list is empty.");
        }
        return this.setNewHistoryLike(0, this.buildHistory(0));
    }

    public HistoryNested<A> editLastHistory() {
        int index = this.history.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last history. The list is empty.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public HistoryNested<A> editMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.history.size(); ++i) {
            if (!predicate.test(this.history.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching history. No match found.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public ObjectMeta buildTemplateMeta() {
        return this.templateMeta != null ? this.templateMeta.build() : null;
    }

    public A withTemplateMeta(ObjectMeta templateMeta) {
        this._visitables.remove((Object)"templateMeta");
        if (templateMeta != null) {
            this.templateMeta = new ObjectMetaBuilder(templateMeta);
            this._visitables.get((Object)"templateMeta").add(this.templateMeta);
        } else {
            this.templateMeta = null;
            this._visitables.get((Object)"templateMeta").remove(this.templateMeta);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplateMeta() {
        return this.templateMeta != null;
    }

    public TemplateMetaNested<A> withNewTemplateMeta() {
        return new TemplateMetaNested(null);
    }

    public TemplateMetaNested<A> withNewTemplateMetaLike(ObjectMeta item) {
        return new TemplateMetaNested(item);
    }

    public TemplateMetaNested<A> editTemplateMeta() {
        return this.withNewTemplateMetaLike(Optional.ofNullable(this.buildTemplateMeta()).orElse(null));
    }

    public TemplateMetaNested<A> editOrNewTemplateMeta() {
        return this.withNewTemplateMetaLike(Optional.ofNullable(this.buildTemplateMeta()).orElse(new ObjectMetaBuilder().build()));
    }

    public TemplateMetaNested<A> editOrNewTemplateMetaLike(ObjectMeta item) {
        return this.withNewTemplateMetaLike(Optional.ofNullable(this.buildTemplateMeta()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DetailsPerTemplateFluent that = (DetailsPerTemplateFluent)((Object)o);
        if (!Objects.equals(this.compliant, that.compliant)) {
            return false;
        }
        if (!Objects.equals(this.history, that.history)) {
            return false;
        }
        if (!Objects.equals(this.templateMeta, that.templateMeta)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compliant, this.history, this.templateMeta, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliant != null) {
            sb.append("compliant:");
            sb.append(this.compliant + ",");
        }
        if (this.history != null && !this.history.isEmpty()) {
            sb.append("history:");
            sb.append(this.history + ",");
        }
        if (this.templateMeta != null) {
            sb.append("templateMeta:");
            sb.append(this.templateMeta + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateMetaNested<N>
    extends ObjectMetaFluent<TemplateMetaNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        TemplateMetaNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)DetailsPerTemplateFluent.this.withTemplateMeta(this.builder.build());
        }

        public N endTemplateMeta() {
            return this.and();
        }
    }

    public class HistoryNested<N>
    extends ComplianceHistoryFluent<HistoryNested<N>>
    implements Nested<N> {
        ComplianceHistoryBuilder builder;
        int index;

        HistoryNested(int index, ComplianceHistory item) {
            this.index = index;
            this.builder = new ComplianceHistoryBuilder(this, item);
        }

        public N and() {
            return (N)DetailsPerTemplateFluent.this.setToHistory(this.index, this.builder.build());
        }

        public N endHistory() {
            return this.and();
        }
    }
}

