/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressIPSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EgressIPSpecFluent<A extends EgressIPSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> egressIPs = new ArrayList<String>();
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder podSelector;
    private Map<String, Object> additionalProperties;

    public EgressIPSpecFluent() {
    }

    public EgressIPSpecFluent(EgressIPSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EgressIPSpec instance) {
        EgressIPSpec egressIPSpec = instance = instance != null ? instance : new EgressIPSpec();
        if (instance != null) {
            this.withEgressIPs(instance.getEgressIPs());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withPodSelector(instance.getPodSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEgressIPs(int index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToEgressIPs(int index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.egressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.egressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEgressIPs() {
        return this.egressIPs;
    }

    public String getEgressIP(int index) {
        return this.egressIPs.get(index);
    }

    public String getFirstEgressIP() {
        return this.egressIPs.get(0);
    }

    public String getLastEgressIP() {
        return this.egressIPs.get(this.egressIPs.size() - 1);
    }

    public String getMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgressIPs(List<String> egressIPs) {
        if (egressIPs != null) {
            this.egressIPs = new ArrayList<String>();
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        } else {
            this.egressIPs = null;
        }
        return (A)((Object)this);
    }

    public A withEgressIPs(String ... egressIPs) {
        if (this.egressIPs != null) {
            this.egressIPs.clear();
            this._visitables.remove((Object)"egressIPs");
        }
        if (egressIPs != null) {
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEgressIPs() {
        return this.egressIPs != null && !this.egressIPs.isEmpty();
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove((Object)"namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.remove((Object)"podSelector");
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get((Object)"podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get((Object)"podSelector").remove(this.podSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasPodSelector() {
        return this.podSelector != null;
    }

    public PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNested(null);
    }

    public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNested(item);
    }

    public PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(null));
    }

    public PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressIPSpecFluent that = (EgressIPSpecFluent)((Object)o);
        if (!Objects.equals(this.egressIPs, that.egressIPs)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.egressIPs, this.namespaceSelector, this.podSelector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egressIPs != null && !this.egressIPs.isEmpty()) {
            sb.append("egressIPs:");
            sb.append(this.egressIPs + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodSelectorNested<N>
    extends LabelSelectorFluent<PodSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        PodSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)EgressIPSpecFluent.this.withPodSelector(this.builder.build());
        }

        public N endPodSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)EgressIPSpecFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }
}

