/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressServiceSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EgressServiceSpecFluent<A extends EgressServiceSpecFluent<A>>
extends BaseFluent<A> {
    private String network;
    private LabelSelectorBuilder nodeSelector;
    private String sourceIPBy;
    private Map<String, Object> additionalProperties;

    public EgressServiceSpecFluent() {
    }

    public EgressServiceSpecFluent(EgressServiceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EgressServiceSpec instance) {
        EgressServiceSpec egressServiceSpec = instance = instance != null ? instance : new EgressServiceSpec();
        if (instance != null) {
            this.withNetwork(instance.getNetwork());
            this.withNodeSelector(instance.getNodeSelector());
            this.withSourceIPBy(instance.getSourceIPBy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)((Object)this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public LabelSelector buildNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    public A withNodeSelector(LabelSelector nodeSelector) {
        this._visitables.remove((Object)"nodeSelector");
        if (nodeSelector != null) {
            this.nodeSelector = new LabelSelectorBuilder(nodeSelector);
            this._visitables.get((Object)"nodeSelector").add(this.nodeSelector);
        } else {
            this.nodeSelector = null;
            this._visitables.get((Object)"nodeSelector").remove(this.nodeSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNested(null);
    }

    public NodeSelectorNested<A> withNewNodeSelectorLike(LabelSelector item) {
        return new NodeSelectorNested(item);
    }

    public NodeSelectorNested<A> editNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(null));
    }

    public NodeSelectorNested<A> editOrNewNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NodeSelectorNested<A> editOrNewNodeSelectorLike(LabelSelector item) {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(item));
    }

    public String getSourceIPBy() {
        return this.sourceIPBy;
    }

    public A withSourceIPBy(String sourceIPBy) {
        this.sourceIPBy = sourceIPBy;
        return (A)((Object)this);
    }

    public boolean hasSourceIPBy() {
        return this.sourceIPBy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressServiceSpecFluent that = (EgressServiceSpecFluent)((Object)o);
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.sourceIPBy, that.sourceIPBy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.network, this.nodeSelector, this.sourceIPBy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.sourceIPBy != null) {
            sb.append("sourceIPBy:");
            sb.append(this.sourceIPBy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NodeSelectorNested<N>
    extends LabelSelectorFluent<NodeSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NodeSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)EgressServiceSpecFluent.this.withNodeSelector(this.builder.build());
        }

        public N endNodeSelector() {
            return this.and();
        }
    }
}

