/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ovn.v1.DynamicHop;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DynamicHopFluent<A extends DynamicHopFluent<A>>
extends BaseFluent<A> {
    private Boolean bfdEnabled;
    private LabelSelectorBuilder namespaceSelector;
    private String networkAttachmentName;
    private LabelSelectorBuilder podSelector;
    private Map<String, Object> additionalProperties;

    public DynamicHopFluent() {
    }

    public DynamicHopFluent(DynamicHop instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DynamicHop instance) {
        DynamicHop dynamicHop = instance = instance != null ? instance : new DynamicHop();
        if (instance != null) {
            this.withBfdEnabled(instance.getBfdEnabled());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withNetworkAttachmentName(instance.getNetworkAttachmentName());
            this.withPodSelector(instance.getPodSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getBfdEnabled() {
        return this.bfdEnabled;
    }

    public A withBfdEnabled(Boolean bfdEnabled) {
        this.bfdEnabled = bfdEnabled;
        return (A)((Object)this);
    }

    public boolean hasBfdEnabled() {
        return this.bfdEnabled != null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove((Object)"namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public String getNetworkAttachmentName() {
        return this.networkAttachmentName;
    }

    public A withNetworkAttachmentName(String networkAttachmentName) {
        this.networkAttachmentName = networkAttachmentName;
        return (A)((Object)this);
    }

    public boolean hasNetworkAttachmentName() {
        return this.networkAttachmentName != null;
    }

    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.remove((Object)"podSelector");
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get((Object)"podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get((Object)"podSelector").remove(this.podSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasPodSelector() {
        return this.podSelector != null;
    }

    public PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNested(null);
    }

    public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNested(item);
    }

    public PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(null));
    }

    public PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicHopFluent that = (DynamicHopFluent)((Object)o);
        if (!Objects.equals(this.bfdEnabled, that.bfdEnabled)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.networkAttachmentName, that.networkAttachmentName)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.bfdEnabled, this.namespaceSelector, this.networkAttachmentName, this.podSelector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bfdEnabled != null) {
            sb.append("bfdEnabled:");
            sb.append(this.bfdEnabled + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.networkAttachmentName != null) {
            sb.append("networkAttachmentName:");
            sb.append(this.networkAttachmentName + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withBfdEnabled() {
        return this.withBfdEnabled(true);
    }

    public class PodSelectorNested<N>
    extends LabelSelectorFluent<PodSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        PodSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)DynamicHopFluent.this.withPodSelector(this.builder.build());
        }

        public N endPodSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)DynamicHopFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }
}

