/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator.model;

import io.fabric8.kubernetes.schema.generator.ApiVersion;
import io.fabric8.kubernetes.schema.generator.GeneratorSettings;
import io.fabric8.kubernetes.schema.generator.ImportManager;
import io.fabric8.kubernetes.schema.generator.model.ClassInformation;
import io.fabric8.kubernetes.schema.generator.schema.SchemaUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

final class TemplateContext
implements ImportManager {
    private final String classKey;
    private final Schema<?> classSchema;
    private final ApiVersion apiVersion;
    private final ClassInformation classInformation;
    private final Map<String, Object> context;

    TemplateContext(GeneratorSettings settings, Map.Entry<String, Schema<?>> clazz) {
        SchemaUtils schemaUtils = new SchemaUtils(settings);
        this.classKey = clazz.getKey();
        this.classSchema = clazz.getValue();
        this.apiVersion = settings.getApiVersions().get(this.classKey);
        this.classInformation = new ClassInformation(schemaUtils, clazz);
        this.context = new HashMap<String, Object>();
        this.context.put("imports", this.classInformation.getImports());
        this.context.put("classInformation", this.classInformation);
    }

    void put(String key, Object value) {
        this.context.put(key, value);
    }

    Map<String, Schema> getSchemaProperties() {
        return this.classSchema.getProperties() == null ? Collections.emptyMap() : this.classSchema.getProperties();
    }

    @Override
    public String getPackageName() {
        return this.getClassInformation().getPackageName();
    }

    @Override
    public Collection<String> getImports() {
        return this.getClassInformation().getImports();
    }

    @Override
    public boolean hasSimpleClassName(String className) {
        return this.getClassInformation().hasSimpleClassName(className);
    }

    @Generated
    public String getClassKey() {
        return this.classKey;
    }

    @Generated
    public Schema<?> getClassSchema() {
        return this.classSchema;
    }

    @Generated
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public ClassInformation getClassInformation() {
        return this.classInformation;
    }

    @Generated
    public Map<String, Object> getContext() {
        return this.context;
    }
}

