/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl;

import com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ProcessableClientResource;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.OpenshiftOperation;
import java.net.MalformedURLException;
import java.net.URL;

public class TemplateOperationsImpl
extends OpenshiftOperation<OpenShiftClient, Template, TemplateList, DoneableTemplate, ProcessableClientResource<Template, DoneableTemplate>>
implements ProcessableClientResource<Template, DoneableTemplate> {
    public TemplateOperationsImpl(OpenShiftClient client) {
        super(client, "templates", null, null);
    }

    public TemplateOperationsImpl(OpenShiftClient client, String namespace, String name) {
        super(client, "templates", namespace, name);
    }

    public Template process(Template item) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = null;
        try {
            requestBuilder = ((OpenShiftClient)this.getClient()).getHttpClient().preparePost(this.getProcessUrl().toString());
            requestBuilder.setBody(mapper.writer().writeValueAsString((Object)item));
            return (Template)this.handleResponse(requestBuilder, 201);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private URL getProcessUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(requestUrl, "namespaces/" + this.getNamespace() + "/");
        }
        requestUrl = new URL(requestUrl, "processedtemplates/");
        return requestUrl;
    }
}

