/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenshiftAdapterSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import okhttp3.TlsVersion;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true, allowGetters=true, allowSetters=true)
public class OpenShiftConfig
extends Config {
    public static final String KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY = "kubernetes.oapi.version";
    public static final String OPENSHIFT_URL_SYTEM_PROPERTY = "openshift.url";
    public static final String OPENSHIFT_BUILD_TIMEOUT_SYSTEM_PROPERTY = "openshift.build.timeout";
    public static final Long DEFAULT_BUILD_TIMEOUT = 300000L;
    private String oapiVersion = "v1";
    private String openShiftUrl;
    private boolean disableApiGroupCheck;
    private long buildTimeout = DEFAULT_BUILD_TIMEOUT;

    OpenShiftConfig() {
    }

    public OpenShiftConfig(Config kubernetesConfig) {
        this(kubernetesConfig, OpenShiftConfig.getDefaultOpenShiftUrl(kubernetesConfig), OpenShiftConfig.getDefaultOapiVersion(kubernetesConfig), DEFAULT_BUILD_TIMEOUT);
    }

    public OpenShiftConfig(Config kubernetesConfig, String openShiftUrl) {
        this(kubernetesConfig, OpenShiftConfig.getDefaultOpenShiftUrl(kubernetesConfig), OpenShiftConfig.getDefaultOapiVersion(kubernetesConfig), DEFAULT_BUILD_TIMEOUT);
        this.openShiftUrl = openShiftUrl;
    }

    public OpenShiftConfig(String openShiftUrl, String oapiVersion, String masterUrl, String apiVersion, String namespace, Boolean trustCerts, String caCertFile, String caCertData, String clientCertFile, String clientCertData, String clientKeyFile, String clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String username, String password, String oauthToken, int watchReconnectInterval, int watchReconnectLimit, int connectionTimeout, int requestTimeout, long rollingTimeout, long scaleTimeout, int loggingInterval, Integer maxConcurrentRequestsPerHost, String httpProxy, String httpsProxy, String[] noProxy, Map<Integer, String> errorMessages, String userAgent, TlsVersion[] tlsVersions, long buildTimeout, long websocketTimeout, long websocketPingInterval, String proxyUsername, String proxyPassword, String trustStoreFile, String trustStorePassphrase, String keyStoreFile, String keyStorePassphrase, String impersonateUsername, String impersonateGroup, Map<String, String> impersonateExtras) {
        super(masterUrl, apiVersion, namespace, trustCerts.booleanValue(), caCertFile, caCertData, clientCertFile, clientCertData, clientKeyFile, clientKeyData, clientKeyAlgo, clientKeyPassphrase, username, password, oauthToken, watchReconnectInterval, watchReconnectLimit, connectionTimeout, requestTimeout, rollingTimeout, scaleTimeout, loggingInterval, maxConcurrentRequestsPerHost.intValue(), httpProxy, httpsProxy, noProxy, errorMessages, userAgent, tlsVersions, websocketTimeout, websocketPingInterval, proxyUsername, proxyPassword, trustStoreFile, trustStorePassphrase, keyStoreFile, keyStorePassphrase, impersonateUsername, impersonateGroup, impersonateExtras);
        this.oapiVersion = oapiVersion;
        this.openShiftUrl = openShiftUrl;
        this.buildTimeout = buildTimeout;
        if (this.openShiftUrl == null || this.openShiftUrl.isEmpty()) {
            this.openShiftUrl = URLUtils.join((String[])new String[]{this.getMasterUrl(), "oapi", this.oapiVersion});
        }
        if (!this.openShiftUrl.endsWith("/")) {
            this.openShiftUrl = this.openShiftUrl + "/";
        }
    }

    public OpenShiftConfig(Config kubernetesConfig, String openShiftUrl, String oapiVersion, long buildTimeout) {
        this(openShiftUrl, oapiVersion, kubernetesConfig.getMasterUrl(), kubernetesConfig.getApiVersion(), kubernetesConfig.getNamespace(), kubernetesConfig.isTrustCerts(), kubernetesConfig.getCaCertFile(), kubernetesConfig.getCaCertData(), kubernetesConfig.getClientCertFile(), kubernetesConfig.getClientCertData(), kubernetesConfig.getClientKeyFile(), kubernetesConfig.getClientKeyData(), kubernetesConfig.getClientKeyAlgo(), kubernetesConfig.getClientKeyPassphrase(), kubernetesConfig.getUsername(), kubernetesConfig.getPassword(), kubernetesConfig.getOauthToken(), kubernetesConfig.getWatchReconnectInterval(), kubernetesConfig.getWatchReconnectLimit(), kubernetesConfig.getConnectionTimeout(), kubernetesConfig.getRequestTimeout(), kubernetesConfig.getRollingTimeout(), kubernetesConfig.getScaleTimeout(), kubernetesConfig.getLoggingInterval(), kubernetesConfig.getMaxConcurrentRequestsPerHost(), kubernetesConfig.getHttpProxy(), kubernetesConfig.getHttpsProxy(), kubernetesConfig.getNoProxy(), kubernetesConfig.getErrorMessages(), kubernetesConfig.getUserAgent(), kubernetesConfig.getTlsVersions(), buildTimeout, kubernetesConfig.getWebsocketTimeout(), kubernetesConfig.getWebsocketPingInterval(), kubernetesConfig.getProxyUsername(), kubernetesConfig.getProxyPassword(), kubernetesConfig.getTrustStoreFile(), kubernetesConfig.getTrustStorePassphrase(), kubernetesConfig.getKeyStoreFile(), kubernetesConfig.getKeyStorePassphrase(), kubernetesConfig.getImpersonateUsername(), kubernetesConfig.getImpersonateGroup(), kubernetesConfig.getImpersonateExtras());
    }

    public static OpenShiftConfig wrap(Config config) {
        return config instanceof OpenShiftConfig ? (OpenShiftConfig)config : new OpenShiftConfig(config);
    }

    public boolean isOpenShiftAPIGroups(OpenShiftClient openShiftClient) {
        if (this.isDisableApiGroupCheck()) {
            return false;
        }
        return OpenshiftAdapterSupport.isOpenShiftAPIGroups((Client)openShiftClient);
    }

    private static String getDefaultOapiVersion(Config config) {
        return Utils.getSystemPropertyOrEnvVar((String)KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY, (String)config.getApiVersion());
    }

    private static String getDefaultOpenShiftUrl(Config config) {
        String openshiftUrl = Utils.getSystemPropertyOrEnvVar((String)OPENSHIFT_URL_SYTEM_PROPERTY);
        if (openshiftUrl != null) {
            if (OpenShiftConfig.isRootURL(openshiftUrl)) {
                openshiftUrl = URLUtils.join((String[])new String[]{openshiftUrl, "oapi", OpenShiftConfig.getDefaultOapiVersion(config)});
            }
            return openshiftUrl;
        }
        return URLUtils.join((String[])new String[]{config.getMasterUrl(), "oapi", OpenShiftConfig.getDefaultOapiVersion(config)});
    }

    private static boolean isRootURL(String url) {
        try {
            String path = new URL(url).getPath();
            return "".equals(path) || "/".equals(path);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @JsonProperty(value="oapiVersion")
    public String getOapiVersion() {
        return this.oapiVersion;
    }

    public void setOapiVersion(String oapiVersion) {
        this.oapiVersion = oapiVersion;
    }

    @JsonProperty(value="openShiftUrl")
    public String getOpenShiftUrl() {
        return this.openShiftUrl;
    }

    public void setOpenShiftUrl(String openShiftUrl) {
        this.openShiftUrl = openShiftUrl;
    }

    @JsonProperty(value="buildTimeout")
    public long getBuildTimeout() {
        return this.buildTimeout;
    }

    public void setBuildTimeout(long buildTimeout) {
        this.buildTimeout = buildTimeout;
    }

    public boolean isDisableApiGroupCheck() {
        return this.disableApiGroupCheck;
    }

    public void setDisableApiGroupCheck(boolean disableApiGroupCheck) {
        this.disableApiGroupCheck = disableApiGroupCheck;
    }
}

