  
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ClusterRoleBindingOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ClusterRoleBindingHandler implements ResourceHandler<ClusterRoleBinding, ClusterRoleBindingBuilder> {

  @Override
  public String getKind() {
    return ClusterRoleBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "authorization.openshift.io/v1";
    }

  @Override
  public ClusterRoleBinding create(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item) {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ClusterRoleBinding replace(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item) {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ClusterRoleBinding reload(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item) {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ClusterRoleBindingBuilder edit(ClusterRoleBinding item) {
    return new ClusterRoleBindingBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterRoleBinding item) {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, Watcher<ClusterRoleBinding> watcher) {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, String resourceVersion, Watcher<ClusterRoleBinding> watcher) {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public ClusterRoleBinding waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ClusterRoleBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, Predicate<ClusterRoleBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
