  
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OAuthAccessTokenHandler implements ResourceHandler<OAuthAccessToken, OAuthAccessTokenBuilder> {

  @Override
  public String getKind() {
    return OAuthAccessToken.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public OAuthAccessToken create(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public OAuthAccessToken replace(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public OAuthAccessToken reload(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OAuthAccessTokenBuilder edit(OAuthAccessToken item) {
    return new OAuthAccessTokenBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, OAuthAccessToken item) {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, Watcher<OAuthAccessToken> watcher) {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, String resourceVersion, Watcher<OAuthAccessToken> watcher) {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public OAuthAccessToken waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OAuthAccessToken waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, Predicate<OAuthAccessToken> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
