  
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OAuthClientHandler implements ResourceHandler<OAuthClient, OAuthClientBuilder> {

  @Override
  public String getKind() {
    return OAuthClient.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public OAuthClient create(OkHttpClient client, Config config, String namespace, OAuthClient item) {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public OAuthClient replace(OkHttpClient client, Config config, String namespace, OAuthClient item) {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public OAuthClient reload(OkHttpClient client, Config config, String namespace, OAuthClient item) {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OAuthClientBuilder edit(OAuthClient item) {
    return new OAuthClientBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, OAuthClient item) {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, Watcher<OAuthClient> watcher) {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, String resourceVersion, Watcher<OAuthClient> watcher) {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public OAuthClient waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthClient item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OAuthClient waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthClient item, Predicate<OAuthClient> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
