/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ImageStreamOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageStreamHandler
implements ResourceHandler<ImageStream, ImageStreamBuilder> {
    public String getKind() {
        return ImageStream.class.getSimpleName();
    }

    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    public ImageStream create(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create((Object[])new ImageStream[0]);
    }

    public ImageStream replace(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ImageStream reload(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)((Gettable)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ImageStreamBuilder edit(ImageStream item) {
        return new ImageStreamBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ImageStream item) {
        return (Boolean)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, Watcher<ImageStream> watcher) {
        return (Watch)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, String resourceVersion, Watcher<ImageStream> watcher) {
        return (Watch)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public ImageStream waitUntilReady(OkHttpClient client, Config config, String namespace, ImageStream item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ImageStream waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageStream item, Predicate<ImageStream> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

