
                
      

package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.DoneableAlertmanager;
import io.fabric8.openshift.api.model.monitoring.v1.Alertmanager;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerList;
import io.fabric8.openshift.api.model.monitoring.v1.DoneableAlertmanager;

import java.util.Map;
import java.util.TreeMap;


public class AlertmanagerOperationsImpl extends OpenShiftOperation<Alertmanager, AlertmanagerList, DoneableAlertmanager, Resource<Alertmanager, DoneableAlertmanager>> {

  public AlertmanagerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public AlertmanagerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("monitoring.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("alertmanagers"));
    this.type = Alertmanager.class;
    this.listType = AlertmanagerList.class;
    this.doneableType = DoneableAlertmanager.class;
  }

  public AlertmanagerOperationsImpl newInstance(OperationContext context) {
    return new AlertmanagerOperationsImpl(context);
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
